/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.wizard.project;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.FileTypesRecognizer;
import oracle.ide.config.GlobalIgnoreList;
import oracle.ide.controls.checkboxlist.CheckBoxListItemStateListener;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.TechnologyScopeConfiguration;
import oracle.ide.model.TechnologyScopeManager;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLTextField;
import oracle.ide.resource.DirOptionsArb;
import oracle.ide.util.IntersectedFilters;
import oracle.ide.util.Namespace;
import oracle.ide.util.PatternFilter;
import oracle.ide.util.PatternFilters;
import oracle.ide.util.ResourceUtils;
import oracle.ide.util.TriStateBoolean;
import oracle.ideri.importexport.ImportWizard;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdevimpl.model.FilesPatternFilterPanel;
import oracle.jdevimpl.model.WorkingSetsEditor;
import oracle.jdevimpl.resource.WizardsArb;

public abstract class AbstractCopySourceIntoProjectWizard
extends JPanel
implements ImportWizard,
ActionListener,
DocumentListener,
VetoableChangeListener,
Runnable {
    public static final String CONTEXT_KEY = "Context";
    private JEWTDialog _dialog;
    private Namespace _namespace;
    private URLTextField _urlFld = new URLTextField(null, true);
    private JButton _browseBtn;
    private JButton _filterBtn;
    private URLTextField _copyToURLFld;
    private JButton _copyToBrowseBtn;
    private Project _tempProject;
    private ContentSet _contentSet;
    protected Project _addToProject;
    private ProgressBar _progressBar;
    private List _copiedFileList;
    private PatternFilters _filePatternFilters;
    private Document _copyToDocument;
    private Document _copyFromDocument;
    public static final String IMPORT_PROPERTY = "oracle.jdeveloper.wizard.project.AbstractCopySourceIntoProjectWizard";
    public static final String IMPORT_BEGIN = "BeginImport";
    public static final String IMPORT_END = "EndImport";
    public static final String IMPORT_FILE_LIST = "ImportFileList";

    public Icon getImportWizardIcon(Context context) {
        return UIManager.getIcon("FileView.directoryIcon");
    }

    public abstract String getImportWizardName(Context var1);

    public abstract String getImportWizardTooltipText(Context var1);

    public abstract String getHelpID();

    public abstract String getDialogHeaderDescription();

    public abstract String getDialogTitle();

    protected abstract boolean validateData(URL var1, ContentSet var2);

    protected void configureBrowseButton(JButton browseButton, URLTextField copyToFld) {
        browseButton.addActionListener((ActionListener)copyToFld);
    }

    protected URL getDefaultCopyToURL() {
        return null;
    }

    public boolean isAvailableAsImportWizard(Context context) {
        return context.getProject() != null;
    }

    protected static boolean isDirectoryInContentSet(URL directoryURL, ContentSet contentSet) {
        return contentSet.toRelativePath(directoryURL) != null;
    }

    protected static void addDirectoryURLToContentSet(URL directoryURL, ContentSet contentSet) {
        contentSet.getURLPath().add(directoryURL);
    }

    protected void processData(ContentSet copyFromContentSet, URL copyToURL, String rootSpec) {
        this._progressBar = new ProgressBar((Component)this, WizardsArb.getString(478), (Runnable)this, true);
        this._progressBar.start(DirOptionsArb.getString((int)2), null);
        this._progressBar.waitUntilDone();
    }

    protected Context getContext() {
        return (Context)this._namespace.get(CONTEXT_KEY);
    }

    protected Dialog getDialog() {
        return this._dialog;
    }

    public final boolean invokeImportWizard(Context context, String[] params) {
        this._addToProject = context.getProject();
        if (this._addToProject == null) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)WizardsArb.getString(530), (String)WizardsArb.getString(529), null);
            return false;
        }
        this._urlFld.setURL(null);
        this._namespace = new Namespace();
        this._namespace.put(CONTEXT_KEY, (Object)context);
        this._copiedFileList = new ArrayList();
        this._tempProject = new Project();
        Project defProj = Ide.getDefaultProject();
        if (defProj != null) {
            defProj.copyTo((Object)this._tempProject);
        }
        PathsConfiguration.getInstance((Project)this._tempProject).setProjectSourcePath(null);
        this._namespace.put("Project", (Object)this._tempProject);
        this._contentSet = ContentSet.getInstance((PropertyStorage)this._tempProject, (String)PathsConfiguration.JAVA_CONTENT_SET_KEY);
        PatternFilters patternFilters = this._contentSet.getPatternFilters();
        if (!patternFilters.containsFilters()) {
            patternFilters.addInclude("**");
        }
        WorkingSetsEditor.setPatternFilters(this._namespace, patternFilters);
        this._initUI();
        this._filterBtn.setEnabled(false);
        if (this.showDialog()) {
            this.processData(this._contentSet, this._copyToURLFld.getURL(), this._urlFld.getText());
            return true;
        }
        return false;
    }

    private boolean showDialog() {
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, this.getHelpID());
        this._dialog = DialogUtil.createJEWTDialogOwnedBy((Component)Ide.getMainWindow());
        if (this._dialog == null) {
            return false;
        }
        DialogHeader dlgHeader = new DialogHeader();
        dlgHeader.setHeaderDescription(this.getDialogHeaderDescription());
        this._dialog.setDialogHeader((Component)dlgHeader);
        this._dialog.setContent((Component)this);
        this._dialog.setOKButtonEnabled(false);
        this._dialog.setInitialFocus((Component)this._urlFld);
        this._dialog.addVetoableChangeListener((VetoableChangeListener)this);
        this._dialog.setTitle(this.getDialogTitle());
        this._dialog.setButtonMask(7);
        this._dialog.setResizable(true);
        this._dialog.pack();
        boolean retval = false;
        try {
            retval = this._dialog.runDialog();
            return retval;
        }
        finally {
            this._dialog.dispose();
            this._dialog = null;
            return retval;
        }
    }

    @Override
    public final void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt)) {
            URL copyToURL = this._copyToURLFld.getURL();
            if (copyToURL == null) {
                throw new PropertyVetoException("no", evt);
            }
            ProjectContent projectContent = ProjectContent.getInstance((PropertyStorage)this._addToProject);
            ContentSet contentSet = projectContent.getContentSet(PathsConfiguration.JAVA_CONTENT_SET_KEY);
            if (!this.validateData(copyToURL, contentSet)) {
                throw new PropertyVetoException("no", evt);
            }
        }
    }

    private void _copyFiles() {
        ContentSet copyFromContentSet = this._contentSet;
        URL copyToURL = this._copyToURLFld.getURL();
        if (copyFromContentSet != null && copyFromContentSet.getContentFolderURL() == null) {
            URL url = this._urlFld.getURL();
            copyFromContentSet.setContentFolderURL(url);
            copyFromContentSet.getURLPath().add(url);
        }
        String rootSpec = this._urlFld.getText();
        IntersectedFilters iFilters = new IntersectedFilters(GlobalIgnoreList.getPatternFilters());
        if (this._filePatternFilters != null) {
            iFilters = iFilters.intersectWith(this._filePatternFilters);
        }
        UpdateMessage startMsg = new UpdateMessage(UpdateMessage.STRUCTURE_CHANGED, (Object)this._addToProject);
        startMsg.setProperty(IMPORT_PROPERTY, (Object)IMPORT_BEGIN);
        this._addToProject.notifyObservers((Object)this._addToProject, startMsg);
        Iterator urlIterator = copyFromContentSet.urlIterator(null);
        URL baseURL = URLFactory.newDirURL((String)rootSpec);
        URL urlToCopy = null;
        HashSet technologyScopes = new HashSet();
        while (urlIterator.hasNext()) {
            TriStateBoolean tsb;
            boolean shouldCopy;
            if (this._progressBar.hasUserCancelled()) {
                return;
            }
            urlToCopy = (URL)urlIterator.next();
            this._progressBar.sleepForUIToRepaint();
            if (!iFilters.isIncluded(urlToCopy.getPath()) || !(shouldCopy = (tsb = iFilters.inferFromFilters(urlToCopy.getPath())).isTrue())) continue;
            this._progressBar.updateProgress(WizardsArb.getString(479), URLFileSystem.getPlatformPathName((URL)urlToCopy));
            this._copyFile(baseURL, copyToURL, urlToCopy);
            try {
                technologyScopes.addAll(TechnologyScopeManager.getTechnologyScopeManager().getDetector().detectTechnologyScopeIdsOfURL(this._addToProject, urlToCopy));
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!technologyScopes.isEmpty()) {
            TechnologyScopeConfiguration.getInstance((PropertyStorage)this._addToProject).updateTechnologyScope(technologyScopes.toArray(new String[technologyScopes.size()]));
        }
        this._progressBar.setDoneStatus();
        UpdateMessage endMsg = new UpdateMessage(UpdateMessage.STRUCTURE_CHANGED, (Object)this._addToProject);
        endMsg.setProperty(IMPORT_PROPERTY, (Object)IMPORT_END);
        endMsg.setProperty(IMPORT_FILE_LIST, (Object)this._copiedFileList);
        this._addToProject.notifyObservers((Object)this._addToProject, endMsg);
    }

    private void _copyFile(URL baseURL, URL copyRoot, URL urlToCopy) {
        String baseURLText;
        int pos;
        String relativeSpec = null;
        String urlString = urlToCopy.toString();
        if (urlString.indexOf("!/") > 0 && (pos = urlString.indexOf(baseURLText = baseURL.toString())) > 0) {
            relativeSpec = urlString.substring(pos + baseURLText.length());
        }
        if (relativeSpec == null) {
            relativeSpec = URLFileSystem.toRelativeSpec((URL)urlToCopy, (URL)baseURL);
        }
        URL copyToURL = URLFactory.newURL((URL)copyRoot, relativeSpec);
        try {
            URLFileSystem.copy((URL)urlToCopy, (URL)copyToURL);
            this._copiedFileList.add(copyToURL);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        this._copyFiles();
    }

    private void _handleButtons(Document document) {
        if (document == this._copyFromDocument) {
            if (this._urlFld.getURL() == null) {
                this._filterBtn.setEnabled(false);
            } else {
                this._filterBtn.setEnabled(true);
            }
        }
        if (this._dialog != null) {
            if (this._copyToURLFld.getURL() == null || this._urlFld.getURL() == null) {
                this._dialog.setOKButtonEnabled(false);
            } else {
                this._dialog.setOKButtonEnabled(true);
            }
        }
    }

    private void _initUI() {
        if (this._browseBtn == null) {
            this.setLayout(new GridBagLayout());
            JLabel label = new JLabel();
            ResourceUtils.resLabel((JLabel)label, (Component)this._urlFld, (String)WizardsArb.getString(473));
            this._browseBtn = new JButton();
            ResourceUtils.resButton((AbstractButton)this._browseBtn, (String)WizardsArb.getString(474));
            this._browseBtn.addActionListener(this);
            JLabel copyToLabel = new JLabel();
            this._copyToURLFld = new URLTextField(null, true);
            ResourceUtils.resLabel((JLabel)copyToLabel, (Component)this._copyToURLFld, (String)WizardsArb.getString(475));
            this._copyToBrowseBtn = new JButton();
            ResourceUtils.resButton((AbstractButton)this._copyToBrowseBtn, (String)WizardsArb.getString(476));
            this.configureBrowseButton(this._copyToBrowseBtn, this._copyToURLFld);
            this.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
            this.add((Component)this._urlFld, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
            this._urlFld.addActionListener((ActionListener)this);
            this.add((Component)this._browseBtn, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
            this._filterBtn = new JButton();
            ResourceUtils.resButton((AbstractButton)this._filterBtn, (String)WizardsArb.getString(41));
            this._filterBtn.addActionListener(this);
            this.add((Component)this._filterBtn, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
            this.add((Component)copyToLabel, new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
            this.add((Component)this._copyToURLFld, new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
            this.add((Component)this._copyToBrowseBtn, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        } else {
            this._copyToURLFld.getDocument().removeDocumentListener(this);
            this._urlFld.getDocument().removeDocumentListener(this);
        }
        this._copyToURLFld.setURL(this.getDefaultCopyToURL());
        this._copyToDocument = this._copyToURLFld.getDocument();
        this._copyToDocument.addDocumentListener(this);
        this._copyFromDocument = this._urlFld.getDocument();
        this._copyFromDocument.addDocumentListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this._filterBtn) {
            MyFilesPatternFilterPanel filterPanel = new MyFilesPatternFilterPanel(this._filePatternFilters);
            filterPanel.hideCheckSubdirectories();
            this._filePatternFilters = (PatternFilters)this._contentSet.getPatternFilters().copyTo(null);
            URL url = this._urlFld.getURL();
            String urlString = URLFileSystem.getPath((URL)url);
            if (filterPanel.showDialog(this, this._filePatternFilters, urlString)) {
                if (!AbstractCopySourceIntoProjectWizard.containsExludeFilter(this._filePatternFilters.getFilters())) {
                    PatternFilter[] filters = AbstractCopySourceIntoProjectWizard.removeIncludeAllFilter(this._filePatternFilters.getFilters());
                    this._filePatternFilters.setFilters(filters);
                }
            } else {
                this._filePatternFilters = null;
            }
        } else if (e.getSource() instanceof JButton) {
            this._urlFld.actionPerformed(e);
            URL url = this._urlFld.getURL();
            if (url != null) {
                if (this._contentSet != null) {
                    this._contentSet.setContentFolderURL(url);
                    this._contentSet.getURLPath().add(url);
                }
                if (this._urlFld.getURL() != null) {
                    this._dialog.setOKButtonEnabled(true);
                    this._filterBtn.setEnabled(true);
                } else {
                    this._dialog.setOKButtonEnabled(false);
                    this._filterBtn.setEnabled(false);
                }
            }
        }
    }

    private static boolean containsExludeFilter(PatternFilter[] pFilters) {
        for (PatternFilter filter : pFilters) {
            if (!filter.isExclude()) continue;
            return true;
        }
        return false;
    }

    private static PatternFilter[] removeIncludeAllFilter(PatternFilter[] pFilters) {
        ArrayList<PatternFilter> returnFilters = new ArrayList<PatternFilter>(pFilters.length);
        for (PatternFilter filter : pFilters) {
            if (filter.matches("**")) continue;
            returnFilters.add(filter);
        }
        PatternFilter[] retval = new PatternFilter[returnFilters.size()];
        retval = returnFilters.toArray(retval);
        return retval;
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this._handleButtons(e.getDocument());
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this._handleButtons(e.getDocument());
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this._handleButtons(e.getDocument());
    }

    private static class MyFilesPatternFilterPanel
    extends FilesPatternFilterPanel {
        private PatternFilters _patternFilters;

        public MyFilesPatternFilterPanel(PatternFilters patternFilters) {
            this._patternFilters = patternFilters;
            this.setHideButtonLabel(WizardsArb.getString(481));
            this.setShowButtonLabel(WizardsArb.getString(480));
        }

        @Override
        protected void initFileListModel() {
            PatternFilter[] filters;
            if (this.fileListModel.getSize() > 0) {
                return;
            }
            ArrayList<String> collected = new ArrayList<String>(25);
            for (File fileExtension : FileTypesRecognizer.allMappedExtensionsToNodes()) {
                String extension = fileExtension.getPath();
                if (collected.contains(extension)) continue;
                collected.add(extension);
                FilesPatternFilterPanel.TextPair textPair = new FilesPatternFilterPanel.TextPair(extension);
                this.fileListModel.addElement((Object)textPair, null, true, false);
            }
            if (this._patternFilters != null && (filters = this._patternFilters.getFilters()) != null && filters.length > 0) {
                boolean include = !AbstractCopySourceIntoProjectWizard.containsExludeFilter(filters);
                this.setShow(include);
                for (PatternFilter filter : filters) {
                    String pattern = filter.getPattern();
                    int position = pattern.lastIndexOf("/");
                    if (position != -1) {
                        pattern = pattern.substring(position + 1);
                    }
                    if ((position = this.fileListModel.findElementByText(pattern)) != -1) {
                        this.fileListModel.setElementSelected(position);
                        continue;
                    }
                    if (filter.isInclude() && !include || collected.contains(pattern)) continue;
                    collected.add(pattern);
                    FilesPatternFilterPanel.TextPair textPair = new FilesPatternFilterPanel.TextPair(pattern);
                    this.fileListModel.addElement((Object)textPair, null, true, true);
                }
            }
            this.fileListModel.sort();
            this.fileListModel.addCheckBoxStateListener((CheckBoxListItemStateListener)this);
        }
    }
}

