/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.palette;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.palette.EditorArb;

public class EventsPanel
extends JPanel
implements ActionListener {
    private final JLabel jLabel1 = new JLabel();
    private final String[] _events = new String[]{"onMouseOver", "onMouseMove", "onMouseOut", "onMouseDown", "onMouseUp", "onKeyPress", "onKeyDown", "onKeyUp", "onFocus", "onBlur", "onSelect", "onChange", "onClick", "onDblClick"};
    private final JComboBox _eventsBox = new JComboBox<String>(this._events);
    private final HashMap _eventMap = new HashMap();
    private final JLabel _eventCmdLbl = new JLabel();
    private final JScrollPane jScrollPane1 = new JScrollPane();
    private final JTextArea _eventCmdFld = new JTextArea();
    private final GridBagLayout gridBagLayout1 = new GridBagLayout();
    private String _previousSelection = null;

    public EventsPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.setBorder(BorderFactory.createTitledBorder(EditorArb.getString(58)));
        ResourceUtils.resLabel((JLabel)this.jLabel1, (Component)this._eventsBox, (String)EditorArb.getString(59));
        ResourceUtils.resLabel((JLabel)this._eventCmdLbl, (Component)this._eventCmdFld, (String)EditorArb.getString(60));
        this.jScrollPane1.getViewport().add((Component)this._eventCmdFld, null);
        this.add((Component)this.jScrollPane1, new GridBagConstraints(0, 2, 4, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this._eventCmdLbl, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this._eventsBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this._eventsBox.addActionListener(this);
        this._previousSelection = (String)this._eventsBox.getSelectedItem();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String selection = (String)this._eventsBox.getSelectedItem();
        String cmd = this._eventCmdFld.getText();
        this._eventMap.put(this._previousSelection, cmd);
        this._eventCmdFld.setText("");
        if (this._eventMap.containsKey(selection)) {
            this._eventCmdFld.setText((String)this._eventMap.get(selection));
        }
        this._previousSelection = selection;
    }

    public String getEvents() {
        this._eventMap.put((String)this._eventsBox.getSelectedItem(), this._eventCmdFld.getText());
        String eventStr = "";
        for (String name : this._eventMap.keySet()) {
            String value = (String)this._eventMap.get(name);
            if (value.trim().length() <= 0) continue;
            eventStr = eventStr + " " + name + "=\"" + value + "\"";
        }
        return eventStr;
    }
}

