/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.net.URL;
import java.util.concurrent.CopyOnWriteArrayList;
import oracle.ide.model.ContentSet;
import oracle.ide.model.NodeIdentityUtils;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;

public class J2eeSettings
extends HashStructureAdapter {
    public static final String DATA_KEY = J2eeSettings.class.getName();
    private static final String WEB_CONTENT_SET_LOCAL_KEY = "webContentSet";
    public static final String WEB_CONTENT_SET_KEY = DATA_KEY + "/" + "webContentSet";
    public static final String DEFAULT_HTML_ROOT = "public_html";
    public static final String HTML_SOURCE_ROOT = "webContentSet/url-path";
    public static final String J2EE_WEB_APP_NAME = "j2eeWebAppName";
    public static final String J2EE_WEB_CONTEXT_ROOT = "j2eeWebContextRoot";
    private URL _prjURL;
    private static CopyOnWriteArrayList<Class> jspCompilableTypes = new CopyOnWriteArrayList();

    private J2eeSettings(Project project, HashStructure hash) {
        super(hash);
        this._prjURL = project.getURL();
    }

    public static J2eeSettings getInstance(Project project) {
        if (project == null) {
            return null;
        }
        return J2eeSettings.getInstance(project, (PropertyStorage)project);
    }

    public static J2eeSettings getInstance(Project project, PropertyStorage propertyData) {
        if (project == null || propertyData == null) {
            return null;
        }
        HashStructure properties = propertyData.getProperties();
        return new J2eeSettings(project, properties.getOrCreateHashStructure(DATA_KEY));
    }

    public URL getHtmlRootDirectory() {
        URL htmlRootDirectory = this.getHtmlContentSet().getAllRootDirs().getFirstEntry();
        if (htmlRootDirectory == null && this._prjURL != null) {
            htmlRootDirectory = URLFactory.newDirURL((URL)URLFileSystem.getParent((URL)this._prjURL), (String)DEFAULT_HTML_ROOT);
        }
        return htmlRootDirectory;
    }

    public void setHtmlRootDirectory(URL root) {
        if (root != null) {
            URL dirURL = URLFactory.newDirURL((URL)root, (String)"");
            URLPath.setURLPath((HashStructure)this._hash, (String)HTML_SOURCE_ROOT, (URLPath)new URLPath(dirURL));
        } else {
            this._hash.remove(HTML_SOURCE_ROOT);
        }
    }

    public ContentSet getHtmlContentSet() {
        ContentSet htmlContentSet = new ContentSet(this._hash.getOrCreateHashStructure(WEB_CONTENT_SET_LOCAL_KEY));
        return htmlContentSet;
    }

    public String getJ2eeWebAppName() {
        String name = this._hash.getString(J2EE_WEB_APP_NAME);
        if (name == null && this._prjURL != null) {
            name = URLFileSystem.getName((URL)this._prjURL);
        }
        return name;
    }

    public void setJ2eeWebAppName(String j2eeWebAppName) {
        this._hash.putString(J2EE_WEB_APP_NAME, j2eeWebAppName);
    }

    public String getJ2eeWebContextRoot() {
        return this.getJ2eeWebContextRoot(false);
    }

    public String getJ2eeWebContextRoot(boolean forceSlash) {
        String j2eeWebContextRoot = this._hash.getString(J2EE_WEB_CONTEXT_ROOT);
        if (j2eeWebContextRoot == null && this._prjURL != null) {
            j2eeWebContextRoot = URLFileSystem.getName((URL)this._prjURL);
        }
        if (forceSlash && !j2eeWebContextRoot.startsWith("/")) {
            j2eeWebContextRoot = "/" + j2eeWebContextRoot;
        }
        return j2eeWebContextRoot;
    }

    public void setJ2eeWebContextRoot(String j2eeWebContextRoot) {
        this._hash.putString(J2EE_WEB_CONTEXT_ROOT, j2eeWebContextRoot);
    }

    public static boolean isCompilableJsp(String name) {
        return NodeIdentityUtils.isNodeClass((String)name, (Class[])jspCompilableTypes.toArray(new Class[jspCompilableTypes.size()]), (boolean)true);
    }

    public static void addCompilableJspType(Class jspCompilableType) {
        jspCompilableTypes.add(jspCompilableType);
    }
}

