/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.library;

import java.util.ArrayList;
import oracle.ide.migration.MigrationInfo;
import oracle.ide.migration.NodeMigratorHelper;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.panels.TraversableContext;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.model.JProjectLibraries;

public class ProjectLibraryMigrator
extends NodeMigratorHelper {
    private static String[] removeLibraries = new String[]{"VisiBroker4"};

    public void migrate(MigrationInfo[] infos, TraversableContext context) {
        for (int i = 0; i < infos.length; ++i) {
            if (infos[i].getMigrationStatus() == MigrationInfo.MIGRATION_PENDING) {
                Node node = infos[i].getNode();
                if (!(node instanceof Project)) continue;
                Project project = (Project)node;
                this.cleanProjectLibraries(project);
                continue;
            }
            if (infos[i].getMigrationStatus() != MigrationInfo.MIGRATION_CANCELED) continue;
        }
    }

    private void cleanProjectLibraries(Project project) {
        JProjectLibraries projectLibs = JProjectLibraries.getInstance((PropertyStorage)project);
        JLibrary[] libs = projectLibs.getLibraries();
        boolean replaceLibraries = false;
        if (libs != null) {
            ArrayList<JLibrary> newLibList = new ArrayList<JLibrary>();
            for (JLibrary lib : libs) {
                if (this.inObsoleteList(lib)) {
                    replaceLibraries = true;
                    continue;
                }
                newLibList.add(lib);
            }
            if (replaceLibraries) {
                JLibrary[] correctedLibs = null;
                if (newLibList.size() > 0) {
                    correctedLibs = new JLibrary[newLibList.size()];
                    correctedLibs = newLibList.toArray(correctedLibs);
                }
                projectLibs.setLibraries(correctedLibs);
            }
        }
    }

    private boolean inObsoleteList(JLibrary jlib) {
        boolean found = false;
        for (String removeName : removeLibraries) {
            if (!removeName.equals(jlib.getName())) continue;
            found = true;
            break;
        }
        return found;
    }
}

