/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.inspector;

import java.util.List;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.inspector.Inspectable;
import oracle.ide.inspector.InspectorFactory;
import oracle.ide.inspector.InspectorManager;
import oracle.ide.inspector.MultiInspectable;

public class InspectorController
implements Controller {
    public boolean update(IdeAction action, Context context) {
        switch (action.getCommandId()) {
            case 33: {
                action.setEnabled(InspectorManager.getInspectorManager() != null);
                return true;
            }
            case 56: {
                action.setEnabled(this.isInspectable(context));
                return action.isEnabled();
            }
        }
        return false;
    }

    private boolean isInspectable(Context context) {
        if (context == null) {
            return false;
        }
        InspectorFactory factory = InspectorFactory.getInstance();
        MultiInspectable inspectable = factory.getMultiInspectable(context);
        if (inspectable != null && inspectable.getSize() > 0) {
            return true;
        }
        List<Inspectable> inspectables = factory.getInspectables(context);
        return inspectables != null && inspectables.size() > 0;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        switch (action.getCommandId()) {
            case 56: {
                if (!this.isInspectable(context)) {
                    return false;
                }
            }
            case 33: {
                InspectorManager inspectorManager = InspectorManager.getInspectorManager();
                if (inspectorManager == null) break;
                inspectorManager.showView(context);
                return true;
            }
        }
        return false;
    }
}

