/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector.layout;

import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import oracle.ide.editor.EditorManager;
import oracle.javatools.util.ModelUtil;

public abstract class AutoExpandPreferredSize {
    public static final AutoExpandPreferredSize LARGE = new AutoExpandPreferredSize("large"){

        @Override
        protected int editorWidthPercentage() {
            return 70;
        }

        @Override
        protected int editorHeightPercentage() {
            return 60;
        }
    };
    public static final AutoExpandPreferredSize MEDIUM = new AutoExpandPreferredSize("medium"){

        @Override
        protected int editorWidthPercentage() {
            return 50;
        }

        @Override
        protected int editorHeightPercentage() {
            return 40;
        }
    };
    public static final AutoExpandPreferredSize SMALL = new AutoExpandPreferredSize("small"){

        @Override
        protected int editorWidthPercentage() {
            return 30;
        }

        @Override
        protected int editorHeightPercentage() {
            return 20;
        }
    };
    public static final AutoExpandPreferredSize DEFAULT = MEDIUM;
    private static final Map<String, AutoExpandPreferredSize> SIZES = new HashMap<String, AutoExpandPreferredSize>();
    private final String name;

    private static void register(AutoExpandPreferredSize ... sizes) {
        for (AutoExpandPreferredSize size : sizes) {
            SIZES.put(size.name.toLowerCase(), size);
        }
    }

    public static AutoExpandPreferredSize find(String name) {
        if (!ModelUtil.hasLength((String)name)) {
            return DEFAULT;
        }
        String key = name.toLowerCase();
        if (!SIZES.containsKey(key)) {
            throw new IllegalArgumentException("'" + name + "' is not a valid size");
        }
        return SIZES.get(key);
    }

    public static AutoExpandPreferredSize max(AutoExpandPreferredSize first, AutoExpandPreferredSize second) {
        if (first == null && second == null) {
            return null;
        }
        if (first != null && second == null) {
            return first;
        }
        if (first == null && second != null) {
            return second;
        }
        if (first.equals(LARGE)) {
            return first;
        }
        if (first.equals(SMALL)) {
            return second;
        }
        if (first.equals(MEDIUM)) {
            if (second.equals(LARGE)) {
                return second;
            }
            if (second.equals(SMALL)) {
                return first;
            }
        }
        return first;
    }

    private AutoExpandPreferredSize(String name) {
        this.name = name;
    }

    public final Dimension dimension(Dimension titledPanelSize, int orientation) {
        return this.dimension(titledPanelSize, orientation, this.editorWidthPercentage(), this.editorHeightPercentage());
    }

    protected abstract int editorWidthPercentage();

    protected abstract int editorHeightPercentage();

    protected final Dimension dimension(Dimension titledPanelSize, int orientation, int widthPercentage, int heightPercentage) {
        if (orientation == 2 || orientation == 3) {
            return this.northOrSouth(titledPanelSize, heightPercentage);
        }
        if (orientation == 1 || orientation == 0) {
            return this.eastOrWest(titledPanelSize, widthPercentage);
        }
        return null;
    }

    private Dimension northOrSouth(Dimension titledPanelSize, int heightPercentage) {
        Dimension editorDimension = this.editorDimension();
        if (editorDimension == null) {
            return null;
        }
        int editorHeightToCover = editorDimension.height * heightPercentage / 100;
        return new Dimension(titledPanelSize.width, titledPanelSize.height + editorHeightToCover);
    }

    private Dimension eastOrWest(Dimension titledPanelSize, int widthPercentage) {
        Dimension editorDimension = this.editorDimension();
        if (editorDimension == null) {
            return null;
        }
        int editorWidthToCover = editorDimension.width * widthPercentage / 100;
        return new Dimension(titledPanelSize.width + editorWidthToCover, titledPanelSize.height);
    }

    private Dimension editorDimension() {
        EditorManager editorManager = EditorManager.getEditorManager();
        if (editorManager == null) {
            return null;
        }
        JComponent desktop = editorManager.getDesktopComponent();
        if (desktop == null) {
            return null;
        }
        return desktop.getSize();
    }

    public final String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.getClass().getName());
        b.append("[name='" + this.name + "']");
        return b.toString();
    }

    static {
        AutoExpandPreferredSize.register(LARGE, MEDIUM, SMALL);
    }
}

