/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector.editor;

import java.awt.Component;
import javax.swing.JCheckBox;
import oracle.bali.inspector.PropertyEditorFactory2;
import oracle.bali.inspector.editor.EditorComponentFactory;
import oracle.bali.inspector.editor.EditorComponentInfo;
import oracle.ide.inspector.PropertyCheckBox;

public class CheckBoxEditorFactory
extends EditorComponentFactory {
    public static final String TRUE = "TRUE";
    public static final String FALSE = "FALSE";

    public boolean canCreateEditorFrom(Object initialValue) {
        if (this.isCorrectData(initialValue)) {
            return true;
        }
        if (!(initialValue instanceof EditorComponentInfo)) {
            return false;
        }
        return this.isCorrectData(((EditorComponentInfo)initialValue).initialValue());
    }

    private boolean isCorrectData(Object o) {
        return o instanceof Boolean || this.isCorrectStringArray(o);
    }

    private boolean isCorrectStringArray(Object o) {
        if (o == null) {
            return false;
        }
        if (!o.getClass().isArray()) {
            return false;
        }
        if (!o.getClass().getComponentType().equals(String.class)) {
            return false;
        }
        String[] array = (String[])o;
        if (array.length != 2) {
            return false;
        }
        if (TRUE.equals(array[0])) {
            return FALSE.equals(array[1]);
        }
        if (FALSE.equals(array[0])) {
            return TRUE.equals(array[1]);
        }
        return false;
    }

    public Component createInlineEditor(PropertyEditorFactory2 propertyEditor) {
        EditorComponentInfo info = propertyEditor.getEditorComponentInfo();
        if (!this.canCreateEditorFrom(info)) {
            return null;
        }
        PropertyCheckBox editor = new PropertyCheckBox();
        this.initializeEditor(editor, propertyEditor.getValue(), propertyEditor);
        return editor;
    }

    public Component updateInlineEditor(Component current, PropertyEditorFactory2 propertyEditor) {
        EditorComponentInfo componentInfo = propertyEditor.getEditorComponentInfo();
        if (!this.canCreateEditorFrom(componentInfo)) {
            return null;
        }
        if (current instanceof JCheckBox) {
            this.initializeEditor((JCheckBox)current, propertyEditor.getValue(), propertyEditor);
            return current;
        }
        return null;
    }

    private void initializeEditor(JCheckBox editor, Object value, PropertyEditorFactory2 propertyEditor) {
        boolean isSelected = editor.isSelected();
        boolean newValue = false;
        if (value instanceof Boolean) {
            newValue = (Boolean)value;
        } else if (this.isCorrectStringArray(value)) {
            newValue = Boolean.parseBoolean(propertyEditor.getAsText());
        }
        if (isSelected == newValue) {
            return;
        }
        editor.setSelected(newValue);
    }
}

