/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector;

import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import oracle.ide.adapters.AdapterManager;
import oracle.ide.inspector.DisplayGroupPanel;
import oracle.ide.inspector.Orientation;
import oracle.ide.inspector.Properties;
import oracle.ide.inspector.layout.DisplayGroup;
import oracle.ide.inspector.layout.Element;
import oracle.javatools.ui.TitledSeparator;

class VerticalDisplayGroupPanel
extends DisplayGroupPanel {
    private static final Color DISPLAY_GROUP_FOREGROUND = new Color(49, 106, 196);
    private JLabel hintLabel;
    private TitledSeparator header;

    VerticalDisplayGroupPanel(DisplayGroup group, Properties properties, Orientation orientation) {
        super(group, properties, orientation);
    }

    VerticalDisplayGroupPanel(List<Element> group, Properties properties, Orientation orientation) {
        super(group, properties, orientation);
    }

    @Override
    void expanded(boolean isExpanded) {
        if (this.header == null) {
            return;
        }
        if (isExpanded) {
            this.showTargetPanel();
        } else {
            this.hideTargetPanel();
        }
        if (this.hintLabel == null) {
            return;
        }
        this.hintLabel.setVisible(isExpanded);
    }

    @Override
    boolean isExpanded() {
        return true;
    }

    @Override
    void setUpHeader(boolean expanded) {
        this.addVerticalSpace(7);
        ++this.constraints().gridy;
        this.header = new TitledSeparator(this.title, TitledSeparator.STYLE.DOTTED);
        this.header.setForeground(DISPLAY_GROUP_FOREGROUND);
        this.header.setBackground((Color)AdapterManager.Factory.getAdapterManager().adapt((Object)this.orientation, Color.class));
        this.header.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)this.header, this.constraints());
        this.expanded(true);
    }

    @Override
    void addHintWhenHavingTitle() {
        if (!this.hasHint()) {
            return;
        }
        this.addVerticalSpace(1);
        ++this.constraints().gridy;
        this.hintLabel = new JLabel(this.hint);
        this.hintLabel.setForeground(HINT_FOREGROUND);
        this.add((Component)this.hintLabel, this.constraints());
        ++this.constraints().gridy;
    }
}

