/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import oracle.bali.inspector.PropertyEditorFactory2;
import oracle.ide.inspector.PropertyInfo;

class ValueApplierPropertyChangeListener
implements PropertyChangeListener {
    private volatile boolean isUpdating;
    private final PropertyInfo property;
    private Component editor;

    ValueApplierPropertyChangeListener(PropertyInfo property) {
        if (null == property) {
            throw new IllegalArgumentException("PropertyInfo must not be null");
        }
        this.property = property;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.isUpdating) {
            return;
        }
        try {
            this.isUpdating = true;
            ValueApplierPropertyChangeListener.doUpdateProperty(this.property, this.editor);
        }
        finally {
            this.isUpdating = false;
        }
    }

    void attachTo(Component editor) {
        this.editor = editor;
        PropertyEditorFactory2 editorFactory = this.property.editorFactory();
        if (null != editorFactory) {
            editorFactory.addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    void detach() {
        PropertyEditorFactory2 editorFactory = this.property.editorFactory();
        if (null != editorFactory) {
            editorFactory.removePropertyChangeListener((PropertyChangeListener)this);
        }
        this.editor = null;
    }

    private static void doUpdateProperty(PropertyInfo property, Component editor) {
        PropertyEditorFactory2 editorFactory = property.editorFactory();
        if (null == editorFactory) {
            return;
        }
        property.updateModelValue(editorFactory.getValue());
        if (null != editor && editorFactory.isPaintable()) {
            editor.repaint();
        }
    }
}

