/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector;

import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import oracle.ide.inspector.PropertyInfo;

final class UpdateComponentWithFocusListener
extends FocusAdapter {
    private PropertyInfo property;
    private Component editor;

    static void addUpdateComponentWithFocusListener(PropertyInfo property, Component editor) {
        UpdateComponentWithFocusListener found = null;
        for (FocusListener l : editor.getFocusListeners()) {
            if (!(l instanceof UpdateComponentWithFocusListener)) continue;
            found = (UpdateComponentWithFocusListener)l;
            break;
        }
        if (found == null) {
            found = new UpdateComponentWithFocusListener(property, editor);
            editor.addFocusListener(found);
            return;
        }
        editor.removeFocusListener(found);
        found.property = property;
        found.editor = editor;
        editor.addFocusListener(found);
    }

    private UpdateComponentWithFocusListener(PropertyInfo property, Component editor) {
        this.property = property;
        this.editor = editor;
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.property.updateComponentWithFocus(this.editor, this.property.editorFactory());
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e.isTemporary()) {
            return;
        }
        this.property.updateComponentWithFocus(e.getOppositeComponent(), null);
    }
}

