/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector;

final class SearchIterator {
    private final boolean searchForward;
    private final int startCategoryIndex;
    private final int categoryCount;
    private int offset;

    SearchIterator(boolean searchForward, int startCategoryIndex, int categoryCount) {
        this.searchForward = searchForward;
        this.startCategoryIndex = startCategoryIndex;
        this.categoryCount = categoryCount;
        this.offset = 0;
    }

    boolean hasNext() {
        return this.offset <= this.categoryCount;
    }

    int next() {
        int categoryIndex = this.categoryIndex();
        ++this.offset;
        return categoryIndex;
    }

    private int categoryIndex() {
        if (this.searchForward) {
            return (this.startCategoryIndex + this.offset) % this.categoryCount;
        }
        return (this.startCategoryIndex + this.categoryCount - this.offset) % this.categoryCount;
    }
}

