/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PropertyDisplayPanelLayout {
    private final List<Row> rows = new ArrayList<Row>();
    private int maxColumns = 4;

    final int maxColumns() {
        return this.maxColumns;
    }

    final void updateMaxColumns(int columnCount) {
        if (this.maxColumns < columnCount) {
            this.maxColumns = columnCount;
        }
    }

    public void addProperty(String id) {
        this.rows.add(new Row(id));
        this.updateMaxColumns(4);
    }

    public void addProperties(String ... ids) {
        this.rows.add(new Row(ids));
        int idCount = ids.length;
        if (idCount <= 1) {
            this.updateMaxColumns(4);
            return;
        }
        int columnCount = idCount * 4 + (idCount - 1);
        this.updateMaxColumns(columnCount);
    }

    List<Row> rows() {
        return new ArrayList<Row>(this.rows);
    }

    static class Row {
        private final String[] propertyIds;

        Row(String ... propertyIds) {
            this.propertyIds = Arrays.copyOf(propertyIds, propertyIds.length);
        }

        String[] propertyIds() {
            return Arrays.copyOf(this.propertyIds, this.propertyIds.length);
        }
    }
}

