/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector;

import java.awt.Color;
import java.awt.SystemColor;
import oracle.ide.adapters.AdapterFactory;
import oracle.ide.inspector.Orientation;
import oracle.ide.model.ColorProvider;
import oracle.ide.natives.accessibility.HighContrast;

final class Backgrounds
implements AdapterFactory<Orientation, Color>,
ColorProvider<Orientation> {
    static final Color VERTICAL_BACKGROUND = Color.WHITE;
    static final Color HORIZONTAL_BACKGROUND = Color.WHITE;

    Backgrounds() {
    }

    static Color backgroundFor(Orientation orientation) {
        if (HighContrast.isHighContrastModeEnabled()) {
            return SystemColor.window;
        }
        switch (orientation) {
            case HORIZONTAL: {
                return HORIZONTAL_BACKGROUND;
            }
        }
        return VERTICAL_BACKGROUND;
    }

    public Color adapt(Orientation orientation) {
        return Backgrounds.backgroundFor(orientation);
    }

    public Color backgroundFor(Orientation orientation, String key) {
        return Backgrounds.backgroundFor(orientation);
    }

    public Color foregroundFor(Orientation orientation, String key) {
        return null;
    }
}

