/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import oracle.bali.inspector.PropertyModel;
import oracle.ide.inspector.EmptyPropertyDisplay;
import oracle.ide.inspector.Orientation;
import oracle.ide.inspector.Properties;
import oracle.ide.inspector.PropertyDisplay;
import oracle.ide.inspector.PropertyGroupPanel;
import oracle.ide.inspector.RenderingOptimizer;
import oracle.ide.inspector.find.SearchableContainer;
import oracle.ide.model.Displayable;

public abstract class AbstractAdditionalPage
extends JPanel
implements Displayable,
SearchableContainer {
    private PropertyModel model;
    private Properties properties;
    private final PropertyDisplay propertyDisplay = new EmptyPropertyDisplay();
    private final RenderingOptimizer renderingOptimizer = new RenderingOptimizer();
    private PropertyGroupPanel propertyGroupPanel;

    public AbstractAdditionalPage() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder());
    }

    public void setPropertyModel(PropertyModel model) {
        this.clean();
        if (model == null) {
            return;
        }
        this.model = model;
        this.createProperties();
    }

    private void clean() {
        if (this.properties != null) {
            this.properties.dispose();
        }
        this.properties = null;
        if (this.model != null) {
            this.model.dispose();
        }
        this.removeAll();
        this.propertyGroupPanel = null;
    }

    private void createProperties() {
        this.properties = new Properties(this.model, this.renderingOptimizer, this.propertyDisplay);
    }

    public void render(Orientation orientation) {
        this.removeAll();
        this.propertyGroupPanel = null;
        if (this.properties.isEmpty()) {
            return;
        }
        List<String> groups = this.properties.organizeByGroups();
        if (groups.isEmpty()) {
            return;
        }
        if (groups.size() > 1) {
            return;
        }
        this.renderGroup(groups.get(0), this.properties, orientation);
    }

    private void renderGroup(String group, Properties properties, Orientation orientation) {
        PropertyGroupPanel panel = new PropertyGroupPanel(group);
        panel.render(properties, orientation);
        if (panel.getComponentCount() == 0) {
            return;
        }
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        this.add((Component)panel, c);
        this.propertyGroupPanel = panel;
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.propertyGroupPanel != null) {
            this.propertyGroupPanel.setBackground(bg);
        }
    }

    @Override
    public boolean findText(String searchText, boolean searchForward, boolean searchRepeat) {
        if (this.propertyGroupPanel == null) {
            return false;
        }
        return this.propertyGroupPanel.findText(searchText, searchForward, searchRepeat);
    }
}

