/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.ResourceBundle;
import oracle.security.pki.FileLockProvider;
import oracle.security.pki.OracleFileWalletImpl;
import oracle.security.pki.OraclePKIDebug;

public class FileLocker {
    private static final String b = "pki_data";
    private static final String c = ".lck";
    private RandomAccessFile d;
    private String e;
    private FileChannel f;
    private FileLock g;
    private static File h;
    static ResourceBundle a;

    public FileLocker(String string) throws IOException {
        block3: {
            this.d = null;
            OraclePKIDebug.a("FileLocker.FileLocker(): enter");
            this.e = string;
            File file = FileLocker.a(string);
            OraclePKIDebug.a("FileLocker.FileLocker(): Lock file Absolute location: " + file.getAbsolutePath());
            OraclePKIDebug.a("FileLocker.FileLocker(): Lock file Canonical location: " + file.getCanonicalPath());
            try {
                if (!file.exists()) {
                    file.createNewFile();
                    OraclePKIDebug.a("FileLocker.FileLocker(): Lock file do not exist, so created a new wallet lock file");
                    OracleFileWalletImpl.b(file);
                }
            }
            catch (IOException iOException) {
                file = FileLocker.b(string);
                OraclePKIDebug.a("FileLocker.FileLocker(): Alternate file location" + file.getCanonicalPath());
                if (file.exists()) break block3;
                file.createNewFile();
                OraclePKIDebug.a("FileLocker.FileLocker(): Lock file do not exist, so created a new wallet lock file");
                OracleFileWalletImpl.b(file);
            }
        }
        OraclePKIDebug.a("FileLocker.FileLocker(): exit");
    }

    private static File a(String string) {
        OraclePKIDebug.a("FileLocker.getLockFile(): Lock file location: " + string + c);
        return new File(string + c);
    }

    private static File b(String string) {
        OraclePKIDebug.a("FileLocker.getAltLockFile(): Alternate lock file location: pki_data" + string.hashCode() + c);
        return new File(h, b + string.hashCode() + c);
    }

    public FileLocker(File file) throws IOException {
        this(file.getCanonicalPath());
        OraclePKIDebug.a("FileLocker.FileLocker(): lock file: " + file.getCanonicalPath());
    }

    public boolean lock(boolean bl) throws IOException {
        String string = "Unknown reason";
        OraclePKIDebug.a("FileLocker.lock(): enter");
        try {
            File file = FileLocker.a(this.e);
            OraclePKIDebug.a("FileLocker.lock(): exit");
            return this.a(file, bl);
        }
        catch (IOException iOException) {
            string = iOException.getMessage();
            OraclePKIDebug.a("FileLocker.lock(): mesg: " + string);
            try {
                File file = FileLocker.b(this.e);
                OraclePKIDebug.a("FileLocker.lock(): exit");
                return this.a(file, bl);
            }
            catch (IOException iOException2) {
                string = "Failed to lock...\n attempt 1: " + string + "\n attempt 2: " + iOException2.getMessage();
                if (OraclePKIDebug.getDebugFlag()) {
                    iOException.printStackTrace();
                }
                throw new IOException(string);
            }
        }
    }

    private boolean a(File file, boolean bl) throws IOException {
        OraclePKIDebug.a("FileLocker.getlock(): enter");
        OraclePKIDebug.a("FileLocker.getlock(): lkfile: " + file.getCanonicalPath());
        try {
            if (bl) {
                OraclePKIDebug.a("FileLocker.getlock(): Creating Random Access File with read/write permission");
                this.d = new RandomAccessFile(file, "rw");
                this.f = this.d.getChannel();
                this.g = FileLockProvider.a(file, this.f);
            } else {
                OraclePKIDebug.a("FileLocker.getlock(): Creating Random Access File with read permission");
                this.d = new RandomAccessFile(file, "r");
                this.f = this.d.getChannel();
                this.g = FileLockProvider.a(file, this.f, 0L, 0L, true);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            OraclePKIDebug.a("FileLocker.getlock(): Lock file = " + file + ", exclusive = " + (bl ? 1 : 0));
            throw new IOException(fileNotFoundException);
        }
        catch (OverlappingFileLockException overlappingFileLockException) {
            if (this.f != null) {
                this.f.close();
                this.f = null;
            }
            if (this.d != null) {
                this.d.close();
                this.d = null;
            }
            OraclePKIDebug.a("FileLocker.getlock(): exit");
            return false;
        }
        OraclePKIDebug.a("FileLocker.getlock(): exit");
        return this.g != null && this.g.isValid();
    }

    public void unlock() throws IOException {
        OraclePKIDebug.a("FileLocker.unlock(): entry");
        if (this.g != null) {
            this.g.release();
            this.g = null;
        }
        if (this.f != null) {
            this.f.close();
            this.f = null;
        }
        if (this.d != null) {
            this.d.close();
            this.d = null;
        }
        OraclePKIDebug.a("FileLocker.unlock(): exit");
    }

    static {
        a = ResourceBundle.getBundle("oracle.security.pki.resources.OraclePKIMsg");
        try {
            File file = File.createTempFile(b, ".tmp");
            file.deleteOnExit();
            h = file.getParentFile();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }
}

