/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette.model;

import java.util.Map;
import oracle.ide.Ide;
import oracle.ide.util.macro.StringMacroConverter;
import oracle.ideimpl.palette.model.Addin;
import oracle.ideimpl.palette.model.History;
import oracle.ideimpl.palette.model.Jsplibrary;
import oracle.ideimpl.palette.model.Page;
import oracle.ideimpl.palette.palettexml.PaletteXML;

public class Palette {
    private Page[] _page;
    private Addin[] _addin;
    private Jsplibrary[] _jsplibrary;
    private History[] _history;

    public Palette() {
    }

    public Palette(Palette palette) {
        this();
        if (palette != null) {
            Palette.copy(palette, this);
        }
    }

    public static void copy(Palette src, Palette dst) {
        int i;
        int n;
        if (src._page != null) {
            n = src._page.length;
            dst._page = new Page[n];
            for (i = 0; i < n; ++i) {
                dst._page[i] = new Page(src._page[i]);
            }
        }
        if (src._addin != null) {
            n = src._addin.length;
            dst._addin = new Addin[n];
            for (i = 0; i < n; ++i) {
                dst._addin[i] = new Addin(src._addin[i]);
            }
        }
        if (src._jsplibrary != null) {
            n = src._jsplibrary.length;
            dst._jsplibrary = new Jsplibrary[n];
            for (i = 0; i < n; ++i) {
                dst._jsplibrary[i] = new Jsplibrary(src._jsplibrary[i]);
            }
        }
        if (src._history != null) {
            n = src._history.length;
            dst._history = new History[n];
            for (i = 0; i < n; ++i) {
                dst._history[i] = new History(src._history[i]);
            }
        }
    }

    public Page[] getPage() {
        return this._page;
    }

    public void setPage(Page[] page) {
        this._page = page;
    }

    public Addin[] getAddin() {
        return this._addin;
    }

    public void setAddin(Addin[] addin) {
        this._addin = addin;
    }

    public Jsplibrary[] getJsplibrary() {
        if (!PaletteXML.BUILD_SYSTEM && !PaletteXML.SAVING) {
            int no = this._jsplibrary != null ? this._jsplibrary.length : 0;
            for (int i = 0; i < no; ++i) {
                Jsplibrary lib = this._jsplibrary[i];
                this._convert(lib);
            }
        }
        return this._jsplibrary;
    }

    public void setJsplibrary(Jsplibrary[] jsplibrary) {
        this._jsplibrary = jsplibrary;
    }

    public History[] getHistory() {
        return this._history;
    }

    public void setHistory(History[] history) {
        this._history = history;
    }

    private void _convert(Jsplibrary lib) {
        Map macros = Ide.getMacros();
        StringMacroConverter filter = StringMacroConverter.getConverter((int)1);
        macros.put("oracle.home", Ide.getOracleHomeDirectory());
        String classesURL = lib.getClassesURL();
        if (classesURL != null) {
            classesURL = filter.expandString(lib.getClassesURL(), macros);
            classesURL = classesURL.replace('\\', '/');
            lib.setClassesURL(classesURL);
        }
        String tldURL = filter.expandString(lib.getTldURL(), macros);
        if (lib.getIcon() != null) {
            String icon = filter.expandString(lib.getIcon(), macros);
            icon = icon.replace('\\', '/');
        }
        tldURL = tldURL.replace('\\', '/');
        lib.setTldURL(tldURL);
    }
}

