/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JViewport;
import oracle.bali.ewt.button.ContinuousButtonModel;
import oracle.ideimpl.palette.PaletteScroll;

public class VerticalScroll
extends PaletteScroll {
    public Component _comp;
    public JButton _upBtn;
    public JButton _downBtn;
    private DownButtonModel _downModel = null;
    private UpButtonModel _upModel = null;

    public VerticalScroll(JPanel panel, JButton upBtn, JButton downBtn) {
        super(panel);
        this.setUpBtn(upBtn);
        this.setDownBtn(downBtn);
        this._downBtn.setVisible(false);
        this._downModel = new DownButtonModel(this._downBtn);
        this._upModel = new UpButtonModel(this._upBtn);
        this._upBtn.addMouseListener(this);
        this._downBtn.addMouseListener(this);
        this.getVerticalScrollBar().addAdjustmentListener(this);
        this.getHorizontalScrollBar().addAdjustmentListener(this);
    }

    public void validateScroll() {
        boolean _compsVisible = false;
        super.revalidate();
        boolean up = false;
        boolean down = false;
        JViewport vp = this.getViewport();
        Rectangle visRect = vp.getViewRect();
        Component[] comps = this.getPanel().getComponents();
        for (int i = 0; i < comps.length; ++i) {
            Rectangle compRect = comps[i].getBounds();
            if ((int)visRect.getHeight() != -4) {
                if (!visRect.contains(compRect) && visRect.y < compRect.y) {
                    down = true;
                }
                if (!visRect.contains(compRect) && visRect.y > compRect.y) {
                    up = true;
                }
            }
            if (!visRect.contains(compRect)) continue;
            _compsVisible = true;
        }
        if (!_compsVisible) {
            try {
                Rectangle rec = comps[0].getBounds();
                this.getPanel().scrollRectToVisible(rec);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.getUpBtn().setVisible(up);
        this.getDownBtn().setVisible(down);
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent p0) {
        this.validateScroll();
    }

    public void setUpBtn(JButton upBtn) {
        this._upBtn = upBtn;
    }

    public JButton getUpBtn() {
        return this._upBtn;
    }

    public void setDownBtn(JButton downBtn) {
        this._downBtn = downBtn;
    }

    public JButton getDownBtn() {
        return this._downBtn;
    }

    public void setComp(Component comp) {
        this._comp = comp;
    }

    public Component getComp() {
        return this._comp;
    }

    @Override
    public void mouseClicked(MouseEvent p0) {
    }

    @Override
    public void mousePressed(MouseEvent p0) {
        if (p0.getSource() == this._upBtn) {
            this._upModel.setPressed(true);
        } else {
            this._downModel.setPressed(true);
        }
    }

    @Override
    public void mouseReleased(MouseEvent p0) {
        this._upModel.setPressed(false);
        this._downModel.setPressed(false);
    }

    @Override
    public void mouseEntered(MouseEvent p0) {
    }

    @Override
    public void mouseExited(MouseEvent p0) {
    }

    public class UpButtonModel
    extends ContinuousButtonModel {
        JViewport vp;

        protected UpButtonModel(AbstractButton button) {
            super(button, 200, null);
            this.vp = VerticalScroll.this.getViewport();
        }

        protected void processPulse() {
            Rectangle visRect = this.vp.getViewRect();
            Rectangle scrollToRec = null;
            Component[] comps = VerticalScroll.this.getPanel().getComponents();
            for (int i = 0; i < comps.length; ++i) {
                Rectangle rec = comps[i].getBounds();
                if (!visRect.contains(rec) && visRect.y > rec.y) {
                    scrollToRec = rec;
                    if (i != comps.length - 1) continue;
                    VerticalScroll.this.getPanel().scrollRectToVisible(scrollToRec);
                    continue;
                }
                if (scrollToRec == null) continue;
                VerticalScroll.this.getPanel().scrollRectToVisible(scrollToRec);
                break;
            }
        }
    }

    public class DownButtonModel
    extends ContinuousButtonModel {
        JViewport vp;

        protected DownButtonModel(AbstractButton button) {
            super(button, 200, null);
            this.vp = VerticalScroll.this.getViewport();
        }

        protected void processPulse() {
            Rectangle visRect = this.vp.getViewRect();
            Component[] comps = VerticalScroll.this.getPanel().getComponents();
            for (int i = 0; i < comps.length; ++i) {
                Rectangle compRect = comps[i].getBounds();
                if ((int)visRect.getHeight() == -4 || visRect.contains(compRect) || visRect.y >= compRect.y) continue;
                VerticalScroll.this.getPanel().scrollRectToVisible(compRect);
                break;
            }
        }
    }
}

