/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.CopyOnWriteArrayList;
import oracle.ide.Context;
import oracle.ide.config.FileTypesRecognizer;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.model.Element;
import oracle.ide.model.TechnologyScopeConfiguration;
import oracle.ide.net.URLFileSystem;
import oracle.ide.palette.PaletteContext;
import oracle.ide.palette.PaletteItem;
import oracle.ide.palette.PaletteModelListener;
import oracle.ide.palette.PalettePage;
import oracle.ide.util.Assert;
import oracle.ideimpl.palette.PaletteArb;
import oracle.ideimpl.palette.PaletteItemImpl;
import oracle.ideimpl.palette.PaletteManagerImpl;
import oracle.ideimpl.palette.PalettePageImpl;
import oracle.ideimpl.palette.PaletteSubject;
import oracle.ideimpl.palette.PaletteWindowImpl;
import oracle.ideimpl.palette.model.Page;
import oracle.ideimpl.palette.model.Palette;
import oracle.ideimpl.palette.palettexml.PaletteXML;
import oracle.javatools.data.PropertyStorage;

public class PaletteImpl
extends PaletteSubject
implements oracle.ide.palette.Palette {
    private final String _title = PaletteArb.getString(27);
    private final CopyOnWriteArrayList<PaletteModelListener> _listeners = new CopyOnWriteArrayList();
    private ArrayList _palettePages = new ArrayList();
    private PaletteItemImpl _activeItem;
    private PalettePage _activePage;
    private boolean _hasPopulated = false;
    private String _pageType;
    private PalettePage _editPage;
    private boolean _isDirty = false;
    private static PaletteImpl _singleton = new PaletteImpl();

    public static PaletteImpl getInstance() {
        return _singleton;
    }

    public PaletteImpl() {
        this.setShortLabel(this.getTitle());
        this.setLongLabel(this.getTitle());
    }

    @Override
    public Iterator getChildren() {
        if (!this._hasPopulated) {
            this.populate();
        }
        return this._palettePages.iterator();
    }

    public boolean add(Element element) {
        PalettePage page = (PalettePage)element;
        boolean added = this._palettePages.add(element);
        if (added) {
            this.firePalettePageAdded(page);
            this._isDirty = true;
        }
        return added;
    }

    public PalettePage addPage(String pageName, String showForTypes, String type, boolean canRemove, boolean listView, boolean isPersistent, String technologyScope) {
        PalettePage palettePage = this.getPalettePage(pageName);
        if (palettePage != null) {
            return palettePage;
        }
        Page page = new Page();
        page.setName(pageName);
        page.setShowForTypes(showForTypes);
        page.setType(type);
        page.setCanRemove(canRemove);
        page.setTechnologyScope(technologyScope);
        if (listView) {
            page.setView("list");
        } else {
            page.setView("icon");
        }
        palettePage = new PalettePageImpl(page);
        palettePage.setIsPersistent(isPersistent);
        this.add((Element)palettePage);
        return palettePage;
    }

    @Override
    public PalettePage addPage(String pageName, String showForTypes, String type, boolean canRemove, boolean listView, boolean isPersistent) {
        PalettePage palettePage = this.getPalettePage(pageName);
        if (palettePage != null) {
            return palettePage;
        }
        Page page = new Page();
        page.setName(pageName);
        page.setShowForTypes(showForTypes);
        page.setType(type);
        page.setCanRemove(canRemove);
        if (listView) {
            page.setView("list");
        } else {
            page.setView("icon");
        }
        palettePage = new PalettePageImpl(page);
        palettePage.setIsPersistent(isPersistent);
        this.add((Element)palettePage);
        return palettePage;
    }

    public PalettePage addPage(String pageName, String showForTypes, String type, boolean canRemove, boolean listView, boolean isPersistent, boolean palette1Only) {
        PalettePage palettePage = this.getPalettePage(pageName);
        if (palettePage != null) {
            return palettePage;
        }
        Page page = new Page();
        page.setName(pageName);
        page.setShowForTypes(showForTypes);
        page.setType(type);
        page.setCanRemove(canRemove);
        if (listView) {
            page.setView("list");
        } else {
            page.setView("icon");
        }
        palettePage = new PalettePageImpl(page);
        palettePage.setIsPersistent(isPersistent);
        ((PalettePageImpl)palettePage).setIsPalette1Only(palette1Only);
        this.add((Element)palettePage);
        return palettePage;
    }

    @Override
    public boolean removePage(String pageName) {
        PalettePage palettePage = this.getPalettePage(pageName);
        if (palettePage != null) {
            return this.remove((Element)palettePage);
        }
        return false;
    }

    public boolean remove(Element element) {
        PalettePage page = (PalettePage)element;
        boolean removed = this._palettePages.remove(element);
        if (removed) {
            this.firePalettePageRemoved(page);
            this._isDirty = true;
        }
        return removed;
    }

    public void removeItem(String itemName, String pageName) {
        PalettePage page = this.getPalettePage(pageName);
        if (page != null) {
            for (PaletteItemImpl item : page.getPaletteItems()) {
                if (!item.getShortLabel().equals(itemName)) continue;
                page.remove(item);
                this.firePaletteItemRemoved(item);
                this._isDirty = true;
                break;
            }
        }
    }

    public void addItem(PaletteItem item) {
        this.getEditPage().add(item);
        this._isDirty = true;
    }

    @Override
    public void addItems(List items) {
        Iterator iter = items.iterator();
        while (iter.hasNext()) {
            this.getEditPage().add((PaletteItem)iter.next());
        }
    }

    public boolean canRemove(Element element) {
        return true;
    }

    public boolean canAdd(Element element) {
        return true;
    }

    public boolean containsChild(Element child) {
        return this._palettePages.contains(child);
    }

    public int size() {
        return this._palettePages.size();
    }

    public void removeAll() {
        this._palettePages.clear();
    }

    public void populate() {
        Palette palette = PaletteXML.getPalette();
        if (palette != null) {
            Page[] page = palette.getPage();
            if (page != null) {
                for (int i = 0; i < page.length; ++i) {
                    this.add(new PalettePageImpl(page[i]));
                }
            }
            this.setHasPopulated(true);
            PaletteManagerImpl.getInstance().addDeferredPages();
            this._isDirty = false;
        }
    }

    @Override
    public void setActiveItem(PaletteItem activeItem) {
        this._activeItem = (PaletteItemImpl)activeItem;
        PaletteWindowImpl.getInstance().updateSelection();
    }

    @Override
    public PaletteItem getActiveItem() {
        return this._activeItem;
    }

    @Override
    public void setActivePage(PalettePage activePage) {
        this._activePage = activePage;
    }

    @Override
    public PalettePage getActivePage() {
        return this._activePage;
    }

    @Override
    public PalettePage getPalettePage(String pageName) {
        Iterator palettePages = this.getChildren();
        while (palettePages.hasNext()) {
            PalettePage palettePage = (PalettePage)palettePages.next();
            if (!palettePage.getShortLabel().equals(pageName)) continue;
            return palettePage;
        }
        return null;
    }

    public PalettePage getPalettePage(String pageName, String pageType) {
        Iterator palettePages = this.getChildren();
        while (palettePages.hasNext()) {
            PalettePage palettePage = (PalettePage)palettePages.next();
            if (!palettePage.getShortLabel().equals(pageName) || !palettePage.getType().equals(pageType)) continue;
            return palettePage;
        }
        return null;
    }

    @Override
    public PaletteItem getPaletteItem(String itemName, String pageName) {
        PalettePage page = this.getPalettePage(pageName);
        if (page != null) {
            for (PaletteItemImpl item : page.getPaletteItems()) {
                if (!item.getShortLabel().equalsIgnoreCase(itemName)) continue;
                return item;
            }
        }
        return null;
    }

    public boolean getHasPopulated() {
        return this._hasPopulated;
    }

    private void setHasPopulated(boolean hasPopulated) {
        this._hasPopulated = hasPopulated;
    }

    @Override
    public void addPaletteModelListener(PaletteModelListener l) {
        this._listeners.addIfAbsent(l);
    }

    @Override
    public void removePaletteModelListener(PaletteModelListener l) {
        this._listeners.remove(l);
    }

    public void firePalettePageAdded(PalettePage page) {
        for (PaletteModelListener l : this._listeners) {
            l.palettePageAdded(page);
        }
    }

    public void firePalettePageRemoved(PalettePage page) {
        for (PaletteModelListener l : this._listeners) {
            l.palettePageRemoved(page);
        }
    }

    public void firePaletteItemAdded(PaletteItem item) {
        for (PaletteModelListener l : this._listeners) {
            l.paletteItemAdded(item);
        }
    }

    public void firePaletteItemRemoved(PaletteItem item) {
        for (PaletteModelListener l : this._listeners) {
            l.paletteItemRemoved(item);
        }
    }

    public void firePaletteItemRenamed(String oldname, PaletteItem item) {
        for (PaletteModelListener l : this._listeners) {
            l.paletteItemRenamed(oldname, item);
        }
    }

    public void firePalettePageRenamed(String name, PalettePage page) {
        for (PaletteModelListener l : this._listeners) {
            l.palettePageRenamed(name, page);
        }
    }

    public String getTitle() {
        return this._title;
    }

    @Deprecated
    public ArrayList getList() {
        return new ArrayList<PaletteModelListener>(this._listeners);
    }

    @Deprecated
    public void setPalettePages(ArrayList palettePages) {
        this._palettePages = palettePages != null ? palettePages : new ArrayList();
    }

    @Deprecated
    public ArrayList getPalettePages() {
        return this._palettePages;
    }

    public void setSingleton(PaletteImpl singleton) {
        _singleton = singleton;
    }

    public PaletteImpl getSingleton() {
        return _singleton;
    }

    public void setPageType(String pageType) {
        this._pageType = pageType;
    }

    @Override
    public String getPageType() {
        return this._pageType;
    }

    @Override
    public void setEditPage(PalettePage page) {
        this._editPage = page;
    }

    @Override
    public PalettePage getEditPage() {
        return this._editPage;
    }

    public boolean isDirty() {
        return this._isDirty;
    }

    public void setDirty(boolean dirty) {
        this._isDirty = dirty;
    }

    @Override
    public Iterator getPalettePages(Context context) {
        String pageType = PaletteImpl.getSuffix(context);
        ArrayList<PalettePage> pageList = new ArrayList<PalettePage>();
        if (context == null || context.getProject() == null) {
            return pageList.iterator();
        }
        Iterator iter = this.getChildren();
        while (iter.hasNext()) {
            boolean scopeFound;
            int nuScopes;
            PalettePage page = (PalettePage)iter.next();
            String technologyScope = page instanceof PalettePageImpl ? page.getTechnologyScope() : null;
            String[] keys = TechnologyScopeConfiguration.getInstance((PropertyStorage)context.getProject()).getTechnologyScope().getTechnologyKeys();
            int n = nuScopes = keys != null ? keys.length : 0;
            if (this.getSyntaxContext() != null) {
                this._checkSyntaxContextPage(pageList, page, context);
            }
            if (page.getShowForTypes() != null || page.getType() != null) {
                boolean used = this._checkForShowForTypes(page, pageType);
                if (used) {
                    if (nuScopes == 0 || technologyScope == null) {
                        pageList.add(page);
                    } else {
                        boolean techDefined = this._checkTechnologyScopes(keys, technologyScope);
                        if (page.getShortLabel().equals("HTML") && (pageType.equals("jsp") || pageType.equals("html"))) {
                            pageList.add(page);
                        } else if (techDefined) {
                            pageList.add(page);
                        }
                    }
                }
            } else if (nuScopes > 0 && (scopeFound = this._checkTechnologyScopes(keys, technologyScope))) {
                pageList.add(page);
            }
            this._checkForPaletteContextPage(pageList, page, context);
        }
        return pageList.iterator();
    }

    private void _checkSyntaxContextPage(Collection list, PalettePage page, Context context) {
        Element[] elems = new Element[]{page};
        context.setSelection(elems);
        try {
            PaletteContext pc = this.getSyntaxContext();
            if (pc.canShowPage(context)) {
                list.add(page);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private boolean _checkForPaletteContextPage(Collection list, PalettePage page, Context context) {
        Element[] elems = new Element[]{page};
        context.setSelection(elems);
        String paletteContext = page.getPaletteContext();
        if (paletteContext != null) {
            try {
                PaletteContext pc = (PaletteContext)Class.forName(paletteContext).newInstance();
                if (pc.canShowPage(context)) {
                    list.add(page);
                    return true;
                }
            }
            catch (Exception ex) {
                FeedbackManager.reportException((Throwable)ex);
            }
        }
        return false;
    }

    private static String getSuffix(Context context) {
        if (context == null || context.getNode() == null) {
            return "";
        }
        URL url = context.getNode().getURL();
        if (url == null) {
            return "";
        }
        String suffix = URLFileSystem.getSuffix((URL)url);
        int period = suffix.lastIndexOf(".");
        if (period != -1) {
            return PaletteImpl.convertAlias(suffix.substring(period + 1));
        }
        return "";
    }

    private static String convertAlias(String pageType) {
        if (pageType.startsWith("jsp") || pageType.startsWith("tag")) {
            return "jsp";
        }
        return pageType;
    }

    private PaletteContext getSyntaxContext() {
        return PaletteManagerImpl.getInstance().getUniversalContext();
    }

    private boolean _checkForShowForTypes(PalettePage page, String pageType) {
        String typeString = page.getShowForTypes();
        if (typeString == null) {
            typeString = PaletteImpl.getType(page);
        }
        StringTokenizer tkn = new StringTokenizer(typeString, ";");
        while (tkn.hasMoreTokens()) {
            String token = tkn.nextToken();
            boolean ok = this.isCorrectNode(token, pageType);
            if (!ok || !page.canShow()) continue;
            try {
                return true;
            }
            catch (Exception ex) {
                Assert.printStackTrace();
            }
        }
        return false;
    }

    private static String getType(PalettePage page) {
        return PaletteImpl.convertAlias(page.getType());
    }

    private boolean isCorrectNode(String suffix, String pageType) {
        if (null == pageType || pageType.isEmpty()) {
            return false;
        }
        String nodeType1 = FileTypesRecognizer.getClassNameForExtension((String)pageType);
        if (nodeType1 == null) {
            return false;
        }
        if (null == suffix || suffix.isEmpty()) {
            return false;
        }
        String nodeType2 = FileTypesRecognizer.getClassNameForExtension((String)suffix);
        return nodeType1.equals(nodeType2);
    }

    private boolean _checkTechnologyScopes(String[] keys, String technologyScope) {
        if (technologyScope == null) {
            return false;
        }
        List<String> keyList = Arrays.asList(keys);
        StringTokenizer tkn = new StringTokenizer(technologyScope, ";");
        while (tkn.hasMoreTokens()) {
            String token = tkn.nextToken();
            if (!keyList.contains(token)) continue;
            return true;
        }
        return false;
    }
}

