/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.util;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.logging.FileHandler;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.utils.MessageLogging;
import oracle.ide.Ide;

public class CheckThreadViolationRepaintManager
extends RepaintManager {
    private static final Logger logger = Logger.getLogger(CheckThreadViolationRepaintManager.class.getName());
    private boolean completeCheck = true;
    private WeakReference<JComponent> lastComponent;
    private static JButton test;

    public CheckThreadViolationRepaintManager(boolean bl) {
        this.completeCheck = bl;
    }

    public CheckThreadViolationRepaintManager() {
        this(true);
        try {
            logger.addHandler(new FileHandler(Ide.getUserSettingsDirectory() + "ThreadViolation.txt", true));
        }
        catch (SecurityException securityException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean isCompleteCheck() {
        return this.completeCheck;
    }

    public void setCompleteCheck(boolean bl) {
        this.completeCheck = bl;
    }

    @Override
    public synchronized void addInvalidComponent(JComponent jComponent) {
        this.checkThreadViolations(jComponent);
        super.addInvalidComponent(jComponent);
    }

    @Override
    public void addDirtyRegion(JComponent jComponent, int n, int n2, int n3, int n4) {
        this.checkThreadViolations(jComponent);
        super.addDirtyRegion(jComponent, n, n2, n3, n4);
    }

    private void checkThreadViolations(JComponent jComponent) {
        if (!SwingUtilities.isEventDispatchThread() && (this.completeCheck || jComponent.isShowing())) {
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
            for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                if (bl && stackTraceElement.getClassName().startsWith("javax.swing.")) {
                    bl2 = true;
                }
                if (bl && "imageUpdate".equals(stackTraceElement.getMethodName())) {
                    bl3 = true;
                }
                if (!"repaint".equals(stackTraceElement.getMethodName())) continue;
                bl = true;
                bl2 = false;
            }
            if (bl3) {
                return;
            }
            if (bl && !bl2) {
                return;
            }
            if (this.lastComponent != null && jComponent == this.lastComponent.get()) {
                return;
            }
            this.lastComponent = new WeakReference<JComponent>(jComponent);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("EDT rule violation detected \n");
            for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                stringBuilder.append("\n " + stackTraceElement);
            }
            Log.warn("A component", stringBuilder.toString());
        }
    }

    public static void main(String[] stringArray) throws Exception {
        RepaintManager.setCurrentManager(new CheckThreadViolationRepaintManager());
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                CheckThreadViolationRepaintManager.test();
            }
        });
        CheckThreadViolationRepaintManager.repaintTest();
        CheckThreadViolationRepaintManager.test();
    }

    static void test() {
        JFrame jFrame = new JFrame("Am I on EDT?");
        jFrame.setDefaultCloseOperation(3);
        jFrame.add(new JButton("JButton"));
        jFrame.pack();
        jFrame.setVisible(true);
        jFrame.dispose();
    }

    static void imageUpdateTest() {
        JFrame jFrame = new JFrame();
        jFrame.setDefaultCloseOperation(3);
        JEditorPane jEditorPane = new JEditorPane();
        jFrame.setContentPane(jEditorPane);
        jEditorPane.setContentType("text/html");
        jEditorPane.setText("<html><img src=\"file:\\lala.png\"></html>");
        jFrame.setSize(300, 200);
        jFrame.setVisible(true);
    }

    static void repaintTest() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    test = new JButton();
                    test.setSize(100, 100);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        test.repaint(test.getBounds());
        test.repaint(0, 0, 100, 100);
        test.repaint();
    }

    private static class Log {
        private Log() {
        }

        public static void warn(final String string, final String string2) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    logger.severe(string2);
                    MessageLogging.getInstance().log(string + " was updated from non EDT");
                }
            });
        }
    }
}

