/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.images;

import java.lang.reflect.Field;
import java.net.URL;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import oracle.dbtools.raptor.LazyIcon;
import oracle.ide.util.ArrayResourceBundle;
import oracle.javatools.util.ModelUtil;

public class RaptorImage {
    private static RaptorImage _instance;

    public static synchronized RaptorImage getInstance() {
        if (_instance == null) {
            _instance = new RaptorImage();
        }
        return _instance;
    }

    public static Icon getIcon(String string) {
        return RaptorImage.getIcon(string, RaptorImage.class.getClassLoader());
    }

    public static Icon getIcon(String string, ClassLoader classLoader) {
        Icon icon = null;
        if (string.indexOf(":") > 0) {
            try {
                String[] stringArray = string.split(":");
                ResourceBundle resourceBundle = ResourceBundle.getBundle(stringArray[0], Locale.getDefault(), classLoader);
                if (resourceBundle instanceof ArrayResourceBundle) {
                    ArrayResourceBundle arrayResourceBundle = (ArrayResourceBundle)resourceBundle;
                    Field field = arrayResourceBundle.getClass().getDeclaredField(stringArray[1]);
                    int n = field.getInt(arrayResourceBundle);
                    icon = arrayResourceBundle.getIconImpl(n);
                } else {
                    String string2;
                    Field field = resourceBundle.getClass().getDeclaredField(stringArray[1]);
                    String string3 = (String)field.get(resourceBundle);
                    if (string3 != null && (string2 = resourceBundle.getString(string3)) != null) {
                        icon = RaptorImage.getIconImpl(string2, classLoader);
                    }
                }
            }
            catch (MissingResourceException missingResourceException) {
                Logger.getLogger(RaptorImage.class.getName()).log(Level.WARNING, missingResourceException.getLocalizedMessage());
            }
            catch (NoSuchFieldException noSuchFieldException) {
                Logger.getLogger(RaptorImage.class.getName()).log(Level.WARNING, noSuchFieldException.getLocalizedMessage());
            }
            catch (Exception exception) {
                Logger.getLogger(RaptorImage.class.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        } else {
            icon = RaptorImage.getIconImpl(string, classLoader);
        }
        return icon;
    }

    static Icon getIconImpl(String string, ClassLoader classLoader) {
        URL uRL;
        LazyIcon lazyIcon = null;
        if (ModelUtil.hasLength((String)string) && (uRL = classLoader.getResource(string)) != null) {
            lazyIcon = new LazyIcon(uRL);
        }
        return lazyIcon;
    }
}

