/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import oracle.dbtools.raptor.dialogs.DialogResources;
import oracle.dbtools.raptor.dialogs.Messages;
import oracle.dbtools.raptor.dialogs.SQLErrorDialog;
import oracle.dbtools.raptor.utils.oerr.Oerr;
import oracle.dbtools.raptor.utils.oerr.OerrException;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.controls.SmallSquareButton;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.clipboard.ClipboardStack;
import oracle.javatools.icons.OracleIcons;

public class SQLErrorPanel
extends JPanel
implements ActionListener {
    private JMultiLineLabel lblMsg = new JMultiLineLabel();
    private SmallSquareButton copyBtn = new SmallSquareButton();
    private JButton btnBack = new JButton();
    private JButton btnForward = new JButton();
    private JPanel pnlBottom = new JPanel();
    private String _sql;
    private int _errOffset;
    private int _col = -1;
    private int _line = -1;
    private String connName;
    protected List<SQLException> _errs;
    private int _idx;
    private static final String BACK_CMD = "BACK";
    private static final String FWD_CMD = "FWD";

    public static Builder createBuilder(String string) {
        Builder builder = new Builder(string);
        return builder;
    }

    private SQLErrorPanel(String string) {
        this.connName = string;
    }

    private void setCol(int n) {
        this._col = n;
    }

    private void setLine(int n) {
        this._line = n;
    }

    private void setSql(String string) {
        this._sql = string;
    }

    private void setOffset(int n) {
        this._errOffset = n;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (BACK_CMD.equals(string)) {
            --this._idx;
            this._update();
        } else if (FWD_CMD.equals(string)) {
            ++this._idx;
            this._update();
        }
    }

    private void setError(SQLException sQLException) {
        ArrayList<SQLException> arrayList = new ArrayList<SQLException>();
        while (sQLException != null) {
            arrayList.add(sQLException);
            sQLException = sQLException.getNextException();
        }
        this.setErrors(arrayList);
    }

    private void setErrors(List<SQLException> list) {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        this._errs = list;
        this._idx = this._errs.size() > 0 ? 0 : -1;
        this.pnlBottom.setVisible(this._errs.size() > 1);
        this._update();
    }

    private void _update() {
        this.btnBack.setEnabled(this._idx > 0);
        this.btnForward.setEnabled(this._idx < this._errs.size() - 1);
        SQLException sQLException = this._idx != -1 ? this._errs.get(this._idx) : null;
        this.updateExceptionComponent(sQLException);
    }

    protected void updateExceptionComponent(SQLException sQLException) {
        Object[] objectArray;
        String string = null;
        for (Object object : SQLErrorDialog.ScrubberHolder.INSTANCE) {
            objectArray = object.getMessage(this.connName, sQLException);
            if (objectArray == null) continue;
            string = objectArray;
            break;
        }
        if (string == null) {
            if (sQLException != null) {
                Object object;
                Object object2 = sQLException.getLocalizedMessage();
                if (object2 != null && !((String)object2).endsWith("\n")) {
                    object2 = (String)object2 + "\n";
                }
                if (object2 != null && ((String)object2).indexOf("ORA") > -1) {
                    object = new Oerr();
                    try {
                        object2 = (String)object2 + object.oerr((String)object2);
                    }
                    catch (OerrException oerrException) {
                        // empty catch block
                    }
                }
                if (this._sql != null) {
                    object = new StringBuilder();
                    ((StringBuilder)object).append(DialogResources.format("SQL_EXCEPTION_MSG", object2, Integer.toString(sQLException.getErrorCode())));
                    if (this._errOffset > 0) {
                        objectArray = SQLErrorDialog.getLineAndColumn(this._sql, this._errOffset, this._line, this._col);
                        ((StringBuilder)object).append(MessageFormat.format(Messages.getString("SQLErrorDialog.10"), objectArray));
                    } else if (this._line >= 0) {
                        ((StringBuilder)object).append(MessageFormat.format(Messages.getString("SQLErrorDialog.11"), this._line));
                    }
                    string = ((StringBuilder)object).toString();
                } else {
                    string = DialogResources.format(sQLException instanceof SQLWarning ? "SQL_WARNING_MSG" : "SQL_EXCEPTION_MSG", object2, Integer.toString(sQLException.getErrorCode()));
                }
            } else {
                string = DialogResources.getString("SQL_EXCEPTION_UNKNOWN_MSG");
            }
        }
        this.lblMsg.setText(string);
        this.lblMsg.setMaximumRows(8);
    }

    protected Component getExceptionComponent() {
        this.lblMsg.setPreferredAspectRatio(5.0f);
        return this.lblMsg;
    }

    private void jbInit() {
        JPanel jPanel = new JPanel();
        ResourceUtils.resButton((AbstractButton)this.btnBack, (String)DialogResources.getString("SQL_EXCEPTION_BUTTON_BACK"));
        this.btnBack.setActionCommand(BACK_CMD);
        this.btnBack.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this.btnForward, (String)DialogResources.getString("SQL_EXCEPTION_BUTTON_NEXT"));
        this.btnForward.setActionCommand(FWD_CMD);
        this.btnForward.addActionListener(this);
        GridLayout gridLayout = new GridLayout();
        jPanel.setLayout(gridLayout);
        gridLayout.setColumns(2);
        gridLayout.setHgap(5);
        jPanel.add((Component)this.btnBack, null);
        jPanel.add((Component)this.btnForward, null);
        this.pnlBottom.setLayout(new GridBagLayout());
        this.pnlBottom.setBorder(BorderFactory.createEmptyBorder(15, 0, 0, 0));
        this.pnlBottom.add(Box.createGlue(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.pnlBottom.add((Component)jPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add(this.getExceptionComponent(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.copyBtn.setAction((Action)new AbstractAction("", OracleIcons.getIcon((String)"copy.png")){
            {
                this.putValue("ActionCommandKey", this.getValue("Name"));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StringSelection stringSelection = new StringSelection(SQLErrorPanel.this.lblMsg.getText());
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                ClipboardStack.pushCurrentClipboard();
                clipboard.setContents(stringSelection, stringSelection);
                SQLErrorPanel.this.copyBtn.setSelected(false);
            }
        });
        this.copyBtn.setToolTipText(Messages.getString("COPY_ERROR_MESSAGE_TOOLTIP"));
        int n = 2;
        KeyStroke keyStroke = KeyStroke.getKeyStroke(83, 128);
        this.getInputMap(n).put(keyStroke, "PRESS");
        this.getActionMap().put("PRESS", this.copyBtn.getAction());
        this.add((Component)this.copyBtn, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.pnlBottom, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    public static class Builder {
        private String sql;
        private int offset;
        private int col = -1;
        private int line = -1;
        private String connName;
        private SQLException err;

        private Builder(String string) {
            this.connName = string;
        }

        public Builder sql(String string) {
            this.sql = string;
            return this;
        }

        public Builder offset(int n) {
            this.offset = n;
            return this;
        }

        public Builder position(int n, int n2) {
            this.col = n;
            this.line = n2;
            return this;
        }

        public Builder error(SQLException sQLException) {
            this.err = sQLException;
            return this;
        }

        public Builder warning(SQLWarning sQLWarning) {
            this.err = sQLWarning;
            return this;
        }

        public SQLErrorPanel build() {
            SQLErrorPanel sQLErrorPanel = new SQLErrorPanel(this.connName);
            sQLErrorPanel.setSql(this.sql);
            sQLErrorPanel.setOffset(this.offset);
            sQLErrorPanel.setCol(this.col);
            sQLErrorPanel.setLine(this.line);
            sQLErrorPanel.setError(this.err);
            return sQLErrorPanel;
        }
    }
}

