/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.treetable;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreePath;
import oracle.dbtools.raptor.controls.treetable.Expansible;
import oracle.javatools.ui.treetable.JTreeTable;

public class SpannedRowsUI
extends BasicTableUI {
    public JTreeTable tbl;

    public SpannedRowsUI(JTreeTable jTreeTable) {
        this.tbl = jTreeTable;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        Rectangle rectangle = graphics.getClipBounds();
        Rectangle rectangle2 = new Rectangle(rectangle);
        int n = this.table.getColumnModel().getTotalColumnWidth();
        rectangle2.width = Math.min(rectangle2.width, n);
        graphics.setClip(rectangle2);
        int n2 = this.table.rowAtPoint(new Point(0, rectangle2.y));
        int n3 = this.table.getRowCount() - 1;
        Rectangle rectangle3 = new Rectangle(0, 0, n, this.table.getRowHeight() + this.table.getRowMargin());
        rectangle3.y = n2 * rectangle3.height;
        for (int i = n2; i <= n3; ++i) {
            if (rectangle3.intersects(rectangle2)) {
                this.paintRow(graphics, i);
            }
            rectangle3.y += rectangle3.height;
        }
        graphics.setClip(rectangle);
    }

    private void paintRow(Graphics graphics, int n) {
        Rectangle rectangle = graphics.getClipBounds();
        boolean bl = false;
        TreePath treePath = this.tbl.getTree().getPathForRow(n);
        Expansible expansible = (Expansible)treePath.getLastPathComponent();
        boolean bl2 = expansible.isSpanned();
        int n2 = this.table.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            Rectangle rectangle2 = this.table.getCellRect(n, i, true);
            if (bl2) {
                Rectangle rectangle3 = this.table.getCellRect(n, n2 - 1, true);
                Rectangle.union(rectangle2, rectangle3, rectangle2);
            }
            int n3 = n;
            int n4 = i;
            if (bl2 && 0 < i) break;
            if (rectangle2.intersects(rectangle)) {
                bl = true;
                this.paintCell(graphics, rectangle2, n3, n4);
                continue;
            }
            if (bl) break;
        }
    }

    private void paintCell(Graphics graphics, Rectangle rectangle, int n, int n2) {
        int n3 = this.table.getRowMargin();
        int n4 = this.table.getColumnModel().getColumnMargin();
        Color color = graphics.getColor();
        graphics.setColor(this.table.getGridColor());
        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
        graphics.setColor(color);
        rectangle.setBounds(rectangle.x + n4 / 2, rectangle.y + n3 / 2, rectangle.width - n4, rectangle.height - n3);
        TableCellRenderer tableCellRenderer = this.table.getCellRenderer(n, n2);
        Component component = this.table.prepareRenderer(tableCellRenderer, n, n2);
        if (component.getParent() == null) {
            this.rendererPane.add(component);
        }
        this.rendererPane.paintComponent(graphics, component, this.table, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
    }
}

