/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.grid;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.raptor.controls.grid.AbstractRaptorGridModel;
import oracle.dbtools.raptor.controls.grid.RaptorGridCell;

public class RaptorGridRowModel
implements Serializable {
    int rowIndex;
    private List<RaptorGridCell> _row = new ArrayList<RaptorGridCell>();
    private boolean _new = false;
    private boolean _deleted = false;
    private boolean _error;
    private String _errorMessage = null;

    public RaptorGridRowModel(List<? extends RaptorGridCell> list) {
        this._row.addAll(list);
    }

    public RaptorGridRowModel(List<? extends RaptorGridCell> list, int n) {
        this(list);
        this.rowIndex = n;
    }

    public RaptorGridRowModel() {
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public int getColumnCount() {
        return this._row.size();
    }

    public List<? extends RaptorGridCell> getRow() {
        return this._row;
    }

    private void setRow(List<? extends RaptorGridCell> list) {
        this._row.clear();
        this._row.addAll(list);
    }

    public static RaptorGridRowModel getNewRow(AbstractRaptorGridModel abstractRaptorGridModel) {
        ArrayList<RaptorGridCell> arrayList = new ArrayList<RaptorGridCell>();
        if (abstractRaptorGridModel != null) {
            for (int i = 0; i < abstractRaptorGridModel.getGridColumns().size(); ++i) {
                arrayList.add(new RaptorGridCell(""));
            }
        }
        RaptorGridRowModel raptorGridRowModel = new RaptorGridRowModel(arrayList);
        return raptorGridRowModel;
    }

    private void resetFlags() {
        this._new = false;
        this._deleted = false;
        this._error = false;
        this._errorMessage = null;
    }

    public boolean isNew() {
        return this._new;
    }

    public void setNew() {
        this._deleted = false;
        this._new = true;
    }

    public boolean isUpdated() {
        if (this._new || this._deleted) {
            return false;
        }
        for (RaptorGridCell raptorGridCell : this._row) {
            if (!raptorGridCell.isUpdated()) continue;
            return true;
        }
        return false;
    }

    public boolean isDeleted() {
        return this._deleted;
    }

    public void setDeleted(boolean bl) {
        this._deleted = bl;
    }

    public boolean getError() {
        return this._error;
    }

    public String getErrorMessage() {
        return this._errorMessage;
    }

    public void setError(String string) {
        this._error = string != null;
        this._errorMessage = string;
    }

    public void setError(boolean bl) {
        this._error = bl;
    }
}

