/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.grid;

import java.awt.Component;
import javax.swing.JMenuItem;
import oracle.dbtools.raptor.controls.grid.RaptorEditableGridTable;
import oracle.dbtools.raptor.controls.grid.RaptorGridController;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;

public class RaptorEditableGridController<T extends RaptorEditableGridTable>
extends RaptorGridController<T> {
    private static final String ROLLBACK_CHANGES_CMD = "raptor.dataeditor.rollback";
    private static final String COMMIT_CHANGES_CMD = "raptor.dataeditor.commit";
    private static final String DELETE_ROW_CMD = "raptor.dataeditor.delete";
    private static final String INSERT_ROW_CMD = "raptor.dataeditor.insert";
    private static final int INSERT_ROW_CMD_ID = Ide.findOrCreateCmdID((String)"raptor.dataeditor.insert");
    private static final int DELETE_ROW_CMD_ID = Ide.findOrCreateCmdID((String)"raptor.dataeditor.delete");
    private static final int COMMIT_CHANGES_CMD_ID = Ide.findOrCreateCmdID((String)"raptor.dataeditor.commit");
    private static final int ROLLBACK_CHANGES_CMD_ID = Ide.findOrCreateCmdID((String)"raptor.dataeditor.rollback");
    private IdeAction m_INSERT_ACTION;
    private IdeAction m_DELETE_ACTION;
    private IdeAction m_COMMIT_ACTION;
    private IdeAction m_ROLLBACK_ACTION;

    private IdeAction getInsertAction() {
        if (null == this.m_INSERT_ACTION) {
            this.m_INSERT_ACTION = IdeAction.find((int)INSERT_ROW_CMD_ID).newLocalAction(this._view);
            this.setupAccelaratorToolTip(this.m_INSERT_ACTION);
            this.m_INSERT_ACTION.addController(new Controller(){

                public boolean handleEvent(IdeAction ideAction, Context context) {
                    ((RaptorEditableGridTable)RaptorEditableGridController.this._grid).addRow();
                    return true;
                }

                public boolean update(IdeAction ideAction, Context context) {
                    ideAction.setEnabled(RaptorEditableGridController.this.isGridReady() && ((RaptorEditableGridTable)RaptorEditableGridController.this._grid).isInsertAllowed());
                    return true;
                }
            });
        }
        return this.m_INSERT_ACTION;
    }

    private IdeAction getDeleteAction() {
        if (null == this.m_DELETE_ACTION) {
            this.m_DELETE_ACTION = IdeAction.find((int)DELETE_ROW_CMD_ID).newLocalAction(this._view);
            this.setupAccelaratorToolTip(this.m_DELETE_ACTION);
            this.m_DELETE_ACTION.addController(new Controller(){

                public boolean handleEvent(IdeAction ideAction, Context context) {
                    ((RaptorEditableGridTable)RaptorEditableGridController.this._grid).deleteRow();
                    return true;
                }

                public boolean update(IdeAction ideAction, Context context) {
                    ideAction.setEnabled(RaptorEditableGridController.this.isGridReady() && ((RaptorEditableGridTable)RaptorEditableGridController.this._grid).isDeleteAllowed() && ((RaptorEditableGridTable)RaptorEditableGridController.this._grid).getSelectedRow() != -1);
                    return true;
                }
            });
        }
        return this.m_DELETE_ACTION;
    }

    public IdeAction getCommitAction() {
        if (null == this.m_COMMIT_ACTION) {
            this.m_COMMIT_ACTION = IdeAction.find((int)COMMIT_CHANGES_CMD_ID).newLocalAction(this._view);
            this.setupAccelaratorToolTip(this.m_COMMIT_ACTION);
            this.m_COMMIT_ACTION.addController(new Controller(){

                public boolean handleEvent(IdeAction ideAction, Context context) {
                    ((RaptorEditableGridTable)RaptorEditableGridController.this._grid).save();
                    return true;
                }

                public boolean update(IdeAction ideAction, Context context) {
                    ideAction.setEnabled(RaptorEditableGridController.this.isGridReady() && ((RaptorEditableGridTable)RaptorEditableGridController.this._grid).isChanged());
                    return true;
                }
            });
        }
        return this.m_COMMIT_ACTION;
    }

    public IdeAction getRollbackAction() {
        if (null == this.m_ROLLBACK_ACTION) {
            this.m_ROLLBACK_ACTION = IdeAction.find((int)ROLLBACK_CHANGES_CMD_ID).newLocalAction(this._view);
            this.setupAccelaratorToolTip(this.m_ROLLBACK_ACTION);
            this.m_ROLLBACK_ACTION.addController(new Controller(){

                public boolean handleEvent(IdeAction ideAction, Context context) {
                    ((RaptorEditableGridTable)RaptorEditableGridController.this._grid).rollback();
                    return true;
                }

                public boolean update(IdeAction ideAction, Context context) {
                    ideAction.setEnabled(RaptorEditableGridController.this.isGridReady() && ((RaptorEditableGridTable)RaptorEditableGridController.this._grid).isChanged());
                    return true;
                }
            });
        }
        return this.m_ROLLBACK_ACTION;
    }

    @Override
    public boolean isGridReady() {
        if (this._grid == null) {
            return false;
        }
        if (((RaptorEditableGridTable)this._grid).getGridModel() == null) {
            return false;
        }
        if (((RaptorEditableGridTable)this._grid).getGridModel().isBusy()) {
            return false;
        }
        return super.isGridReady();
    }

    @Override
    public void updateControllerActions(boolean bl) {
        super.updateControllerActions(bl);
        RaptorEditableGridController.setEnabled(this.m_INSERT_ACTION, bl);
        RaptorEditableGridController.setEnabled(this.m_DELETE_ACTION, bl);
        RaptorEditableGridController.setEnabled(this.m_COMMIT_ACTION, bl);
        RaptorEditableGridController.setEnabled(this.m_ROLLBACK_ACTION, bl);
    }

    @Override
    protected void clearLocalActions() {
        super.clearLocalActions();
        this.m_INSERT_ACTION = null;
        this.m_DELETE_ACTION = null;
        this.m_COMMIT_ACTION = null;
        this.m_ROLLBACK_ACTION = null;
    }

    @Override
    protected boolean addFirstToolbarActions(Toolbar toolbar) {
        boolean bl = super.addFirstToolbarActions(toolbar);
        if (this._grid != null && toolbar != null) {
            if (RaptorEditableGridController.addToToolbar(this.getInsertAction(), toolbar)) {
                bl = true;
            }
            if (RaptorEditableGridController.addToToolbar(this.getDeleteAction(), toolbar)) {
                bl = true;
            }
            if (RaptorEditableGridController.addToToolbar(this.getCommitAction(), toolbar)) {
                bl = true;
            }
            if (RaptorEditableGridController.addToToolbar(this.getRollbackAction(), toolbar)) {
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public void addContextMenuActions(ContextMenu contextMenu) {
        if (this._grid != null && contextMenu != null) {
            super.addContextMenuActions(contextMenu);
            if (((RaptorEditableGridTable)this._grid).isEditable()) {
                JMenuItem jMenuItem;
                if (((RaptorEditableGridTable)this._grid).isInsertAllowed()) {
                    jMenuItem = contextMenu.createMenuItem((ToggleAction)this.getInsertAction());
                    contextMenu.add((Component)jMenuItem);
                }
                if (((RaptorEditableGridTable)this._grid).isDeleteAllowed()) {
                    jMenuItem = contextMenu.createMenuItem((ToggleAction)this.getDeleteAction());
                    contextMenu.add((Component)jMenuItem);
                }
                if (((RaptorEditableGridTable)this._grid).isCommitActionAllowed()) {
                    jMenuItem = contextMenu.createMenuItem((ToggleAction)this.getCommitAction());
                    contextMenu.add((Component)jMenuItem);
                }
                if (((RaptorEditableGridTable)this._grid).isRollbackActionAllowed()) {
                    jMenuItem = contextMenu.createMenuItem((ToggleAction)this.getRollbackAction());
                    contextMenu.add((Component)jMenuItem);
                }
            }
        }
    }
}

