/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.grid;

import java.awt.Color;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import oracle.dbtools.logging.IStatusMessageConsumer;
import oracle.dbtools.raptor.ConnectionArb;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskProgressUpdater;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskStatus;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.controls.grid.GridColumn;
import oracle.dbtools.raptor.controls.grid.GridColumnHighlightParameter;
import oracle.dbtools.raptor.controls.grid.IRaptorGridModel;
import oracle.dbtools.raptor.controls.grid.Messages;
import oracle.dbtools.raptor.controls.grid.RaptorGridCell;
import oracle.dbtools.raptor.controls.grid.RaptorGridPersistedSettings;
import oracle.dbtools.raptor.controls.grid.RaptorGridRowModel;
import oracle.dbtools.raptor.controls.grid.RaptorGridTable;
import oracle.dbtools.raptor.controls.grid.RaptorGridTaskWrapper;

public abstract class AbstractRaptorGridModel
extends AbstractTableModel
implements IRaptorGridModel {
    private static final long serialVersionUID = -7369633135172272916L;
    protected final CopyOnWriteArrayList<IStatusMessageConsumer> _statusMessageListeners = new CopyOnWriteArrayList();
    protected String _lastStatusMessage = "";
    protected int _FETCH_SIZE = 5;
    protected boolean _verticalDisplay = false;
    protected boolean _uniqueColNames = true;
    private List<RaptorGridRowModel> _data = new ArrayList<RaptorGridRowModel>();
    protected FetchTaskAdapter fetchTaskAdapter = new FetchTaskAdapter();
    protected RaptorGridTaskWrapper _taskWrapper = null;
    protected RowHeaderTableModel _rowHeaderModel;
    protected List<RaptorTask<?>> _tasks = new ArrayList();
    private boolean _allRowsFetched = false;
    protected final List<String> _highlightCols = new ArrayList<String>();

    public AbstractRaptorGridModel() {
        for (int i = 0; i < 10; ++i) {
            this._highlightCols.add("SQLDEV_HIGHLIGHT_COL" + i);
        }
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n >= this.getLoadedRowCount() && !this.isTaskRunning()) {
            try {
                this.fetchNext(n - this.getLoadedRowCount() + 2, this._taskWrapper);
            }
            catch (ExecutionException executionException) {
                this.publishStatusMessage(executionException.getLocalizedMessage(), executionException);
                return null;
            }
        }
        if (n < this.getLoadedRowCount()) {
            try {
                return this._data.get(n).getRow().get(n2).getCellData();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return RaptorGridTable._GHOST_VALUE;
    }

    @Override
    public String getDisplayValueAt(int n, int n2, int n3) {
        if (n < this.getLoadedRowCount() && n2 <= this.getColumnCount()) {
            try {
                return this._data.get(n).getRow().get(n2).getDisplayValue(n3);
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    @Override
    public Object formatDisplayValueAt(String string, int n, int n2) {
        return string;
    }

    @Override
    public String getColumnName(int n) {
        if (this.hasColumnNamesUnique()) {
            return this.getGridColumns().get(n).getAlias();
        }
        return this.getGridColumns().get(n).getOriginal();
    }

    @Override
    public boolean isSkipColumn(int n) {
        return this.getGridColumns().get(n).isSkiped();
    }

    @Override
    public boolean isHiddenColumn(int n) {
        return this.getGridColumns().get(n).isHidden();
    }

    public List<GridColumn> getHiddenCols() {
        ArrayList<GridColumn> arrayList = new ArrayList<GridColumn>();
        for (GridColumn gridColumn : this.getGridColumns()) {
            if (!gridColumn.isHidden()) continue;
            arrayList.add(gridColumn);
        }
        return arrayList;
    }

    public List<GridColumn> getSkipCols() {
        ArrayList<GridColumn> arrayList = new ArrayList<GridColumn>();
        for (GridColumn gridColumn : this.getGridColumns()) {
            if (!gridColumn.isSkiped()) continue;
            arrayList.add(gridColumn);
        }
        return arrayList;
    }

    protected void addRow(List<? extends RaptorGridCell> list, int n) {
        if (list.size() > this.getColumnCount()) {
            throw new IllegalArgumentException();
        }
        RaptorGridRowModel raptorGridRowModel = new RaptorGridRowModel(list, n);
        this._data.add(raptorGridRowModel);
    }

    protected void addRow(List<? extends RaptorGridCell> list) {
        this.addRow(list, this._data.size());
    }

    protected void addRowImpl(int n, RaptorGridRowModel raptorGridRowModel) {
        if (n < this._data.size()) {
            this._data.add(n, raptorGridRowModel);
        } else {
            this._data.add(raptorGridRowModel);
        }
    }

    public RaptorGridRowModel getRowModel(int n) {
        if (n >= 0 && n < this._data.size()) {
            return this._data.get(n);
        }
        return null;
    }

    protected List<RaptorGridRowModel> getModelList() {
        return this._data;
    }

    protected void setModelList(List<RaptorGridRowModel> list) {
        this._data = list;
    }

    protected void clearModelList() {
        this._data.clear();
    }

    @Override
    public void open(RaptorGridTaskWrapper raptorGridTaskWrapper) throws ExecutionException {
        this._taskWrapper = raptorGridTaskWrapper;
        this.fetchNext(this.getFetchSize(), this._taskWrapper);
    }

    @Override
    public void fetchAllRows(boolean bl) throws ExecutionException {
        if (this.allRowsFetched()) {
            return;
        }
        if (bl) {
            this.fetchNext(Integer.MAX_VALUE, this._taskWrapper);
        } else {
            this.fetchNext(Integer.MAX_VALUE, (RaptorGridTaskWrapper)null);
        }
    }

    protected void fetchNext(int n, RaptorGridTaskWrapper raptorGridTaskWrapper) throws ExecutionException {
        int n2 = Math.max(this.getFetchSize(), n);
        if (this._data == null) {
            this._data = new ArrayList<RaptorGridRowModel>();
        }
        if (raptorGridTaskWrapper != null) {
            List<IRaptorTaskListener> list = raptorGridTaskWrapper.getRaptorTaskListeners();
            if (list != null) {
                this.fetchTaskAdapter.savedModelState();
                if (!list.contains((Object)this.fetchTaskAdapter)) {
                    raptorGridTaskWrapper.getRaptorTaskListeners().add((IRaptorTaskListener)this.fetchTaskAdapter);
                }
            }
            RaptorTask<List<RaptorGridRowModel>> raptorTask = this.createFetchTask(raptorGridTaskWrapper.getTaskName(), raptorGridTaskWrapper.isDeterminate(), raptorGridTaskWrapper.getTaskRunMode(), n2);
            this.submitTask(raptorGridTaskWrapper, raptorTask);
            raptorTask.setMessage(MessageFormat.format(Messages.getString("AbstractRaptorGridModel.0"), n2));
        } else {
            this.fetchNext(n2, (IRaptorTaskProgressUpdater)null);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    AbstractRaptorGridModel.this.fireTableStructureChanged();
                    AbstractRaptorGridModel.this.getRowHeaderModel().fireTableStructureChanged();
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }
    }

    @Override
    public final boolean allRowsFetched() {
        return this._allRowsFetched;
    }

    protected void setAllRowsFetched(boolean bl) {
        this._allRowsFetched = bl;
    }

    protected abstract RaptorTask<List<RaptorGridRowModel>> createFetchTask(String var1, boolean var2, IRaptorTaskRunMode var3, int var4);

    protected abstract void fetchNext(int var1, IRaptorTaskProgressUpdater var2) throws ExecutionException;

    @Override
    public void closeModel() {
        this._data.clear();
        this.setAllRowsFetched(true);
        this.fireTableDataChanged();
        this.getRowHeaderModel().fireTableDataChanged();
        for (RaptorTask<?> raptorTask : this._tasks) {
            if (!IRaptorTaskStatus.isAlive((IRaptorTaskStatus)raptorTask.getStatus())) continue;
            raptorTask.requestCancel();
        }
        this._tasks.clear();
        this._lastStatusMessage = "";
        System.gc();
    }

    protected boolean isTaskRunning() {
        for (RaptorTask<?> raptorTask : this._tasks) {
            if (!IRaptorTaskStatus.isAlive((IRaptorTaskStatus)raptorTask.getStatus())) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getLoadedRowCount() {
        return this._data.size();
    }

    @Override
    public int getRowCount() {
        int n = this.getLoadedRowCount();
        if (!this.allRowsFetched() && n > 0) {
            n += this.getFetchSize();
        }
        return n;
    }

    @Override
    public int getTotalRows(boolean bl) {
        boolean bl2 = this.isFilterApplied();
        int n = 0;
        n = !bl2 ? (this.allRowsFetched() ? this.getLoadedRowCount() : this.findTotalRows(false)) : (bl ? (this.allRowsFetched() ? this.getLoadedRowCount() : this.findTotalRows(true)) : this.findTotalRows(false));
        return n;
    }

    protected abstract int findTotalRows(boolean var1);

    @Override
    public boolean hasColumnNamesUnique() {
        return this._uniqueColNames;
    }

    @Override
    public boolean isVerticalDisplay() {
        return this._verticalDisplay;
    }

    @Override
    public void makeColumnNamesUnique(boolean bl) {
        this._uniqueColNames = bl;
    }

    @Override
    public void refresh() throws ExecutionException {
        if (this.isTaskRunning()) {
            return;
        }
        this.closeModel();
        this.setAllRowsFetched(false);
        this.open(this._taskWrapper);
    }

    @Override
    public int getFetchSize() {
        return this._FETCH_SIZE;
    }

    @Override
    public final void setFetchSize(int n) {
        this._FETCH_SIZE = n;
    }

    @Override
    public void setVerticalDisplay(boolean bl) {
        this._verticalDisplay = bl;
    }

    public String getLastStatusMessage() {
        return this._lastStatusMessage;
    }

    public void publishStatusMessage(String string, Exception exception) {
        for (IStatusMessageConsumer iStatusMessageConsumer : this._statusMessageListeners) {
            iStatusMessageConsumer.setStatusMessage(string, exception);
        }
        this._lastStatusMessage = string;
    }

    public void registerConsumer(IStatusMessageConsumer iStatusMessageConsumer) {
        this._statusMessageListeners.add(iStatusMessageConsumer);
    }

    public void unRegisterConsumer(IStatusMessageConsumer iStatusMessageConsumer) {
        this._statusMessageListeners.remove(iStatusMessageConsumer);
    }

    @Override
    public Class<?> getColumnClass(int n) {
        Object object = this.getValueAt(0, n);
        return object != null ? object.getClass() : Object.class;
    }

    protected void submitTask(RaptorGridTaskWrapper raptorGridTaskWrapper, RaptorTask<?> raptorTask) {
        if (raptorGridTaskWrapper != null) {
            List<IRaptorTaskListener> list = raptorGridTaskWrapper.getRaptorTaskListeners();
            for (IRaptorTaskListener iRaptorTaskListener : list) {
                raptorTask.getDescriptor().addListener(iRaptorTaskListener);
            }
            RaptorTaskManager.getInstance().addTask(raptorTask, raptorGridTaskWrapper.getRaptorTaskUIListeners(), raptorGridTaskWrapper.getTaskViewers());
            this._tasks.add(raptorTask);
        } else {
            try {
                raptorTask.call();
            }
            catch (Exception exception) {
                this.publishStatusMessage(exception.getMessage(), exception);
            }
        }
    }

    public RowHeaderTableModel getRowHeaderModel() {
        if (this._rowHeaderModel == null) {
            this._rowHeaderModel = new RowHeaderTableModel();
        }
        return this._rowHeaderModel;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public boolean isColumnSortable(int n) {
        return this.isSortable() && !this.isVerticalDisplay() && !this.isSkipColumn(n);
    }

    @Override
    public boolean supportsOrderingNulls() {
        return true;
    }

    public Color getRowHighlightColor(int n) {
        if (n >= this.getLoadedRowCount()) {
            return null;
        }
        RaptorGridRowModel raptorGridRowModel = this._data.get(n);
        GridColumnHighlightParameter gridColumnHighlightParameter = null;
        String string = null;
        Object object = null;
        if (raptorGridRowModel != null) {
            int n2 = 0;
            List<? extends GridColumn> list = this.getGridColumns();
            GridColumn gridColumn = null;
            for (n2 = 0; n2 < list.size(); ++n2) {
                gridColumn = list.get(n2);
                gridColumnHighlightParameter = gridColumn.getHighlightParameter();
                if (gridColumnHighlightParameter == null) continue;
                string = gridColumn.getOriginal();
                object = raptorGridRowModel.getRow().get(n2).getCellData();
                break;
            }
            if (string != null && object != null && gridColumnHighlightParameter != null && this._highlightCols.contains(string) && Boolean.valueOf(object.toString()).booleanValue()) {
                return gridColumnHighlightParameter.getHighlightColor();
            }
        }
        return null;
    }

    @Override
    public void addFetchTaskListener(IRaptorTaskListener iRaptorTaskListener) {
        if (this._taskWrapper != null) {
            this._taskWrapper.getRaptorTaskListeners().add(iRaptorTaskListener);
        }
    }

    @Override
    public void removeFetchTaskListener(IRaptorTaskListener iRaptorTaskListener) {
        if (this._taskWrapper != null) {
            this._taskWrapper.getRaptorTaskListeners().remove(iRaptorTaskListener);
        }
    }

    public boolean hasDuplicateColumnNames() {
        List<? extends GridColumn> list = this.getGridColumns();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                GridColumn gridColumn = list.get(i);
                if (gridColumn.getAlias().equals(gridColumn.getOriginal())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isNewRow(int n) {
        if (n < this._data.size()) {
            return this._data.get(n).isNew();
        }
        return false;
    }

    public boolean isDeletedRow(int n) {
        if (n < this._data.size()) {
            return this._data.get(n).isDeleted();
        }
        return false;
    }

    public boolean isUpdatedRow(int n) {
        if (n < this._data.size()) {
            return this._data.get(n).isUpdated();
        }
        return false;
    }

    public abstract boolean isFilterApplied();

    public String getFilterClause() {
        return null;
    }

    public void setFilterClause(String string) {
    }

    public String getSortString() {
        return null;
    }

    public boolean isBusy() {
        return false;
    }

    protected class RowHeaderTableModel
    extends DefaultTableModel {
        protected RowHeaderTableModel() {
        }

        @Override
        public String getColumnName(int n) {
            return ConnectionArb.getString("RS_MODEL_ROW_COLUMN");
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return new Integer(n + 1);
        }

        @Override
        public int getRowCount() {
            return AbstractRaptorGridModel.this.getRowCount();
        }
    }

    private class FetchTaskAdapter
    extends RaptorTaskAdapter {
        protected int savedFetchSize = 0;
        protected int savedRowCount = 0;
        protected int savedLoadedRowCount = 0;

        protected FetchTaskAdapter() {
            this.savedModelState();
        }

        public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    FetchTaskAdapter.this.notifyGridTable();
                }
            };
            SwingUtilities.invokeLater(runnable);
        }

        public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (AbstractRaptorGridModel.this.getLoadedRowCount() == 0) {
                        AbstractRaptorGridModel.this.closeModel();
                        if (AbstractRaptorGridModel.this.getGridColumns() == null) {
                            RaptorGridPersistedSettings.removeLastSort(AbstractRaptorGridModel.this.getModelUniqueName());
                        }
                    } else {
                        FetchTaskAdapter.this.notifyGridTable();
                    }
                }
            };
            SwingUtilities.invokeLater(runnable);
        }

        public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (AbstractRaptorGridModel.this.getLoadedRowCount() == 0) {
                        AbstractRaptorGridModel.this.closeModel();
                        if (AbstractRaptorGridModel.this.getGridColumns() == null) {
                            RaptorGridPersistedSettings.removeLastSort(AbstractRaptorGridModel.this.getModelUniqueName());
                        }
                    } else {
                        FetchTaskAdapter.this.notifyGridTable();
                    }
                }
            };
            SwingUtilities.invokeLater(runnable);
        }

        protected void notifyGridTable() {
            this.notifyGridTable(false);
        }

        protected void notifyGridTable(boolean bl) {
            int n = AbstractRaptorGridModel.this.getRowCount();
            if (bl || this.savedRowCount == 0) {
                AbstractRaptorGridModel.this.fireTableStructureChanged();
            } else if (n < this.savedRowCount) {
                AbstractRaptorGridModel.this.fireTableChanged(new TableModelEvent(AbstractRaptorGridModel.this, n, this.savedRowCount - 1, -1, -1));
            } else if (n > this.savedRowCount) {
                AbstractRaptorGridModel.this.fireTableChanged(new TableModelEvent(AbstractRaptorGridModel.this, this.savedRowCount, n - 1, -1, 1));
            }
            if (bl || this.savedRowCount == 0) {
                AbstractRaptorGridModel.this.getRowHeaderModel().fireTableStructureChanged();
            } else {
                AbstractRaptorGridModel.this.getRowHeaderModel().fireTableDataChanged();
            }
        }

        protected void savedModelState() {
            this.savedFetchSize = AbstractRaptorGridModel.this.getFetchSize();
            this.savedRowCount = AbstractRaptorGridModel.this.getRowCount();
            this.savedLoadedRowCount = AbstractRaptorGridModel.this.getLoadedRowCount();
        }
    }
}

