/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import oracle.dbtools.raptor.controls.IPopupSupplier;

public class MouseMotionTooltipListener
extends MouseAdapter
implements MouseMotionListener {
    private final IPopupSupplier _popupSupplier;
    private JPanel _panel;
    private boolean _enableTT;
    private Popup _lastPu;
    private Object _lastValue;
    private JComponent _comp;
    private long _lastMovement;
    protected boolean _showing;
    private Component _currentComp;
    private Point _location;
    private TimerTask _timerTask;
    private Timer _timer;

    public MouseMotionTooltipListener(JComponent jComponent, IPopupSupplier iPopupSupplier) {
        this._popupSupplier = iPopupSupplier;
        this._comp = jComponent;
        this._comp.addMouseListener(this);
        this._comp.addMouseMotionListener(this);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this._enableTT = true;
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this._enableTT = false;
        if (this._showing && this._lastPu != null) {
            this._lastPu.hide();
        }
        this._showing = false;
        this._lastValue = null;
        if (this._timer != null) {
            this._timer.cancel();
            this._timer = null;
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this._enableTT) {
            this._lastMovement = System.currentTimeMillis();
            this._currentComp = this._popupSupplier.getComponentAt(mouseEvent.getPoint());
            Object object = null;
            if (this._comp instanceof JTable) {
                int n = ((JTable)this._comp).rowAtPoint(mouseEvent.getPoint());
                int n2 = ((JTable)this._comp).columnAtPoint(mouseEvent.getPoint());
                object = ((JTable)this._comp).getValueAt(n, n2);
            } else {
                object = this._currentComp;
            }
            Component component = this._popupSupplier.getPopup(object);
            if ((component == null || object == null) && this._lastPu != null) {
                if (this._showing) {
                    this._lastPu.hide();
                }
                this._showing = false;
                this._lastValue = null;
            }
            if (this._lastValue == null || this._lastValue != object) {
                if (component == null) {
                    if (this._panel != null) {
                        this._panel.removeAll();
                    }
                } else {
                    if (this._showing && this._lastPu != null) {
                        this._lastPu.hide();
                        this._showing = false;
                    }
                    component.setMinimumSize(component.getMinimumSize());
                    component.setMaximumSize(component.getMinimumSize());
                    component.setPreferredSize(component.getMinimumSize());
                    if (this._panel == null) {
                        this._panel = new JPanel(new BorderLayout());
                    }
                    this._panel.removeAll();
                    this._panel.add(component, "Center");
                    this._panel.setBorder(BorderFactory.createRaisedBevelBorder());
                    Dimension dimension = component.getPreferredSize();
                    this._panel.setMinimumSize(dimension);
                    this._panel.setMaximumSize(dimension);
                    this._panel.setPreferredSize(dimension);
                    this.setPopupLocation(mouseEvent);
                    this._lastValue = object;
                    this.schedule();
                }
            } else if (this._lastValue != null && this._lastValue == object) {
                this.setPopupLocation(mouseEvent);
            }
        }
    }

    private void schedule() {
        if (this._timer == null) {
            this._timerTask = new PopTimerTask();
            this._timer = new Timer();
            this._timer.scheduleAtFixedRate(this._timerTask, 100L, 100L);
        }
    }

    public void setPopupLocation(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        for (Component component = this._currentComp; component != null; component = component.getParent()) {
            n += component.getX();
            n2 += component.getY();
        }
        this._location = new Point(n, n2);
    }

    private final class PopTimerTask
    extends TimerTask {
        private PopTimerTask() {
        }

        @Override
        public void run() {
            if (!MouseMotionTooltipListener.this._showing && MouseMotionTooltipListener.this._panel.getComponentCount() > 0 && MouseMotionTooltipListener.this._enableTT && System.currentTimeMillis() - MouseMotionTooltipListener.this._lastMovement > 1000L) {
                MouseMotionTooltipListener.this._showing = true;
                MouseMotionTooltipListener.this._lastPu = PopupFactory.getSharedInstance().getPopup(MouseMotionTooltipListener.this._currentComp, MouseMotionTooltipListener.this._panel, MouseMotionTooltipListener.this._location.x + 10, MouseMotionTooltipListener.this._location.y + 10);
                MouseMotionTooltipListener.this._lastPu.show();
            }
        }
    }
}

