/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.javacompiler;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Stream;
import oracle.jdevimpl.javacompiler.JrtfsJarAccess;
import oracle.ojc.interfaces.Storage;

class JrtfsStorage
implements Storage {
    private JrtfsJarAccess parent;
    private HashMap<String, Object> properties;
    protected Path nioPath;
    private Map<String, Storage> children;

    JrtfsStorage(JrtfsJarAccess parent, Path nioPath) {
        this.parent = parent;
        this.nioPath = nioPath;
        assert (parent != null && nioPath != null) : "Parent and nioPath cannot be null";
    }

    public String getName() {
        int index;
        String path = this.getPath().replace('\\', '/');
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return (index = path.lastIndexOf(47)) > 0 ? path.substring(index + 1) : path;
    }

    public String getPath() {
        return this.nioPath.toString();
    }

    public String getCanonicalPath() {
        return this.getPath();
    }

    public long modDate() {
        return this.parent.modDate();
    }

    public boolean isDirectory() {
        return !this.getPath().endsWith(".class");
    }

    public boolean isInJar() {
        return false;
    }

    public synchronized void setProperty(String property, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(property, value);
    }

    public synchronized Object getProperty(String property) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(property);
    }

    public int size() throws IOException {
        return this.read().length;
    }

    public byte[] read() throws IOException {
        return this.parent.read(this.getName(), this.getPath());
    }

    public int read(byte[] buf) throws IOException {
        byte[] bytes = this.read();
        int avail = bytes.length;
        int nbytes = avail < buf.length ? avail : buf.length;
        for (int x = 0; x < nbytes; ++x) {
            buf[x] = bytes[x];
        }
        return nbytes;
    }

    public void write(byte[] buf, int start, int len) throws IOException {
    }

    public String[] list() {
        ArrayList<Storage> children = this.listStorage();
        String[] names = new String[children.size()];
        for (int x = 0; x < children.size(); ++x) {
            names[x] = children.get(x).getName();
        }
        return names;
    }

    public ArrayList<Storage> listStorage() {
        if (this.children == null) {
            if (this.isDirectory() && this.nioPath != null) {
                LinkedHashMap<String, Storage> newChildren = new LinkedHashMap<String, Storage>();
                try {
                    Stream<Path> stream = Files.list(this.nioPath);
                    Iterator streamIter = stream.iterator();
                    while (streamIter.hasNext()) {
                        JrtfsStorage child = new JrtfsStorage(this.parent, (Path)streamIter.next());
                        newChildren.put(child.getName(), child);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.children = newChildren;
            } else {
                this.children = Collections.emptyMap();
            }
        }
        return new ArrayList<Storage>(this.children.values());
    }

    public void open() throws IOException {
    }

    public Storage open(String name) {
        if (this.children == null) {
            this.listStorage();
        }
        return this.children.get(name);
    }

    public Storage create(String name) throws IOException {
        return null;
    }

    public Storage createDir(String name) throws IOException {
        return null;
    }

    public void close() {
    }
}

