/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.javacompiler;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import oracle.jdevimpl.javacompiler.JavaCompilerLog;
import oracle.jdevimpl.javacompiler.ResourceUtils;
import oracle.ojc.interfaces.Storage;
import oracle.ojc.storage.DirectoryStorage;
import oracle.ojc.storage.JarStorage;

public class JavaCompilerOptions {
    private boolean checkUnusedJars;
    private boolean verbose;
    private JavaCompilerLog log;

    public JavaCompilerOptions() {
    }

    public JavaCompilerOptions(boolean checkUnusedJars, boolean verbose, JavaCompilerLog log) {
        this();
        this.checkUnusedJars = checkUnusedJars;
        this.verbose = verbose;
        this.log = log;
    }

    List<Storage> makePath(String pathList, String pathOption) throws IllegalArgumentException {
        String msg = ResourceUtils.format("PARSING_PATH", "Parsing path: {0}", pathOption);
        msg = "--------------  " + msg + "  --------------";
        this.logMessage(msg);
        String[] as = pathList.split(File.pathSeparator);
        int size = as.length;
        if (size == 0) {
            return new ArrayList<Storage>(0);
        }
        ArrayList<Storage> storageList = new ArrayList<Storage>(size + 10);
        HashSet<String> storagesSeen = new HashSet<String>(size + 10);
        for (int i = 0; i < size; ++i) {
            String dirname;
            String string = dirname = as[i] == null ? null : as[i].trim();
            if (dirname == null || dirname.length() <= 0) continue;
            File dirfile = new File(dirname);
            this.addClassPathItemToList(storageList, storagesSeen, dirname, dirfile, null, "   ");
        }
        msg = ResourceUtils.format("DONE_PARSING_PATH", "Done parsing path: {0}", pathOption);
        this.logMessage(msg);
        return storageList;
    }

    private void addClassPathItemToList(ArrayList<Storage> list, HashSet<String> storagesSeen, String dirname, File dirfile, Storage enclosingJar, String indent) throws IllegalArgumentException {
        if (dirname.indexOf("..") >= 0) {
            try {
                dirname = dirfile.getCanonicalPath();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (storagesSeen.contains(dirname)) {
            String msg = ResourceUtils.format("SKIPPING_DUPLICATE_ENTRY", "Skipping duplicate entry: {0}", dirname);
            this.logMessage(indent + msg);
            return;
        }
        storagesSeen.add(dirname);
        this.logMessage(indent + dirname);
        if (dirname.endsWith(".jar") || dirname.endsWith(".zip")) {
            String cp;
            Attributes mainAttrs;
            Manifest manifest;
            JarStorage jarStorage = new JarStorage(dirfile);
            if (!jarStorage.isOpen()) {
                String msg = ResourceUtils.format("ENTRY_DOES_NOT_EXIST", "Path entry does not exist: {0}", dirname);
                this.logMessage(indent + msg);
                return;
            }
            list.add((Storage)jarStorage);
            if (this.verbose || this.checkUnusedJars) {
                jarStorage.setProperty("javacompiler.enclosing.jar", enclosingJar != null ? enclosingJar : jarStorage);
                if (enclosingJar == null) {
                    Boolean used = jarStorage.getPath().replace('\\', '/').indexOf("/jre/") > 0;
                    jarStorage.setProperty("javacompiler.enclosing.jar.used", (Object)used);
                }
            }
            if ((manifest = jarStorage.getManifest()) != null && (mainAttrs = manifest.getMainAttributes()) != null && (cp = mainAttrs.getValue(Attributes.Name.CLASS_PATH)) != null && cp.trim().length() > 0) {
                ArrayList<String> classpathEntries = new ArrayList<String>();
                StringTokenizer st = new StringTokenizer(cp);
                while (st.hasMoreTokens()) {
                    classpathEntries.add(st.nextToken());
                }
                if (this.verbose) {
                    int i;
                    String msg = ResourceUtils.getString("PARSING_MANIFEST_PATH", "Parsing manifest path:");
                    String prefix = indent + msg;
                    this.logMessage((String)prefix + (String)classpathEntries.get(0));
                    StringBuilder spaces = new StringBuilder(prefix.length());
                    for (i = 0; i < prefix.length(); ++i) {
                        spaces.append(' ');
                    }
                    for (i = 1; i < classpathEntries.size(); ++i) {
                        this.logMessage(spaces.toString() + (String)classpathEntries.get(i));
                    }
                }
                File dir = dirfile.getParentFile();
                for (String entry : classpathEntries) {
                    File cpItemFile = new File(dir, entry);
                    this.addClassPathItemToList(list, storagesSeen, cpItemFile.getAbsolutePath(), cpItemFile, (Storage)(enclosingJar != null ? enclosingJar : jarStorage), indent + "   ");
                }
                String msg = ResourceUtils.getString("DONE_PARSING_MANIFEST_PATH", "Done parsing manifest path");
                this.logMessage(indent + msg);
            }
        } else if (dirfile.isDirectory()) {
            list.add((Storage)new DirectoryStorage(dirfile));
        }
    }

    private void logMessage(String message) {
        if (this.verbose) {
            if (this.log != null) {
                this.log.println(message);
            } else {
                System.out.println(message);
            }
        }
    }
}

