/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.javacompiler;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;

public class FileJavaFileObject
extends SimpleJavaFileObject {
    private File file;

    public FileJavaFileObject(File file) {
        super(file.toURI(), JavaFileObject.Kind.SOURCE);
        this.file = file;
    }

    @Override
    public InputStream openInputStream() throws IOException {
        try (FileInputStream in = new FileInputStream(this.file);){
            int available = in.available();
            byte[] buf = new byte[available];
            in.read(buf, 0, available);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(buf);
            return byteArrayInputStream;
        }
    }

    @Override
    public long getLastModified() {
        return this.file.lastModified();
    }
}

