/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.viewBuilder.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Vector;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import oracle.bali.dbUI.db.Column;
import oracle.bali.dbUI.db.Table;
import oracle.bali.dbUI.dnd.DBUIDataFlavors;
import oracle.bali.dbUI.dnd.DBUIDnDSupport;
import oracle.bali.dbUI.dnd.DBUITransferableProvider;
import oracle.bali.dbUI.laf.DBUILookAndFeel;
import oracle.bali.dbUI.viewBuilder.RelationshipLink;
import oracle.bali.dbUI.viewBuilder.RelationshipLinkPainter;
import oracle.bali.dbUI.viewBuilder.ViewBuilder;
import oracle.bali.dbUI.viewBuilder.ViewBuilderCanvas;
import oracle.bali.dbUI.viewBuilder.ViewBuilderComponent;
import oracle.bali.dbUI.viewBuilder.ViewBuilderLink;
import oracle.bali.dbUI.viewBuilder.ViewBuilderLinkPainter;
import oracle.bali.dbUI.viewBuilder.swing.VBJDKDropSupport;
import oracle.bali.ewt.dnd.DropTarget;
import oracle.bali.ewt.dnd.DropTargetContext;
import oracle.bali.ewt.dnd.DropTargetDragEvent;
import oracle.bali.ewt.dnd.DropTargetDropEvent;
import oracle.bali.ewt.dnd.DropTargetEvent;
import oracle.bali.ewt.dnd.DropTargetListener;
import oracle.bali.ewt.dnd.JFCSupport;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.share.datatransfer.TransferUtils;

public class JInternalFrameViewBuilderCanvas
extends JDesktopPane
implements ViewBuilderCanvas {
    private ViewBuilder _builder;
    private VBJDKDropSupport _jdkDropSupport;
    private Color _color;
    private Listener _listener;
    private Vector _linkPainters = new Vector();
    private Vector _selectedLinkPainters = new Vector();
    private Vector _activeLinkPainters = new Vector();

    public JInternalFrameViewBuilderCanvas() {
        this._listener = new Listener();
        this.setBackground(Color.white);
        this._jdkDropSupport = new VBJDKDropSupport(this);
        this._addDropTarget(this);
        this.enableEvents(16L);
        this.setDragMode(1);
        InputMap imap = this.getInputMap(2);
        imap.put(KeyStroke.getKeyStroke(121, 1), "ShowMenu");
        ActionMap amap = this.getActionMap();
        amap.put("ShowMenu", new MenuAction());
    }

    @Override
    public void addComponent(ViewBuilderComponent component) {
        if (!(component instanceof JInternalFrame)) {
            throw new IllegalArgumentException("JInternalFrameViewBuilderCanvas must be used with JInternalFrameTableComponent");
        }
        super.add((JInternalFrame)((Object)component));
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void setViewBuilder(ViewBuilder builder) {
        this._builder = builder;
    }

    @Override
    public ViewBuilder getViewBuilder() {
        return this._builder;
    }

    @Override
    public void setSelectedComponent(ViewBuilderComponent selectedComponent) {
        if (selectedComponent != null && !(selectedComponent instanceof JInternalFrame)) {
            throw new IllegalArgumentException("JInternalFrameViewBuilderCanvas must be used with JInternalFrameTableComponent");
        }
        try {
            if (selectedComponent == null) {
                JInternalFrame fr = this.getSelectedFrame();
                if (fr != null) {
                    fr.setSelected(false);
                }
            } else {
                ((JInternalFrame)((Object)selectedComponent)).setSelected(true);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    @Override
    public ViewBuilderComponent getViewBuilderComponentAt(int x, int y) {
        Component c = this.getComponentAt(x, y);
        if (c instanceof ViewBuilderComponent) {
            return (ViewBuilderComponent)((Object)c);
        }
        return null;
    }

    @Override
    public void addViewBuilderLink(ViewBuilderLink link) {
        ViewBuilderLinkPainter painter = this.createLinkPainter(link);
        if (painter != null) {
            this._linkPainters.addElement(painter);
            ViewBuilderComponent parent = link.getSourcePort(0).getViewBuilderComponent();
            ViewBuilderComponent child = link.getDestinationPort(0).getViewBuilderComponent();
            boolean active = parent.isComponentSelected() || child.isComponentSelected();
            link.setActive(active);
            if (active) {
                this._activeLinkPainters.addElement(painter);
            }
            painter.addPropertyChangeListener(this._listener);
            link.addPropertyChangeListener(this._listener);
            painter.invalidate();
            this._validateScrollBox();
            this.repaint();
        }
    }

    @Override
    public void removeViewBuilderLink(ViewBuilderLink link) {
        ViewBuilderLinkPainter painter = this._getPainter(link);
        if (painter == null) {
            return;
        }
        painter.removePropertyChangeListener(this._listener);
        link.removePropertyChangeListener(this._listener);
        painter.cleanup();
        this._linkPainters.removeElement((Object)painter);
        int index = this._selectedLinkPainters.indexOf((Object)painter);
        if (index != -1) {
            this._selectedLinkPainters.removeElementAt(index);
        }
        if ((index = this._activeLinkPainters.indexOf((Object)painter)) != -1) {
            this._activeLinkPainters.removeElementAt(index);
        }
        this._validateScrollBox();
        this.repaint();
    }

    @Override
    public Dimension getDocumentSize(PaintContext context, Dictionary printProperties) {
        return this.getPreferredSize();
    }

    @Override
    public void printPage(PaintContext context, Dictionary printProperties, Graphics g) {
        Shape savedClip = g.getClip();
        this._paintLinks(context, g);
        this.print(g);
        g.setClip(savedClip);
    }

    @Override
    public Rectangle getPageBounds(PaintContext context, Dictionary printProperties, int pageXOrigin, int pageYOrigin, int pageWidth, int pageHeight) {
        Component component;
        Rectangle bounds;
        int count = this.getComponentCount();
        int x = pageXOrigin + pageWidth;
        for (int i = 0; i < count; ++i) {
            if (x < pageXOrigin) {
                x = pageXOrigin + pageWidth;
            }
            if (!(bounds = (component = this.getComponent(i)).getBounds()).contains(x, bounds.y)) continue;
            x = bounds.x - 10;
            i = 0;
        }
        int y = pageYOrigin + pageHeight;
        for (int i = 0; i < count; ++i) {
            if (y < pageYOrigin) {
                x = pageYOrigin + pageHeight;
            }
            if (!(bounds = (component = this.getComponent(i)).getBounds()).contains(bounds.x, y)) continue;
            y = bounds.y - 10;
            i = 0;
        }
        int width = x - pageXOrigin;
        int height = y - pageYOrigin;
        Rectangle r = new Rectangle(width, height, width, height);
        return r;
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        super.addImpl(comp, constraints, index);
        if (comp instanceof JComponent) {
            this._addDropTarget((JComponent)comp);
        }
        if (comp instanceof ViewBuilderComponent) {
            ((ViewBuilderComponent)((Object)comp)).addPropertyChangeListener(this._listener);
        }
        if (comp instanceof JInternalFrame.JDesktopIcon) {
            comp.addComponentListener(this._listener);
        }
        this._setWindowEnabled(comp, this.isEnabled());
        this._validateScrollBox();
    }

    @Override
    public void remove(int index) {
        Component c = this.getComponent(index);
        if (c instanceof JComponent) {
            this._removeDropTarget((JComponent)c);
        }
        if (c instanceof ViewBuilderComponent) {
            ((ViewBuilderComponent)((Object)c)).removePropertyChangeListener(this._listener);
        }
        if (c instanceof JInternalFrame.JDesktopIcon) {
            c.removeComponentListener(this._listener);
        }
        super.remove(index);
        this._validateScrollBox();
    }

    @Override
    public Dimension getPreferredSize() {
        Rectangle bounds;
        int count = this.getComponentCount();
        int maxWidth = 0;
        int maxHeight = 0;
        for (int i = 0; i < count; ++i) {
            Component child = this.getComponent(i);
            bounds = child.getBounds();
            if (bounds.x + bounds.width > maxWidth) {
                maxWidth = bounds.x + bounds.width;
            }
            if (bounds.y + bounds.height <= maxHeight) continue;
            maxHeight = bounds.y + bounds.height;
        }
        int size = this._linkPainters.size();
        PaintContext context = this._builder.getPaintContext();
        for (int i = 0; i < size; ++i) {
            ViewBuilderLinkPainter painter = (ViewBuilderLinkPainter)((Object)this._linkPainters.elementAt(i));
            bounds = painter.getBounds(context);
            if (bounds.x + bounds.width > maxWidth) {
                maxWidth = bounds.x + bounds.width;
            }
            if (bounds.y + bounds.height <= maxHeight) continue;
            maxHeight = bounds.y + bounds.height;
        }
        return new Dimension(maxWidth + 2, maxHeight + 2);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        int count = this.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component c = this.getComponent(i);
            this._setWindowEnabled(c, this.isEnabled());
        }
    }

    @Override
    public void requestFocus() {
        super.requestFocus();
    }

    @Override
    protected void paintComponent(Graphics g) {
        this._paintLinks(this._builder.getPaintContext(), g);
    }

    protected ViewBuilderLinkPainter createLinkPainter(ViewBuilderLink link) {
        if (link instanceof RelationshipLink) {
            return new RelationshipLinkPainter((RelationshipLink)link);
        }
        return null;
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
        if (e.isConsumed() || !this.isEnabled()) {
            return;
        }
        if (e.isPopupTrigger()) {
            this._editJoins(e);
        } else if (e.getID() == 501) {
            this._selectJoins(e);
        }
    }

    void __changeFocus(boolean forward) {
        int count = this._linkPainters.size();
        if (count == 0) {
            this.getViewBuilder().transferFocus();
        } else {
            ViewBuilderLinkPainter painter = (ViewBuilderLinkPainter)((Object)this._linkPainters.elementAt(0));
            this.getViewBuilder().setLinkSelected(painter.getLink(), true);
            this.getViewBuilder().requestFocus();
        }
    }

    private void _paintLinks(PaintContext context, Graphics g) {
        ViewBuilderLinkPainter painter;
        int i;
        int size = this._linkPainters.size();
        if (size == 0) {
            return;
        }
        Dimension d = this.getSize();
        for (i = 0; i < size; ++i) {
            painter = (ViewBuilderLinkPainter)((Object)this._linkPainters.elementAt(i));
            if (painter.getLink().isSelected() || painter.getLink().isActive()) continue;
            painter.paint(context, g, 0, 0, d.width, d.height);
        }
        size = this._activeLinkPainters.size();
        for (i = 0; i < size; ++i) {
            painter = (ViewBuilderLinkPainter)((Object)this._activeLinkPainters.elementAt(i));
            painter.paint(context, g, 0, 0, d.width, d.height);
        }
        size = this._selectedLinkPainters.size();
        for (i = 0; i < size; ++i) {
            painter = (ViewBuilderLinkPainter)((Object)this._selectedLinkPainters.elementAt(i));
            painter.paint(context, g, 0, 0, d.width, d.height);
        }
    }

    private void _validateScrollBox() {
        this.invalidate();
        Component scrollBox = this._getScrollBox();
        if (scrollBox != null) {
            scrollBox.validate();
        }
    }

    private Component _getScrollBox() {
        for (Container parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof JScrollPane)) continue;
            return parent;
        }
        return null;
    }

    private void _updateLinkSelectionState(ViewBuilderLink link, boolean selected) {
        int index;
        boolean accessible = this.accessibleContext != null;
        AccessibleContext ac = accessible ? this.getViewBuilder().getAccessibleContext() : null;
        String oldName = null;
        if (ac != null) {
            oldName = ac.getAccessibleName();
        }
        ViewBuilderLinkPainter painter = this._getPainter(link);
        if (selected) {
            index = this._selectedLinkPainters.indexOf((Object)painter);
            if (index == -1) {
                this._selectedLinkPainters.addElement(painter);
            }
        } else {
            index = this._selectedLinkPainters.indexOf((Object)painter);
            if (index != -1) {
                this._selectedLinkPainters.removeElementAt(index);
            }
        }
        if (ac != null) {
            String newName = ac.getAccessibleName();
            ac.firePropertyChange("AccessibleName", oldName, newName);
        }
        this.repaint();
    }

    private void _updateLinkActiveState(ViewBuilderLink link, boolean active) {
        ViewBuilderLinkPainter painter = this._getPainter(link);
        if (active) {
            int index = this._activeLinkPainters.indexOf((Object)painter);
            if (index == -1) {
                this._activeLinkPainters.addElement(painter);
            }
        } else {
            int index = this._activeLinkPainters.indexOf((Object)painter);
            if (index != -1) {
                this._activeLinkPainters.removeElementAt(index);
            }
        }
        this.repaint();
    }

    private void _invalidateJoins(ViewBuilderComponent source) {
        ViewBuilderLink[] links = this.getViewBuilder().getLinks(source);
        if (links == null) {
            return;
        }
        for (int i = 0; i < links.length; ++i) {
            ViewBuilderLinkPainter painter = this._getPainter(links[i]);
            painter.invalidate();
        }
        this.repaint();
    }

    private void _selectJoins(MouseEvent e) {
        ViewBuilderLinkPainter painter = this._findJoinPainter(e.getX(), e.getY());
        if (painter == null) {
            this.getViewBuilder().setAllLinksSelected(false);
            this.setSelectedComponent(null);
        } else {
            ViewBuilderLink link = painter.getLink();
            int count = e.getClickCount();
            if (count == 1) {
                boolean selected = false;
                if (e.isControlDown()) {
                    selected = !link.isSelected();
                } else if (e.isShiftDown()) {
                    selected = true;
                } else {
                    this.getViewBuilder().setAllLinksSelected(false);
                    selected = true;
                }
                this.getViewBuilder().setLinkSelected(link, selected);
                e.consume();
                this.setSelectedComponent(null);
                this.getViewBuilder().requestFocus();
            } else if (count == 2 && link instanceof RelationshipLink) {
                RelationshipLink rLink = (RelationshipLink)link;
                rLink.setUserDoubleClick(true);
                boolean included = !rLink.isIncluded();
                this.getViewBuilder().setRelationshipIncluded(rLink.getRelationship(), included);
                e.consume();
            }
        }
    }

    private void _editJoins(MouseEvent e) {
        ViewBuilderLinkPainter painter = this._findJoinPainter(e.getX(), e.getY());
        if (painter == null) {
            return;
        }
        e.consume();
        ViewBuilder builder = this.getViewBuilder();
        Point p = SwingUtilities.convertPoint(this, e.getPoint(), (Component)((Object)builder));
        builder.showMenu(painter.getLink(), p.x, p.y);
    }

    private ViewBuilderLinkPainter _findJoinPainter(int x, int y) {
        PaintContext context = this._builder.getPaintContext();
        int size = this._linkPainters.size();
        for (int i = 0; i < size; ++i) {
            ViewBuilderLinkPainter painter = (ViewBuilderLinkPainter)((Object)this._linkPainters.elementAt(i));
            if (!painter.contains(context, x, y)) continue;
            return painter;
        }
        return null;
    }

    private ViewBuilderLinkPainter _getPainter(ViewBuilderLink link) {
        int count = this._linkPainters.size();
        for (int i = 0; i < count; ++i) {
            ViewBuilderLinkPainter p = (ViewBuilderLinkPainter)((Object)this._linkPainters.elementAt(i));
            if (p.getLink() != link) continue;
            return p;
        }
        return null;
    }

    private void _setWindowEnabled(Component c, boolean e) {
        c.setEnabled(e);
        this._setEnabled(c, e);
    }

    private void _setEnabled(Component c, boolean e) {
        c.setEnabled(e);
        if (c instanceof Container) {
            Container cont = (Container)c;
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                this._setEnabled(cont.getComponent(i), e);
            }
        }
    }

    private void _addDropTarget(JComponent comp) {
        this._jdkDropSupport.addDropTarget(comp);
        if (JFCSupport.getEWTDropTarget((JComponent)comp) != null) {
            return;
        }
        DropTarget dummy = new DropTarget((Component)comp, (DropTargetListener)this._listener);
        int count = comp.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component child = comp.getComponent(i);
            if (!(child instanceof JComponent)) continue;
            this._addDropTarget((JComponent)child);
        }
    }

    private void _removeDropTarget(JComponent comp) {
        this._jdkDropSupport.removeDropTarget(comp);
        DropTarget drop = JFCSupport.getEWTDropTarget((JComponent)comp);
        boolean found = true;
        try {
            drop.removeDropTargetListener((DropTargetListener)this._listener);
        }
        catch (Exception e) {
            found = false;
        }
        if (found) {
            JFCSupport.setEWTDropTarget((JComponent)comp, null);
        }
        int count = comp.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component child = comp.getComponent(i);
            if (!(child instanceof JComponent)) continue;
            this._removeDropTarget((JComponent)child);
        }
    }

    private class MenuAction
    extends AbstractAction {
        private MenuAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Rectangle bounds;
            Container parent = JInternalFrameViewBuilderCanvas.this.getParent();
            if (parent instanceof JViewport) {
                JViewport port = (JViewport)parent;
                bounds = port.getViewRect();
            } else {
                bounds = JInternalFrameViewBuilderCanvas.this.getBounds();
            }
            ViewBuilder builder = JInternalFrameViewBuilderCanvas.this.getViewBuilder();
            for (int i = 0; i < JInternalFrameViewBuilderCanvas.this._selectedLinkPainters.size(); ++i) {
                ViewBuilderLinkPainter painter = (ViewBuilderLinkPainter)((Object)JInternalFrameViewBuilderCanvas.this._selectedLinkPainters.elementAt(i));
                Point p = painter.getPoint(builder.getPaintContext(), bounds);
                if (p == null) continue;
                p = SwingUtilities.convertPoint(JInternalFrameViewBuilderCanvas.this, p, (Component)((Object)builder));
                builder.showMenu(painter.getLink(), p.x, p.y);
                break;
            }
        }

        @Override
        public boolean isEnabled() {
            return JInternalFrameViewBuilderCanvas.this._selectedLinkPainters.size() != 0;
        }
    }

    private class Listener
    extends ComponentAdapter
    implements PropertyChangeListener,
    DropTargetListener {
        private Listener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            Object source = e.getSource();
            Object newValue = e.getNewValue();
            if ("selected".equals(name)) {
                if (source instanceof ViewBuilderLink) {
                    JInternalFrameViewBuilderCanvas.this._updateLinkSelectionState((ViewBuilderLink)source, (Boolean)newValue);
                }
            } else if ("active".equals(name)) {
                if (source instanceof ViewBuilderLink) {
                    JInternalFrameViewBuilderCanvas.this._updateLinkActiveState((ViewBuilderLink)source, (Boolean)newValue);
                }
            } else if ("invalid".equals(name)) {
                JInternalFrameViewBuilderCanvas.this.repaint();
            } else if ("bounds".equals(name)) {
                ViewBuilderComponent component = (ViewBuilderComponent)e.getSource();
                JInternalFrameViewBuilderCanvas.this._invalidateJoins(component);
                JInternalFrameViewBuilderCanvas.this._validateScrollBox();
            } else {
                JInternalFrameViewBuilderCanvas.this.repaint();
            }
        }

        public void dragEnter(DropTargetDragEvent dtde) {
            if (this._acceptDrag(dtde)) {
                JInternalFrameViewBuilderCanvas.this._color = JInternalFrameViewBuilderCanvas.this._builder.getBackground();
                JInternalFrameViewBuilderCanvas.this._builder.setBackground(Color.lightGray);
            } else {
                dtde.rejectDrag();
            }
        }

        public void dragOver(DropTargetDragEvent dtde) {
            if (!this._acceptDrag(dtde)) {
                dtde.rejectDrag();
            }
        }

        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        public void dragExit(DropTargetEvent dtde) {
            if (JInternalFrameViewBuilderCanvas.this._color != null) {
                JInternalFrameViewBuilderCanvas.this._builder.setBackground(JInternalFrameViewBuilderCanvas.this._color);
            }
            JInternalFrameViewBuilderCanvas.this._color = null;
        }

        public void drop(DropTargetDropEvent dtde) {
            DBUITransferableProvider[] providers;
            Object data;
            if (JInternalFrameViewBuilderCanvas.this._color != null) {
                JInternalFrameViewBuilderCanvas.this._builder.setBackground(JInternalFrameViewBuilderCanvas.this._color);
            }
            JInternalFrameViewBuilderCanvas.this._color = null;
            DropTargetContext context = dtde.getDropTargetContext();
            if (!JInternalFrameViewBuilderCanvas.this.isEnabled()) {
                dtde.rejectDrop();
                context.dropComplete(false);
                return;
            }
            dtde.acceptDrop(2);
            Transferable transfer = dtde.getTransferable();
            Table table = null;
            Column column = null;
            if (transfer.isDataFlavorSupported(DBUIDataFlavors.COLUMN_FLAVOR)) {
                data = null;
                try {
                    data = transfer.getTransferData(DBUIDataFlavors.COLUMN_FLAVOR);
                }
                catch (IOException ioe) {
                    data = null;
                }
                catch (UnsupportedFlavorException ufe) {
                    data = null;
                }
                if (data instanceof Column && (column = (Column)data) != null) {
                    table = column.getTable();
                }
            }
            if (table == null && transfer.isDataFlavorSupported(DBUIDataFlavors.TABLE_FLAVOR)) {
                data = null;
                try {
                    data = transfer.getTransferData(DBUIDataFlavors.TABLE_FLAVOR);
                }
                catch (IOException ioe) {
                    data = null;
                }
                catch (UnsupportedFlavorException ufe) {
                    data = null;
                }
                if (data instanceof Table) {
                    table = (Table)data;
                }
            }
            if (table == null && (providers = DBUIDnDSupport.getDBUITransferableProviders()) != null) {
                for (int i = 0; table == null && i < providers.length; ++i) {
                    Object data2 = providers[i].getDBUITransferData(transfer, DBUIDataFlavors.COLUMN_FLAVOR);
                    if (data2 instanceof Column) {
                        column = (Column)data2;
                        table = column.getTable();
                        continue;
                    }
                    data2 = providers[i].getDBUITransferData(transfer, DBUIDataFlavors.TABLE_FLAVOR);
                    if (!(data2 instanceof Table)) continue;
                    table = (Table)data2;
                }
            }
            if (table != null) {
                Point p = dtde.getLocation();
                for (Component c = context.getComponent(); c != JInternalFrameViewBuilderCanvas.this._builder && c != null; c = c.getParent()) {
                    Point temp = c.getLocation();
                    p.x += temp.x;
                    p.y += temp.y;
                }
                DBUILookAndFeel.getLookAndFeel().setCursor(JInternalFrameViewBuilderCanvas.this, true);
                JInternalFrameViewBuilderCanvas.this._builder.addTable(table, p.x, p.y, true);
                DBUILookAndFeel.getLookAndFeel().setCursor(JInternalFrameViewBuilderCanvas.this, false);
                if (column != null) {
                    JInternalFrameViewBuilderCanvas.this._builder.setColumnSelected(column, true);
                }
                JInternalFrameViewBuilderCanvas.this._builder.repaint();
            }
            context.dropComplete(table != null);
        }

        private boolean _acceptDrag(DropTargetDragEvent dtde) {
            if (!JInternalFrameViewBuilderCanvas.this.isEnabled()) {
                return false;
            }
            DataFlavor[] flavors = dtde.getCurrentDataFlavors();
            if (flavors == null) {
                return false;
            }
            DBUITransferableProvider[] providers = DBUIDnDSupport.getDBUITransferableProviders();
            for (int i = 0; i < flavors.length; ++i) {
                if (TransferUtils.supportsDataFlavor((DataFlavor)flavors[i], (DataFlavor)DBUIDataFlavors.TABLE_FLAVOR)) {
                    return true;
                }
                if (TransferUtils.supportsDataFlavor((DataFlavor)flavors[i], (DataFlavor)DBUIDataFlavors.COLUMN_FLAVOR)) {
                    return true;
                }
                if (providers == null) continue;
                for (int j = 0; j < providers.length; ++j) {
                    if (!providers[j].isDBUIDataFlavorSupported(flavors[i], DBUIDataFlavors.TABLE_FLAVOR) && !providers[j].isDBUIDataFlavorSupported(flavors[i], DBUIDataFlavors.COLUMN_FLAVOR)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public void componentMoved(ComponentEvent ce) {
            JInternalFrameViewBuilderCanvas.this._invalidateJoins((ViewBuilderComponent)((Object)((JInternalFrame.JDesktopIcon)ce.getComponent()).getInternalFrame()));
        }
    }
}

