/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.util.jdbc;

import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Locale;
import oracle.bali.dbUI.constraint.Constrainable;
import oracle.bali.dbUI.constraint.DataConstraint;
import oracle.bali.dbUI.db.Column;
import oracle.bali.dbUI.db.DataDescriptor;
import oracle.bali.dbUI.db.DataDescriptorProvider;
import oracle.bali.dbUI.db.OuterJoin;
import oracle.bali.dbUI.db.Relationship;
import oracle.bali.dbUI.db.impl.DataDescriptorImpl;
import oracle.bali.dbUI.util.sql.SQLGenerator;
import oracle.bali.ewt.model.ArrayTwoDModel;
import oracle.bali.ewt.model.Sortable;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.model.TwoDModelListener;
import oracle.bali.share.thread.Task;
import oracle.bali.share.thread.TaskEvent;
import oracle.bali.share.thread.TaskScheduler;
import oracle.bali.share.util.IntegerUtils;

public class JDBCModel
implements TwoDModel,
DataDescriptorProvider,
Constrainable,
Sortable {
    private ArrayTwoDModel _data;
    private DataDescriptor[] _descriptors;
    private DataConstraint _constraint;
    private String _originalQuery;
    private String _constraintQuery;
    private String _sortQuery;
    private Connection _connection;
    ResultSetMetaData _metaData;
    private DataTask _task;
    private TaskScheduler _scheduler;
    private Column[] _columns;

    public JDBCModel(Connection connection, Column[] columns, DataConstraint constraint, Relationship[] relationships, OuterJoin[] outerJoins) throws SQLException {
        String sql = SQLGenerator.getSQLGenerator().getSQLString(columns, constraint, relationships, outerJoins);
        this._data = new ArrayTwoDModel(0, 0);
        if (columns != null) {
            this._columns = new Column[columns.length];
            System.arraycopy(columns, 0, this._columns, 0, columns.length);
        }
        this._connection = connection;
        this._originalQuery = sql;
        this._scheduler = new TaskScheduler();
        if (sql != null) {
            this._originalQuery = sql;
            this._query();
        }
    }

    public JDBCModel(Connection connection, String query) throws SQLException {
        this._data = new ArrayTwoDModel(0, 0);
        this._connection = connection;
        this._originalQuery = query;
        this._scheduler = new TaskScheduler();
        if (query != null) {
            this._originalQuery = query;
            this._query();
        }
    }

    public int getColumnCount() {
        return this._data.getColumnCount();
    }

    public int getRowCount() {
        return this._data.getRowCount();
    }

    public Object getData(int columnIndex, int rowIndex) {
        return this._data.getData(columnIndex, rowIndex);
    }

    public void setData(int columnIndex, int rowIndex, Object data) {
        throw new RuntimeException("setData not supported.");
    }

    public void addModelListener(TwoDModelListener listener) {
        this._data.addModelListener(listener);
    }

    public void removeModelListener(TwoDModelListener listener) {
        this._data.removeModelListener(listener);
    }

    @Override
    public void setDataConstraint(DataConstraint d) {
        String newQuery = SQLGenerator.getSQLGenerator().getSQLString(null, d, null, null);
        if (newQuery == null && this._constraintQuery == null) {
            return;
        }
        if (newQuery != null && this._constraintQuery != null && newQuery.equals(this._constraintQuery)) {
            return;
        }
        this._constraintQuery = newQuery;
        try {
            this._query();
        }
        catch (SQLException e) {
            System.err.println("An exception occurred in setDataConstraint: " + e);
        }
    }

    @Override
    public DataConstraint getDataConstraint() {
        return this._constraint;
    }

    public void sort(int column, boolean ascending) {
        try {
            String name = this.getDescriptor(column).getName();
            this._sortQuery = name + " " + (ascending ? "ASC" : "DESC");
            this._query();
        }
        catch (SQLException e) {
            System.err.println("An exception occurred in sort: " + e);
        }
    }

    @Override
    public int getDescriptorCount() {
        return this.getColumnCount();
    }

    @Override
    public DataDescriptor getDescriptor(int index) {
        if (this._descriptors == null) {
            this._createDescriptors();
        }
        return this._descriptors[index];
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
    }

    void _setData(int col, int row, Object data) {
        this._data.setData(col, row, data);
    }

    private DataDescriptor _createDescriptor(int index) {
        Object defaultValue;
        boolean allowsNull;
        Class type;
        String label;
        String name;
        try {
            if (this._columns != null) {
                Column column = this._columns[index];
                name = column.getName();
                if (name.indexOf(".") == -1) {
                    name = column.getTable().getName() + "." + name;
                }
                label = column.getDisplayName(Locale.getDefault());
                type = column.getDataType();
                allowsNull = column.isNullAllowed();
                defaultValue = column.getDefaultValue();
            } else {
                String tableName = this._metaData.getTableName(++index);
                name = this._metaData.getColumnName(index);
                if (tableName != null && tableName != "") {
                    name = tableName + "." + name;
                }
                label = this._metaData.getColumnLabel(index);
                int digits = this._metaData.getScale(index);
                type = this._getColumnDataType(index, digits);
                int nullable = this._metaData.isNullable(index);
                allowsNull = nullable == 1;
                defaultValue = null;
            }
        }
        catch (SQLException e) {
            System.err.println(e);
            return null;
        }
        return new DataDescriptorImpl(type, name, label, allowsNull, defaultValue);
    }

    private void _createDescriptors() {
        int count = this.getColumnCount();
        this._descriptors = new DataDescriptor[count];
        for (int i = 0; i < count; ++i) {
            this._descriptors[i] = this._createDescriptor(i);
        }
    }

    private Class _getColumnDataType(int index, int digits) throws SQLException {
        Class c;
        int type = this._metaData.getColumnType(index);
        switch (type) {
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                c = Integer.class;
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 1111: {
                c = Object.class;
                break;
            }
            case -7: {
                c = Boolean.class;
                break;
            }
            case 91: {
                c = Date.class;
                break;
            }
            case 92: {
                c = Time.class;
                break;
            }
            case 93: {
                c = Timestamp.class;
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                if (digits == 0) {
                    c = Long.class;
                    break;
                }
                c = Double.class;
                break;
            }
            case 6: {
                c = Float.class;
                break;
            }
            case 1: {
                c = Character.class;
                break;
            }
            case -1: 
            case 12: {
                c = String.class;
                break;
            }
            default: {
                c = null;
            }
        }
        return c;
    }

    private void _query() throws SQLException {
        if (this._originalQuery == null) {
            return;
        }
        if (this._task != null) {
            this._scheduler.cancel((Task)this._task);
            this._task.cancel();
        }
        this._task = null;
        String query = this._originalQuery;
        if (this._constraintQuery != null) {
            query = this._originalQuery.toUpperCase().indexOf("WHERE") == -1 ? query + " WHERE " + this._constraintQuery : query + " AND (" + this._constraintQuery + ")";
        }
        if (this._sortQuery != null) {
            query = query + " order by " + this._sortQuery;
        }
        PreparedStatement statement = this._connection.prepareStatement(query);
        ResultSet resultSet = statement.executeQuery();
        this._metaData = resultSet.getMetaData();
        int columnCount = this._metaData.getColumnCount();
        int oldCount = this.getColumnCount();
        if (oldCount != columnCount) {
            if (oldCount != 0) {
                this._data.removeColumns(0, oldCount);
            }
            this._data.addColumns(0, columnCount);
        }
        if (this._columns == null && this._descriptors == null) {
            this._createDescriptors();
        }
        this._task = new DataTask(resultSet, statement);
        this._scheduler.schedule((Task)this._task, 0);
    }

    Object _getColumnData(ResultSet results, int column) throws SQLException {
        Object data;
        ResultSetMetaData metaData = results.getMetaData();
        int type = metaData.getColumnType(column);
        int digits = metaData.getScale(column);
        switch (type) {
            case 91: {
                data = results.getDate(column);
                break;
            }
            case 92: {
                data = results.getTime(column);
                break;
            }
            case 93: {
                data = results.getTimestamp(column);
                break;
            }
            case -7: {
                boolean b = results.getBoolean(column);
                data = results.wasNull() ? null : (b ? Boolean.TRUE : Boolean.FALSE);
                break;
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                int i = results.getInt(column);
                data = results.wasNull() ? null : IntegerUtils.getInteger((int)i);
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 1111: {
                data = results.getObject(column);
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                if (digits == 0) {
                    long l = results.getLong(column);
                    data = results.wasNull() ? null : new Long(l);
                    break;
                }
                double d = results.getDouble(column);
                data = results.wasNull() ? null : new Double(d);
                break;
            }
            case 6: {
                float f = results.getFloat(column);
                data = results.wasNull() ? null : new Float(f);
                break;
            }
            default: {
                data = results.getString(column);
            }
        }
        return data;
    }

    private class DataTask
    implements Task {
        private boolean _running;
        private ResultSet _results;
        private PreparedStatement _statement;

        public DataTask(ResultSet results, PreparedStatement statement) {
            this._results = results;
            this._statement = statement;
        }

        public void runTask(TaskEvent evt) {
            this._running = true;
            try {
                int oldCount = JDBCModel.this.getRowCount();
                if (oldCount != 0) {
                    JDBCModel.this._data.removeRows(0, oldCount);
                }
                ResultSetMetaData metaData = this._results.getMetaData();
                int columnCount = metaData.getColumnCount();
                int index = 0;
                Object data = null;
                while (this._running && this._results.next()) {
                    JDBCModel.this._data.addRows(index, 1);
                    for (int i = 0; i < columnCount; ++i) {
                        data = JDBCModel.this._getColumnData(this._results, i + 1);
                        JDBCModel.this._setData(i, index, data);
                    }
                    ++index;
                }
                this._statement.close();
            }
            catch (SQLException e) {
                System.err.println(e);
            }
        }

        public void cancel() {
            this._running = false;
        }
    }
}

