/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.laf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.UIDefaults;
import oracle.bali.dbUI.laf.DisabledBGPainter;
import oracle.bali.dbUI.laf.FocusPainter;
import oracle.bali.dbUI.laf.RaisedBorderPainter;
import oracle.bali.ewt.grid.CheckPainter;
import oracle.bali.ewt.painter.AbstractWrappingPainter;
import oracle.bali.ewt.painter.BorderPainter;
import oracle.bali.ewt.painter.ColorChange;
import oracle.bali.ewt.painter.FilledRectPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.painter.PainterStacker;
import oracle.bali.ewt.util.MenuUtils;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.share.thread.Task;
import oracle.bali.share.thread.TaskEvent;
import oracle.bali.share.thread.TaskScheduler;

public class DBUILookAndFeel {
    public static final String RESOURCE_BUNDLE = "oracle.bali.dbUI.resource.DBUIBundle";
    private static DBUILookAndFeel _sLookAndFeel;
    private static TaskScheduler _sScheduler;
    private static Painter _sPainter;
    private static Painter _sDisabledBackgroundPainter;

    public static DBUILookAndFeel getLookAndFeel() {
        if (_sLookAndFeel == null) {
            _sLookAndFeel = new DBUILookAndFeel();
        }
        return _sLookAndFeel;
    }

    public static TaskScheduler getTaskScheduler() {
        if (_sScheduler == null) {
            _sScheduler = new TaskScheduler();
        }
        return _sScheduler;
    }

    public void popupMenu(Component comp, JPopupMenu menu, int x, int y) {
        Menu task = new Menu(comp, menu, x, y);
        DBUILookAndFeel.getTaskScheduler().schedule((Task)task, 0);
    }

    public BorderPainter getFocusPainter(JComponent component) {
        return FocusPainter.getPainter();
    }

    public BorderPainter getRaisedBorderPainter(JComponent component) {
        return RaisedBorderPainter.getPainter();
    }

    public Painter getCheckPainter(JComponent component) {
        if (_sPainter == null) {
            _sPainter = new PainterStacker((Painter)new PainterStacker((Painter)new Fill(FilledRectPainter.getPainter()), CheckPainter.getPainter()), (Painter)new Wrap(CheckPainter.getPainter()));
        }
        return _sPainter;
    }

    public static Image createFilteredImage(Image baseImage, ImageFilter imageFilter) {
        FilteredImageSource prod = new FilteredImageSource(baseImage.getSource(), imageFilter);
        return Toolkit.getDefaultToolkit().createImage(prod);
    }

    public Painter getBackgroundPainter(JComponent component) {
        if (_sDisabledBackgroundPainter == null) {
            _sDisabledBackgroundPainter = new DisabledBGPainter(FilledRectPainter.getPainter());
        }
        return _sDisabledBackgroundPainter;
    }

    public void setCursor(Component component, boolean wait) {
        Cursor c = wait ? Cursor.getPredefinedCursor(3) : Cursor.getDefaultCursor();
        Window parent = WindowUtils.getWindow((Component)component);
        if (parent != null) {
            this._setCursor(c, parent);
        }
    }

    private void _setCursor(Cursor cursor, Component c) {
        c.setCursor(cursor);
        if (c instanceof Container) {
            Component[] clist = ((Container)c).getComponents();
            for (int i = 0; i < clist.length; ++i) {
                this._setCursor(cursor, clist[i]);
            }
        }
    }

    private DBUILookAndFeel() {
    }

    class Menu
    implements Task {
        private Component _component;
        private JPopupMenu _menu;
        private int _x;
        private int _y;

        public Menu(Component c, JPopupMenu menu, int x, int y) {
            this._component = c;
            this._menu = menu;
            this._x = x;
            this._y = y;
        }

        public void runTask(TaskEvent e) {
            MenuUtils.showPopupMenu((JPopupMenu)this._menu, (Component)this._component, (int)this._x, (int)this._y);
        }
    }

    class Fill
    extends ColorChange {
        public Fill(Painter painter) {
            super(painter);
        }

        protected Color getColor(PaintContext context) {
            UIDefaults defaults = context.getPaintUIDefaults();
            return defaults.getColor("control");
        }
    }

    class Wrap
    extends AbstractWrappingPainter {
        public Wrap(Painter painter) {
            super(painter);
        }

        public boolean isTransparent(PaintContext context) {
            return true;
        }
    }
}

