/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.header;

import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDesktopPane;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.MouseInputAdapter;
import oracle.bali.dbUI.constraint.Constrainable;
import oracle.bali.dbUI.constraint.DCBetweenExpression;
import oracle.bali.dbUI.constraint.DCBinaryExpression;
import oracle.bali.dbUI.constraint.DCBooleanExpression;
import oracle.bali.dbUI.constraint.DCNaryExpression;
import oracle.bali.dbUI.constraint.DCVariable;
import oracle.bali.dbUI.constraint.DataConstraint;
import oracle.bali.dbUI.constraintComponent.ConstraintCompFactory;
import oracle.bali.dbUI.constraintComponent.ConstraintComponent;
import oracle.bali.dbUI.db.DataDescriptor;
import oracle.bali.dbUI.db.DataDescriptorProvider;
import oracle.bali.dbUI.header.CBHeaderItemPainter;
import oracle.bali.dbUI.header.CBWindow;
import oracle.bali.dbUI.laf.DBUILookAndFeel;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.header.HeaderItemInputHandler;
import oracle.bali.ewt.header.HeaderKeyHandler;
import oracle.bali.ewt.header.StandardHeaderKeyHandler;
import oracle.bali.ewt.model.OneDModelEvent;
import oracle.bali.ewt.model.OneDModelListener;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.share.thread.Task;
import oracle.bali.share.thread.TaskEvent;

public class CBHeaderInputHandler
implements HeaderItemInputHandler {
    private static final String _COMMAND_ACTIVATE = "ACTIVATE";
    private static final String _COMMAND_FILTER = "FILTER";
    private static final String _KEY_MENU = "HEADER.MENU_STRING";
    private static final String _ACTIVE_KEY = "ACTIVE";
    private OK _okListener;
    private Cancl _cancelListener;
    private boolean _armed;
    int _item;
    int _menuItem;
    Header _header;
    private OneDModelListener _dsListener;
    private MouseMotionAdapter _mListener;
    boolean[] _active;
    CBWindow _window;
    DataConstraint[] _dataConstraints;
    DataConstraint _total;
    private PropertyChangeSupport _propertySupport;
    private Constrainable _constrainable;
    private ConstraintCompFactory _componentFactory;
    private DataDescriptorProvider _descriptProvider;
    private Task _runner;
    private GlassPane _glassPane;

    public CBHeaderInputHandler() {
        this(null, null, null, null);
    }

    public CBHeaderInputHandler(Header header, Constrainable constrainable, ConstraintCompFactory componentFactory, DataDescriptorProvider descriptProvider) {
        this._constrainable = constrainable;
        this._componentFactory = componentFactory;
        this._descriptProvider = descriptProvider;
        this.setHeader(header);
        this._okListener = new OK();
        this._cancelListener = new Cancl();
        this._window = new CBWindow(this._okListener, this._cancelListener);
        this._runner = new Run();
    }

    public Constrainable getConstrainable() {
        return this._constrainable;
    }

    public void setConstrainable(Constrainable constrainable) {
        this._constrainable = constrainable;
    }

    public ConstraintCompFactory getComponentFactory() {
        if (this._componentFactory == null) {
            this._componentFactory = ConstraintCompFactory.getConstraintCompFactory();
        }
        return this._componentFactory;
    }

    public void setComponentFactory(ConstraintCompFactory factory) {
        this._componentFactory = factory;
    }

    public DataDescriptorProvider getDescriptorProvider() {
        return this._descriptProvider;
    }

    public void setDescriptorProvider(DataDescriptorProvider descriptProvider) {
        this._descriptProvider = descriptProvider;
    }

    public void setHeader(Header header) {
        if (this.getHeader() == header) {
            return;
        }
        Header oldHeader = this.getHeader();
        if (oldHeader != null) {
            oldHeader.getModel().removeModelListener(this._dsListener);
            oldHeader.removeMouseMotionListener((MouseMotionListener)this._mListener);
            oldHeader.setHeaderKeyHandler(null);
        }
        this._removeGlassPane();
        this._active = null;
        this._dataConstraints = null;
        this._item = -1;
        this._armed = false;
        this._header = header;
        if (this._header == null) {
            return;
        }
        int items = this._header.getItemCount();
        this._active = new boolean[items];
        this._dataConstraints = new DataConstraint[items];
        if (this._dsListener == null) {
            this._dsListener = new DSListen();
        }
        if (this._mListener == null) {
            this._mListener = new MListen();
        }
        this._header.getModel().addModelListener(this._dsListener);
        this._header.addMouseMotionListener((MouseMotionListener)this._mListener);
        this._header.setHeaderKeyHandler(this.createHeaderKeyHandler());
    }

    public Header getHeader() {
        return this._header;
    }

    public void setDataConstraint(DataConstraint constraint) {
        int count = this._active.length;
        this._total = null;
        for (int i = 0; i < count; ++i) {
            this._active[i] = false;
            this._dataConstraints[i] = null;
        }
        if (constraint != null) {
            if (this.getDescriptorProvider() == null) {
                throw new IllegalStateException();
            }
            this._parseConstraint(constraint);
            this.setDataConstraint(false);
        } else {
            Constrainable c = this.getConstrainable();
            if (c != null) {
                c.setDataConstraint(null);
            }
        }
        this._updateUI();
    }

    public DataConstraint getDataConstraint() {
        return this._total;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (this._propertySupport == null) {
            this._propertySupport = new PropertyChangeSupport(this);
        }
        this._propertySupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (this._propertySupport != null) {
            this._propertySupport.removePropertyChangeListener(l);
        }
    }

    public void mouseClicked(MouseEvent e, Header header, int itemIndex) {
    }

    public void mouseMoved(MouseEvent e, Header header, int itemIndex) {
        Painter painter;
        if (!this._checkHeader(header)) {
            throw new IllegalArgumentException("Header " + header + " has not been set on this input handler.");
        }
        if (this._item == -1 && (painter = header.getPainter(itemIndex)) instanceof CBHeaderItemPainter) {
            CBHeaderItemPainter p = (CBHeaderItemPainter)painter;
            boolean rollOver = p.pointInActiveArea(header.getItemSize(itemIndex), header.getSize().height, e.getX(), e.getY());
            if (p.isRollover() != rollOver) {
                p.setRollover(rollOver);
                header.paintItem(itemIndex);
            }
            e.consume();
        }
    }

    public void mousePressed(MouseEvent e, Header header, int itemIndex) {
        CBHeaderItemPainter p;
        Painter painter;
        if (!this._checkHeader(header)) {
            throw new IllegalArgumentException("Header " + header + " has not been set on this input handler.");
        }
        boolean consumed = false;
        if (e.isMetaDown() || e.isPopupTrigger()) {
            consumed = this._showPopupMenu(e.getX(), e.getY(), itemIndex);
        }
        if ((painter = header.getPainter(itemIndex)) instanceof CBHeaderItemPainter && (p = (CBHeaderItemPainter)painter).pointInActiveArea(header.getItemSize(itemIndex), header.getSize().height, e.getX(), e.getY())) {
            p.setRollover(false);
            if (!consumed) {
                consumed = true;
                this._item = itemIndex;
                this._armed = true;
                p.setActiveAreaArmed(true);
                header.paintItem(this._item);
            }
        }
        if (consumed) {
            e.consume();
        }
    }

    public void mouseDragged(MouseEvent e, Header header, int itemIndex) {
        if (!this._checkHeader(header)) {
            throw new IllegalArgumentException("Header " + header + " has not been set on this input handler.");
        }
        this._checkArmed(e, itemIndex);
    }

    public void mouseReleased(MouseEvent e, Header header, int itemIndex) {
        if (!this._checkHeader(header)) {
            throw new IllegalArgumentException("Header " + header + " has not been set on this input handler.");
        }
        if (this._item == itemIndex && this._armed) {
            Painter painter;
            if (this._showWindow(itemIndex)) {
                e.consume();
            }
            if ((painter = header.getPainter(itemIndex)) instanceof CBHeaderItemPainter) {
                CBHeaderItemPainter p = (CBHeaderItemPainter)painter;
                p.setRollover(false);
                p.setActiveAreaArmed(!p.isActive());
                header.paintItem(itemIndex);
            }
        } else if (this._item != -1) {
            Painter painter = header.getPainter(this._item);
            if (painter instanceof CBHeaderItemPainter) {
                CBHeaderItemPainter p = (CBHeaderItemPainter)painter;
                p.setActiveAreaArmed(false);
                p.setRollover(false);
                header.paintItem(this._item);
            }
            this._item = -1;
        }
        this._armed = false;
    }

    public void mouseEntered(MouseEvent e, Header header, int itemIndex) {
        if (!this._checkHeader(header)) {
            throw new IllegalArgumentException("Header " + header + " has not been set on this input handler.");
        }
        this._checkArmed(e, itemIndex);
    }

    public void mouseExited(MouseEvent e, Header header, int itemIndex) {
        CBHeaderItemPainter p;
        if (!this._checkHeader(header)) {
            throw new IllegalArgumentException("Header " + header + " has not been set on this input handler.");
        }
        this._checkArmed(e, itemIndex);
        Painter painter = header.getPainter(itemIndex);
        if (painter instanceof CBHeaderItemPainter && (p = (CBHeaderItemPainter)painter).isRollover()) {
            p.setRollover(false);
            header.paintItem(itemIndex);
        }
    }

    JDesktopPane _getDesktop(Component comp) {
        for (Component parent = comp; parent != null; parent = parent.getParent()) {
            if (!(parent instanceof JDesktopPane)) continue;
            return (JDesktopPane)parent;
        }
        return null;
    }

    void _addToArrays(int start, int number) {
        boolean[] src = this._active;
        int length = 0;
        if (src != null) {
            length = src.length;
        }
        boolean[] dst = new boolean[length + number];
        if (start != 0) {
            System.arraycopy(src, 0, dst, 0, start);
        }
        if (start != length) {
            System.arraycopy(src, start, dst, start + number, length - start);
        }
        this._active = dst;
        DataConstraint[] fsrc = this._dataConstraints;
        length = 0;
        if (fsrc != null) {
            length = fsrc.length;
        }
        DataConstraint[] fdst = new DataConstraint[length + number];
        if (start != 0) {
            System.arraycopy(fsrc, 0, dst, 0, start);
        }
        if (start != length) {
            System.arraycopy(fsrc, start, fdst, start + number, length - start);
        }
        this._dataConstraints = fdst;
    }

    void _removeFromArrays(int start, int number) {
        boolean[] src = this._active;
        int length = 0;
        if (src != null) {
            length = src.length;
        }
        boolean[] dst = new boolean[length - number];
        if (start != 0) {
            System.arraycopy(src, 0, dst, 0, start);
        }
        if (length - number != start) {
            System.arraycopy(src, start + number, dst, start, length - (start + number));
        }
        this._active = dst;
        DataConstraint[] fsrc = this._dataConstraints;
        length = 0;
        if (fsrc != null) {
            length = fsrc.length;
        }
        DataConstraint[] fdst = new DataConstraint[length - number];
        if (start != 0) {
            System.arraycopy(fsrc, 0, fdst, 0, start);
        }
        if (length - number != start) {
            System.arraycopy(fsrc, start + number, fdst, start, length - (start + number));
        }
        for (int i = start; i < start + number; ++i) {
            this._dataConstraints[i] = null;
        }
        this._dataConstraints = fdst;
    }

    void setDataConstraint(boolean sendEvent) {
        this._total = null;
        int count = this._active.length;
        Vector<DataConstraint> all = new Vector<DataConstraint>();
        for (int i = 0; i < count; ++i) {
            DataConstraint current = this._dataConstraints[i];
            if (!this._active[i] || current == null) continue;
            all.addElement(current);
        }
        count = all.size();
        if (count != 0) {
            Object[] dc = new DataConstraint[count];
            all.copyInto(dc);
            this._total = count == 1 ? dc[0] : new DCBooleanExpression((DataConstraint[])dc, 1);
        }
        Constrainable c = this.getConstrainable();
        c.setDataConstraint(this._total);
        if (sendEvent) {
            this._firePropertyChange();
        }
    }

    void requestFocusToTable() {
        if (this._header != null) {
            this._header.requestFocus();
        }
    }

    JPopupMenu createPopupMenu(int item) {
        JPopupMenu menu = new JPopupMenu();
        MenuListen listener = new MenuListen();
        Header header = this.getHeader();
        Locale locale = header.getLocale();
        ResourceBundle b = ResourceBundle.getBundle("oracle.bali.dbUI.resource.DBUIBundle", locale);
        DataDescriptorProvider provider = this.getDescriptorProvider();
        if (provider != null) {
            DataDescriptor descriptor = provider.getDescriptor(item);
            String text = b.getString(_KEY_MENU);
            MessageFormat form = new MessageFormat(text);
            Object[] args = new Object[]{descriptor.getDisplayName(locale)};
            String menuName = form.format(args);
            JMenuItem filterItem = new JMenuItem(menuName);
            filterItem.setActionCommand(_COMMAND_FILTER);
            filterItem.addActionListener(listener);
            menu.add(filterItem);
        }
        if (this._dataConstraints[item] != null) {
            boolean active = this._active[item];
            JCheckBoxMenuItem checkItem = new JCheckBoxMenuItem(b.getString(_ACTIVE_KEY));
            checkItem.setState(active);
            checkItem.setActionCommand(_COMMAND_ACTIVATE);
            checkItem.addActionListener(listener);
            menu.add(checkItem);
        }
        return menu;
    }

    private void _firePropertyChange() {
        if (this._propertySupport != null) {
            this._propertySupport.firePropertyChange("dataConstraint", null, this.getDataConstraint());
        }
    }

    private void _updateUI() {
        Header header = this.getHeader();
        if (header == null) {
            return;
        }
        int count = this._active.length;
        for (int i = 0; i < count; ++i) {
            Painter painter = header.getPainter(i);
            if (!(painter instanceof CBHeaderItemPainter)) continue;
            CBHeaderItemPainter p = (CBHeaderItemPainter)painter;
            p.setActive(this._active[i]);
        }
        header.repaint();
    }

    private boolean _showWindow(int item) {
        DataConstraint constraint;
        ConstraintCompFactory factory = this.getComponentFactory();
        DataDescriptorProvider provider = this.getDescriptorProvider();
        Constrainable constrainable = this.getConstrainable();
        if (provider == null || constrainable == null) {
            return true;
        }
        int count = provider.getDescriptorCount();
        if (item >= count) {
            return true;
        }
        DataDescriptor descriptor = provider.getDescriptor(item);
        ConstraintComponent fc = factory.createConstraintComponent(null, descriptor, constraint = this._dataConstraints[item]);
        if (fc == null) {
            return true;
        }
        Header header = this.getHeader();
        JDesktopPane desktop = this._getDesktop((Component)header);
        if (desktop == null) {
            throw new IllegalStateException("The header must have a JDesktopPane as an ancestor.  Try using the javax.swing.JDesktopPane component.");
        }
        if (this._window != null) {
            this._window.setConstraintComponent(null);
        }
        this._window = null;
        this._window = new CBWindow(this._okListener, this._cancelListener);
        boolean active = constraint == null ? true : this._active[item];
        Locale locale = header.getLocale();
        this._window.setWindowTitle(descriptor.getDisplayName(locale));
        this._window.setConstraintActive(active);
        this._window.setLocale(locale);
        this._window.setConstraintComponent(fc);
        this._item = item;
        this._armed = true;
        Point p = header.getLocationOnScreen();
        Point origin = header.getCanvasOrigin();
        p.x -= origin.x;
        p.y -= origin.y;
        int itemPos = header.getItemPosition(this._item);
        p.x = Math.max(p.x, p.x + (itemPos += origin.x));
        p.y += header.getSize().height;
        Point dp = desktop.getLocationOnScreen();
        p.x -= dp.x;
        p.y -= dp.y;
        this._window.setVisible(false);
        this._glassPane = new GlassPane();
        this._glassPane.add(this._window);
        desktop.add(this._glassPane);
        desktop.addComponentListener(this._glassPane);
        desktop.moveToFront(this._glassPane);
        this._glassPane.setBounds(0, 0, desktop.getWidth(), desktop.getHeight());
        this._window.pack();
        if (p.x + this._window.getWidth() > desktop.getWidth()) {
            p.x = Math.max(0, desktop.getWidth() - this._window.getWidth());
        }
        this._window.setLocation(p.x, p.y);
        DBUILookAndFeel.getTaskScheduler().schedule(this._runner, 0);
        return true;
    }

    private boolean _showPopupMenu(int x, int y, int item) {
        JPopupMenu menu = this.createPopupMenu(item);
        if (menu != null && menu.getComponentCount() != 0) {
            Header header = this.getHeader();
            DBUILookAndFeel.getLookAndFeel().popupMenu((Component)header, menu, x += header.getItemPosition(item), y);
            this._menuItem = item;
            return true;
        }
        return false;
    }

    private void _checkArmed(MouseEvent e, int itemIndex) {
        CBHeaderItemPainter p;
        boolean armed;
        Header header;
        Painter painter;
        if (this._item == itemIndex && (painter = (header = this.getHeader()).getPainter(itemIndex)) instanceof CBHeaderItemPainter && (armed = (p = (CBHeaderItemPainter)painter).pointInActiveArea(header.getItemSize(itemIndex), header.getSize().height, e.getX(), e.getY())) != this._armed) {
            e.consume();
            this._armed = armed;
            p.setActiveAreaArmed(this._armed);
            header.paintItem(itemIndex);
        }
    }

    private boolean _checkHeader(Header h) {
        boolean valid = true;
        Header current = this.getHeader();
        if (current == null) {
            this.setHeader(h);
        } else if (h != current) {
            valid = false;
        }
        return valid;
    }

    private void _parseConstraint(DataConstraint d) {
        if (d instanceof DCNaryExpression) {
            DCNaryExpression n = (DCNaryExpression)d;
            for (int i = 0; i < n.getConstraintCount(); ++i) {
                this._parseConstraint(n.getConstraint(i));
            }
        } else if (d instanceof DCBinaryExpression) {
            DCBinaryExpression bin = (DCBinaryExpression)d;
            DataConstraint left = bin.getConstraint(0);
            DataConstraint right = bin.getConstraint(1);
            if (left instanceof DCVariable) {
                this._setItemConstraint((DCVariable)left, bin);
            } else if (right instanceof DCVariable) {
                this._setItemConstraint((DCVariable)right, bin);
            } else {
                this._parseConstraint(left);
                this._parseConstraint(right);
            }
        } else if (d instanceof DCBetweenExpression) {
            DCBetweenExpression bet = (DCBetweenExpression)d;
            DataConstraint temp = bet.getFirstConstraint();
            if (temp instanceof DCVariable) {
                this._setItemConstraint((DCVariable)temp, bet);
            } else {
                temp = bet.getSecondConstraint();
                if (temp instanceof DCVariable) {
                    this._setItemConstraint((DCVariable)temp, bet);
                } else {
                    temp = bet.getCheckConstraint();
                    if (temp instanceof DCVariable) {
                        this._setItemConstraint((DCVariable)temp, bet);
                    }
                }
            }
        }
    }

    private void _setItemConstraint(DCVariable variable, DataConstraint d) {
        Object o = variable.getVariable();
        String s = o instanceof DataDescriptor ? ((DataDescriptor)o).getName() : null;
        DataDescriptorProvider p = this.getDescriptorProvider();
        int index = -1;
        for (int i = 0; i < p.getDescriptorCount(); ++i) {
            DataDescriptor tempDD = p.getDescriptor(i);
            if (!tempDD.equals(o) && !tempDD.getName().equals(s)) continue;
            index = i;
            break;
        }
        if (index != -1) {
            this._dataConstraints[index] = d;
            this._active[index] = true;
        }
    }

    private void _removeGlassPane() {
        if (this._glassPane != null) {
            JDesktopPane parent;
            if (this._window != null) {
                this._glassPane.remove(this._window);
            }
            if ((parent = this._getDesktop((Component)this.getHeader())) != null) {
                parent.remove(this._glassPane);
                parent.removeComponentListener(this._glassPane);
                parent.repaint();
            }
            this._glassPane = null;
        }
    }

    HeaderKeyHandler createHeaderKeyHandler() {
        return new MenuKeyHandler();
    }

    private class GlassPane
    extends JPanel
    implements ComponentListener {
        public GlassPane() {
            this.setOpaque(false);
            this.setLayout(null);
            MouseInputAdapter listener = new MouseInputAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    Toolkit.getDefaultToolkit().beep();
                }
            };
            this.addMouseListener(listener);
            this.addMouseMotionListener(listener);
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            Component c = (Component)e.getSource();
            this.setBounds(0, 0, c.getWidth(), c.getHeight());
        }
    }

    class MenuKeyHandler
    extends StandardHeaderKeyHandler {
        MenuKeyHandler() {
        }

        public void handleKeyEvent(Header header, KeyEvent e) {
            if (!e.isConsumed() && e.getKeyCode() == 121 && e.getModifiers() == 1 && e.getID() == 401) {
                int focusItem = header.getFocusItem();
                if (focusItem != -1) {
                    CBHeaderInputHandler.this._showPopupMenu(header.getItemSize(focusItem) / 2, header.getSize().height / 3, focusItem);
                }
                e.consume();
            }
            super.handleKeyEvent(header, e);
        }
    }

    private class MenuListen
    implements ActionListener {
        private MenuListen() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if (CBHeaderInputHandler._COMMAND_ACTIVATE.equals(cmd)) {
                boolean active;
                CBHeaderInputHandler.this._active[CBHeaderInputHandler.this._menuItem] = active = !CBHeaderInputHandler.this._active[CBHeaderInputHandler.this._menuItem];
                Painter painter = CBHeaderInputHandler.this._header.getPainter(CBHeaderInputHandler.this._menuItem);
                if (painter instanceof CBHeaderItemPainter) {
                    ((CBHeaderItemPainter)painter).setActive(active);
                    CBHeaderInputHandler.this._header.paintItem(CBHeaderInputHandler.this._menuItem);
                }
                CBHeaderInputHandler.this.setDataConstraint(true);
            } else if (CBHeaderInputHandler._COMMAND_FILTER.equals(cmd)) {
                CBHeaderInputHandler.this._showWindow(CBHeaderInputHandler.this._menuItem);
            }
        }
    }

    private class Run
    implements Task {
        private Run() {
        }

        public void runTask(TaskEvent e) {
            CBHeaderInputHandler.this._window.pack();
            CBHeaderInputHandler.this._window.setVisible(true);
            CBHeaderInputHandler.this._window.repaint();
            CBHeaderInputHandler.this._window.requestFocus();
        }
    }

    private class Cancl
    implements ActionListener {
        private Cancl() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                CBHeaderInputHandler.this._window.setClosed(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            Painter painter = CBHeaderInputHandler.this._header.getPainter(CBHeaderInputHandler.this._item);
            if (painter instanceof CBHeaderItemPainter) {
                CBHeaderItemPainter p = (CBHeaderItemPainter)painter;
                p.setActiveAreaArmed(false);
                CBHeaderInputHandler.this._header.paintItem(CBHeaderInputHandler.this._item);
            }
            CBHeaderInputHandler.this._removeGlassPane();
            CBHeaderInputHandler.this._item = -1;
            CBHeaderInputHandler.this.requestFocusToTable();
        }
    }

    private class OK
    implements ActionListener {
        private OK() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean active;
            try {
                CBHeaderInputHandler.this._window.setClosed(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            DataConstraint constraint = CBHeaderInputHandler.this._window.getDataConstraint();
            CBHeaderInputHandler.this._active[CBHeaderInputHandler.this._item] = active = constraint == null ? false : CBHeaderInputHandler.this._window.isConstraintActive();
            CBHeaderInputHandler.this._dataConstraints[CBHeaderInputHandler.this._item] = constraint;
            Painter painter = CBHeaderInputHandler.this._header.getPainter(CBHeaderInputHandler.this._item);
            if (painter instanceof CBHeaderItemPainter) {
                CBHeaderItemPainter p = (CBHeaderItemPainter)painter;
                p.setActive(active);
                p.setActiveAreaArmed(false);
                CBHeaderInputHandler.this._header.paintItem(CBHeaderInputHandler.this._item);
            }
            CBHeaderInputHandler.this._removeGlassPane();
            CBHeaderInputHandler.this.setDataConstraint(true);
            CBHeaderInputHandler.this._item = -1;
            CBHeaderInputHandler.this.requestFocusToTable();
        }
    }

    private class DSListen
    implements OneDModelListener {
        private DSListen() {
        }

        public void itemsAdded(OneDModelEvent e) {
            CBHeaderInputHandler.this._addToArrays(e.getStartIndex(), e.getItemCount());
        }

        public void itemsRemoved(OneDModelEvent e) {
            CBHeaderInputHandler.this._removeFromArrays(e.getStartIndex(), e.getItemCount());
        }

        public void invalidateItems(OneDModelEvent e) {
        }
    }

    private class MListen
    extends MouseMotionAdapter {
        private MListen() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (CBHeaderInputHandler.this._item != -1) {
                int diff;
                Point p = CBHeaderInputHandler.this._header.convertOuterToCanvas(e.getX(), e.getY());
                boolean horizontal = CBHeaderInputHandler.this._header.getOrientation() == 0;
                Point origin = CBHeaderInputHandler.this._header.getCanvasOrigin();
                int pos = CBHeaderInputHandler.this._header.getItemPosition(CBHeaderInputHandler.this._item);
                if (horizontal) {
                    diff = -origin.x - pos;
                    e.translatePoint(diff, 0);
                } else {
                    diff = -origin.y - pos;
                    e.translatePoint(0, diff);
                }
                CBHeaderInputHandler.this.mouseDragged(e, CBHeaderInputHandler.this._header, CBHeaderInputHandler.this._item);
                if (horizontal) {
                    e.translatePoint(-diff, 0);
                } else {
                    e.translatePoint(0, -diff);
                }
                e.consume();
            }
        }
    }
}

