/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.graph.jle;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.UIDefaults;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.ewt.painter.AbstractBorderPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.util.ImmInsets;

class TitleBarButtonPainter
extends AbstractBorderPainter {
    private static final ImmInsets _THIN_INSETS = new ImmInsets(2, 2, 2, 2);
    private static final ImmInsets _THIN_ARMED_INSETS = new ImmInsets(3, 2, 1, 2);

    public TitleBarButtonPainter(Painter wrappedPainter) {
        super(wrappedPainter);
    }

    protected ImmInsets getOwnInsets(PaintContext context) {
        boolean isArmed = (context.getPaintState() & 2) != 0;
        return isArmed ? _THIN_ARMED_INSETS : _THIN_INSETS;
    }

    protected void paintBorder(PaintContext context, Graphics g, int x, int y, int width, int height) {
        Color gray;
        Color darkToLight;
        Color normalToLight;
        Color lightToGrayOrLight;
        Color lightToDark;
        Color upperLeftCorner;
        boolean isSet;
        int state = context.getPaintState();
        UIDefaults defaults = context.getPaintUIDefaults();
        Color savedColor = g.getColor();
        int bottom = y + height - 1;
        int right = x + width - 1;
        Color inactiveColor = defaults.getColor("controlShadowDark");
        boolean isDisabled = (state & 1) != 0;
        boolean isInactive = (state & 4) != 0;
        boolean isArmed = (state & 2) != 0;
        boolean bl = isSet = (state & 8) != 0;
        if ((state & 0x80) != 0 && !isInactive) {
            g.setColor(isInactive ? inactiveColor : Color.black);
            int armedY = isArmed ? y + 1 : bottom - 1;
            int lineStartX = x + 1;
            int lineEndX = right - 1;
            g.drawLine(x, y + 1, x, bottom - 1);
            g.drawLine(x + 1, armedY, x + 1, armedY);
            g.drawLine(right, y + 1, right, bottom - 1);
            g.drawLine(right - 1, armedY, right - 1, armedY);
            g.drawLine(lineStartX, y, lineEndX, y);
            g.drawLine(lineStartX, bottom, lineEndX, bottom);
        }
        ++x;
        ++y;
        --bottom;
        --right;
        Color background = context.getPaintBackground();
        if (isInactive) {
            upperLeftCorner = inactiveColor;
            lightToDark = inactiveColor;
            Color lightToGray = inactiveColor;
            lightToGrayOrLight = inactiveColor;
            Color grayToLight = inactiveColor;
            normalToLight = inactiveColor;
            darkToLight = inactiveColor;
            gray = inactiveColor;
        } else {
            Color light;
            upperLeftCorner = light = Color.white;
            gray = defaults.getColor(LookAndFeel.NORMAL_INTENSITY);
            lightToDark = light;
            lightToGrayOrLight = light;
            Color lightToGray = light;
            Color grayToLight = gray;
            normalToLight = defaults.getColor(LookAndFeel.CONTROL_SHADOW);
            Color dark = defaults.getColor(LookAndFeel.CONTROL_DK_SHADOW);
            darkToLight = isDisabled ? gray : dark;
            if (isArmed || isSet) {
                if (!isDisabled && isArmed) {
                    background = gray;
                }
                upperLeftCorner = gray;
                lightToGrayOrLight = defaults.getColor("controlShadowVeryLight");
                lightToGray = gray;
                grayToLight = light;
                normalToLight = light;
                lightToDark = dark;
                darkToLight = light;
            }
        }
        if (isArmed || isSet) {
            this._drawLeftSide(g, upperLeftCorner, lightToDark, lightToGrayOrLight, normalToLight, gray, background, x, y, bottom);
            this._drawRightSide(g, darkToLight, lightToGrayOrLight, normalToLight, gray, background, right, y, bottom);
            g.setColor(lightToDark);
            g.drawLine(x + 2, y, right - 2, y);
            g.setColor(darkToLight);
            g.drawLine(x + 2, bottom, right - 2, bottom);
        }
        g.setColor(background);
        g.drawLine(x += 2, (y += 2) - 1, right -= 2, y - 1);
        g.drawLine(x, (bottom -= 2) + 1, right, bottom + 1);
        int armedY = isArmed ? y : bottom;
        g.drawLine(x, armedY, right, armedY);
        if (isArmed) {
            g.fillRect(x, y, right - x + 1, bottom - y + 1);
        }
        g.setColor(savedColor);
    }

    public Painter getContentPainterAt(PaintContext context, int availableWidth, int availableHeight, int x, int y, Painter proxyPainter) {
        Object contentPainter = super.getContentPainterAt(context, availableWidth, availableHeight, x, y, proxyPainter);
        if (proxyPainter == this && contentPainter != null || contentPainter == null && x >= 0 && y >= 0 && x < availableWidth && y < availableHeight) {
            contentPainter = this;
        }
        return contentPainter;
    }

    protected boolean isBorderTransparent(PaintContext context) {
        return true;
    }

    public int getRepaintFlags(PaintContext context) {
        int flags = super.getRepaintFlags(context) | 1 | 4 | 2 | 0x40 | 0x400 | 0x80;
        return flags;
    }

    private void _drawLeftSide(Graphics g, Color upperLeftCorner, Color lightToDark, Color lightToGray, Color grayToLight, Color gray, Color background, int x, int y, int bottom) {
        g.setColor(upperLeftCorner);
        g.drawLine(x + 1, y + 1, x + 1, y + 1);
        g.setColor(lightToDark);
        g.drawLine(x + 1, y, x + 1, y);
        g.drawLine(x, y + 1, x, bottom - 2);
        g.setColor(lightToGray);
        g.drawLine(x, bottom - 1, x, bottom - 1);
        g.setColor(gray);
        g.drawLine(x + 1, bottom - 1, x + 1, bottom - 1);
        g.setColor(grayToLight);
        g.drawLine(x + 1, bottom, x + 1, bottom);
        g.setColor(background);
        g.drawLine(x + 1, y + 2, x + 1, bottom - 2);
    }

    private void _drawRightSide(Graphics g, Color darkToLight, Color lightToGray, Color grayToLight, Color gray, Color background, int x, int y, int bottom) {
        g.setColor(darkToLight);
        g.drawLine(x, y + 2, x, bottom - 1);
        g.drawLine(x - 1, bottom, x - 1, bottom);
        g.setColor(grayToLight);
        g.drawLine(x, y + 1, x, y + 1);
        g.drawLine(x - 1, bottom - 1, x - 1, bottom - 1);
        g.setColor(gray);
        g.drawLine(x - 1, y + 1, x - 1, y + 1);
        g.setColor(lightToGray);
        g.drawLine(x - 1, y, x - 1, y);
        g.setColor(background);
        g.drawLine(x - 1, y + 2, x - 1, bottom - 2);
    }
}

