/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.graph.jle;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import oracle.bali.dbUI.graph.Edge;
import oracle.bali.dbUI.graph.EdgeFactory;
import oracle.bali.dbUI.graph.Port;
import oracle.bali.dbUI.graph.jle.EdgeLinkItem;
import oracle.bali.dbUI.graph.jle.GraphCanvas;
import oracle.bali.dbUI.graph.jle.JLENodeWindow;
import oracle.bali.dbUI.graph.jle.PortLinkPort;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.jle.JLECanvas;
import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.event.JLEEvent;
import oracle.bali.jle.geom.Point2D;
import oracle.bali.jle.item.LinkItem;
import oracle.bali.jle.tool.LinkTool;

class NodeLinkTool
extends LinkTool {
    private JLENodeWindow _lastWindow;
    private Port _lastPort;
    private MouseMotionListener _listener;
    private JLENodeWindow _sourceItem;

    protected void processMouseReleased(JLEEvent e) {
        super.processMouseReleased(e);
        if (this._lastWindow != null) {
            this._lastWindow.getNodeComponent().setDropTargetPort(null);
        }
        this.getCanvas().getGlassComponent().setCursor(Cursor.getDefaultCursor());
        this._lastWindow = null;
        this._lastPort = null;
        if (this._sourceItem != null) {
            this._sourceItem.getNodeComponent().getSpreadTable().getGrid().removeMouseMotionListener(this._listener);
        }
        this._sourceItem = null;
    }

    protected boolean fireLinkToolEvent(int id, LinkItem link, LayoutItem sourceItem, Point2D sourcePt, LayoutItem destItem, Point2D destPt) {
        EdgeFactory f;
        boolean ret = super.fireLinkToolEvent(id, link, sourceItem, sourcePt, destItem, destPt);
        if (destItem == null) {
            if (this._lastWindow != null && this._lastPort != null) {
                this.addImmediateRect(this._lastWindow.getItemBounds());
                this._lastWindow.getNodeComponent().setDropTargetPort(null);
            }
            this.getCanvas().getGlassComponent().setCursor(Cursor.getDefaultCursor());
            this._lastWindow = null;
            this._lastPort = null;
        }
        if (id != 3 || !(sourceItem instanceof JLENodeWindow) || !(destItem instanceof JLENodeWindow)) {
            return ret;
        }
        JLENodeWindow dWindow = (JLENodeWindow)destItem;
        JLENodeWindow sWindow = (JLENodeWindow)sourceItem;
        if (id == 3 && this._sourceItem == null) {
            if (this._listener == null) {
                this._listener = new Consumer();
            }
            this._sourceItem = sWindow;
            Grid c = this._sourceItem.getNodeComponent().getSpreadTable().getGrid();
            c.addMouseMotionListener(this._listener);
        }
        if (sourceItem == destItem) {
            return ret;
        }
        Port dPort = dWindow.getPort(destPt.getX(), destPt.getY());
        Port sPort = sWindow.getPort(sourcePt.getX(), sourcePt.getY());
        if ((dWindow != this._lastWindow || dPort != this._lastPort) && this._lastWindow != null && this._lastPort != null) {
            this._lastWindow.getNodeComponent().setDropTargetPort(null);
            this.addImmediateRect(this._lastWindow.getItemBounds());
        }
        this._lastWindow = dWindow;
        this._lastPort = dPort;
        Cursor c = Cursor.getDefaultCursor();
        JLECanvas canvas = this.getCanvas();
        boolean validEdge = false;
        if (canvas instanceof GraphCanvas && (validEdge = (f = ((GraphCanvas)canvas).getEdgeFactory()).isEdgeValid(sPort, dPort))) {
            c = f.getCursor(sPort, dPort);
        }
        canvas.getGlassComponent().setCursor(c);
        if (dWindow != null && dPort != null && validEdge) {
            dWindow.getNodeComponent().setDropTargetPort(dPort);
            this.addImmediateRect(dWindow.getItemBounds());
        } else if (!validEdge && dWindow != null) {
            dWindow.getNodeComponent().autoScroll(dPort);
        }
        return ret;
    }

    protected boolean isValidLinkSource(LayoutItem source, Point2D point) {
        if (!(source instanceof JLENodeWindow)) {
            return false;
        }
        JLENodeWindow window = (JLENodeWindow)source;
        Port port = window.getPort(point.getX(), point.getY());
        return port != null && port.isSourceable();
    }

    protected boolean isValidLinkDestination(LayoutItem dest, Point2D destPt, LayoutItem source, Point2D sourcePt) {
        if (!(source instanceof JLENodeWindow) || !(dest instanceof JLENodeWindow)) {
            return false;
        }
        JLENodeWindow sWindow = (JLENodeWindow)source;
        JLENodeWindow dWindow = (JLENodeWindow)dest;
        Port sPort = sWindow.getPort(sourcePt.getX(), sourcePt.getY());
        Port dPort = dWindow.getPort(destPt.getX(), destPt.getY());
        JLECanvas canvas = this.getCanvas();
        if (canvas instanceof GraphCanvas) {
            GraphCanvas gc = (GraphCanvas)canvas;
            EdgeFactory f = gc.getEdgeFactory();
            if (!f.isEdgeValid(sPort, dPort)) {
                return false;
            }
            if (gc.doesEdgeExist(sPort, dPort)) {
                return false;
            }
        }
        return dPort != null && dPort.isTargetable();
    }

    public LinkItem processLink(LayoutItem source, LayoutItem dest, Point2D sourcePt, Point2D destPt) {
        if (!(source instanceof JLENodeWindow) || !(dest instanceof JLENodeWindow)) {
            return null;
        }
        JLENodeWindow sWindow = (JLENodeWindow)source;
        JLENodeWindow dWindow = (JLENodeWindow)dest;
        Port sPort = sWindow.getPort(sourcePt.getX(), sourcePt.getY());
        Port dPort = dWindow.getPort(destPt.getX(), destPt.getY());
        GraphCanvas canvas = this.getCanvas() instanceof GraphCanvas ? (GraphCanvas)this.getCanvas() : null;
        Edge edge = null;
        if (canvas != null) {
            EdgeFactory f = canvas.getEdgeFactory();
            edge = f.createEdge(sPort, dPort);
        }
        if (edge == null) {
            return null;
        }
        if (canvas != null && canvas.__fireVetoableChange("edgeCount", null, edge)) {
            return null;
        }
        EdgeLinkItem link = null;
        if (canvas != null) {
            link = canvas.__addEdge(edge, sPort, sWindow, dPort, dWindow);
        } else {
            PortLinkPort sLinkPort = new PortLinkPort(sPort, sWindow, false);
            PortLinkPort dLinkPort = new PortLinkPort(dPort, dWindow, true);
            link = new EdgeLinkItem(sLinkPort, dLinkPort, edge);
            this.getCanvas().getContentItem().addItem((LayoutItem)link, 0);
        }
        return link;
    }

    private class Consumer
    extends MouseMotionAdapter {
        private Consumer() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            e.consume();
        }
    }
}

