/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.graph.jle;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.bali.dbUI.graph.DefaultEdgeFactory;
import oracle.bali.dbUI.graph.Edge;
import oracle.bali.dbUI.graph.EdgeFactory;
import oracle.bali.dbUI.graph.Graph;
import oracle.bali.dbUI.graph.Node;
import oracle.bali.dbUI.graph.NodeComponent;
import oracle.bali.dbUI.graph.Port;
import oracle.bali.dbUI.graph.jle.EdgeLinkItem;
import oracle.bali.dbUI.graph.jle.JLENodeWindow;
import oracle.bali.dbUI.graph.jle.NodeBoundsTool;
import oracle.bali.dbUI.graph.jle.NodeGlassPane;
import oracle.bali.dbUI.graph.jle.NodeTool;
import oracle.bali.dbUI.graph.jle.PortLinkPort;
import oracle.bali.ewt.util.LocaleUtils;
import oracle.bali.ewt.util.MenuUtils;
import oracle.bali.jle.GlassPane;
import oracle.bali.jle.JLECanvas;
import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.LayoutTool;
import oracle.bali.jle.PropertyManager;
import oracle.bali.jle.event.JLEEvent;
import oracle.bali.jle.event.JLEEventAdapter;
import oracle.bali.jle.event.JLEEventListener;
import oracle.bali.jle.geom.Dimension2D;
import oracle.bali.jle.geom.Point2D;
import oracle.bali.jle.geom.Rectangle2D;
import oracle.bali.jle.item.CompContainerFactory;
import oracle.bali.jle.item.DefaultLinkPainter;
import oracle.bali.jle.item.JComponentContainer;
import oracle.bali.jle.item.LinkPainter;
import oracle.bali.jle.item.LinkPort;
import oracle.bali.jle.tool.LinkToolEvent;
import oracle.bali.jle.tool.LinkToolListener;
import oracle.bali.jle.util.ItemUtils;
import oracle.bali.share.event.ListenerManager;
import oracle.bali.share.util.IntegerUtils;

public class GraphCanvas
extends JLECanvas
implements Graph {
    public static final String PROPERTY_NODE_SELECTION_COUNT = "nodeSelectionCount";
    public static final String PROPERTY_EDGE_SELECTION_COUNT = "edgeSelectionCount";
    public static final String PROPERTY_PORT_SELECTION_COUNT = "portSelectionCount";
    public static final String COMMAND_NODE_DOUBLE_CLICK = "GraphCanvas.nodeDoubleClick";
    public static final String COMMAND_NODE_SINGLE_CLICK = "GraphCanvas.nodeSingleClick";
    public static final String COMMAND_PORT_DOUBLE_CLICK = "GraphCanvas.portDoubleClick";
    public static final String COMMAND_PORT_SINGLE_CLICK = "GraphCanvas.portSingleClick";
    private static final String _CREATE_SEPARATOR = ".";
    private static final String _DELETE_SEPARATOR = ": ";
    private static final String _KEY_LINKTO = "GRAPH.LINK_TO";
    private static final String _KEY_DELETELINK = "GRAPH.DELETE_LINK";
    static final String COMMAND_LINK = "LINK";
    static final String COMMAND_DELETE_LINK = "DELETE_LINK";
    private Port _menuPort;
    private Hashtable _sources;
    private Hashtable _targets;
    private Hashtable _links;
    private Listener _listener;
    private LinkPainter _defaultPainter;
    private EdgeFactory _edgeFactory;
    private ListenerManager _actionListeners;
    private boolean _tooltipDisplay = true;
    private Vector _items;
    private boolean _createMode;

    public GraphCanvas() {
        CompContainerFactory.registerCompContainerClass(JComponent.class, JComponentContainer.class);
        NodeTool tool = new NodeTool();
        this._listener = new Listener();
        tool.getLinkTool().addLinkToolListener((LinkToolListener)this._listener);
        this.setTool(tool);
        this.getContentItem().setBackground(Color.white);
        this.addJLEEventListener((JLEEventListener)this._listener);
        this._sources = new Hashtable();
        this._targets = new Hashtable();
        this._links = new Hashtable();
        this._items = new Vector();
    }

    public void setCreateMode(boolean createMode) {
        if (this._createMode != createMode) {
            this._createMode = createMode;
            LayoutItem[] items = this.getContentItem().getItems();
            int count = items == null ? 0 : items.length;
            for (int i = 0; i < count; ++i) {
                LayoutItem item = items[i];
                if (!(item instanceof JLENodeWindow)) continue;
                JLENodeWindow window = (JLENodeWindow)item;
                window.getNodeComponent().setCreateMode(createMode);
                window.__updateSize();
            }
            if (!this._createMode) {
                this.validate();
            }
        }
    }

    public boolean isCreateMode() {
        return this._createMode;
    }

    public void setAutoDisplayToolTips(boolean b) {
        if (this._tooltipDisplay != b) {
            this._tooltipDisplay = b;
            this._updateTooltips();
        }
    }

    public boolean getAutoDisplayToolTips() {
        return this._tooltipDisplay;
    }

    public JLENodeWindow addNode(Node node) {
        JLENodeWindow old = this.getNodeWindow(node);
        if (old != null) {
            return old;
        }
        JLENodeWindow window = this.createNodeWindow();
        PropertyManager pm = window.getPropertyManager();
        pm.addPropertyChangeListener((PropertyChangeListener)this._listener);
        window.getNodeComponent().setCreateMode(this.isCreateMode());
        window.setNode(node);
        this.getContentItem().addItem((LayoutItem)window);
        this._items.addElement(window);
        window.getNodeComponent().setGraph(this);
        window.getNodeComponent().addPropertyChangeListener(this._listener);
        window.getNodeComponent().addActionListener(this._listener);
        return window;
    }

    public void removeNode(Node node) {
        LayoutItem[] items = this.getContentItem().getItems();
        int count = items == null ? 0 : items.length;
        for (int i = 0; i < count; ++i) {
            LayoutItem item = items[i];
            if (item instanceof JLENodeWindow) {
                JLENodeWindow window = (JLENodeWindow)item;
                if (window.getNode() != node) continue;
                window.getNodeComponent().removeActionListener(this._listener);
                window.getNodeComponent().removePropertyChangeListener(this._listener);
                window.getNodeComponent().setGraph(null);
                PropertyManager pm = window.getPropertyManager();
                pm.removePropertyChangeListener((PropertyChangeListener)this._listener);
                this.getContentItem().removeItem((LayoutItem)window);
                this._items.removeElement((Object)window);
                this.repaint();
                continue;
            }
            if (!(item instanceof EdgeLinkItem)) continue;
            EdgeLinkItem edgeItem = (EdgeLinkItem)item;
            Edge e = edgeItem.getEdge();
            int edgeCount = e.getSourcePortCount();
            for (int j = 0; j < edgeCount; ++j) {
                if (!this._isChild(e.getSourcePort(j), node) && !this._isChild(e.getTargetPort(j), node)) continue;
                this.removeEdge(e);
            }
        }
    }

    public void removeAllNodes() {
        Node[] nodes = this.getNodes();
        int count = nodes == null ? 0 : nodes.length;
        for (int i = 0; i < count; ++i) {
            this.removeNode(nodes[i]);
        }
    }

    public final void removeNodeWindow(JLENodeWindow nodeWindow) {
        Node node = nodeWindow.getNode();
        if (node == null && nodeWindow.getCanvas() == this) {
            this.getContentItem().removeItem((LayoutItem)nodeWindow);
            this._items.removeElement((Object)nodeWindow);
        } else {
            this.removeNode(node);
        }
    }

    @Override
    public int getNodeCount() {
        int count = this.getContentItem().getItemCount();
        int nodeCount = 0;
        for (int i = 0; i < count; ++i) {
            LayoutItem item = this.getContentItem().getItem(i);
            if (!(item instanceof JLENodeWindow)) continue;
            ++nodeCount;
        }
        return nodeCount;
    }

    @Override
    public Node getNode(int index) {
        int count = this.getContentItem().getItemCount();
        int nodeCount = 0;
        for (int i = 0; i < count; ++i) {
            JLENodeWindow nw;
            LayoutItem item = this.getContentItem().getItem(i);
            if (!(item instanceof JLENodeWindow) || (nw = (JLENodeWindow)item).getNode() == null) continue;
            if (nodeCount == index) {
                return nw.getNode();
            }
            ++nodeCount;
        }
        return null;
    }

    public Node[] getNodes() {
        int count = this.getContentItem().getItemCount();
        Vector<Node> v = new Vector<Node>();
        for (int i = 0; i < count; ++i) {
            JLENodeWindow nw;
            LayoutItem item = this.getContentItem().getItem(i);
            if (!(item instanceof JLENodeWindow) || (nw = (JLENodeWindow)item).getNode() == null) continue;
            v.addElement(nw.getNode());
        }
        int size = v.size();
        Object[] nodes = null;
        if (size != 0) {
            nodes = new Node[size];
            v.copyInto(nodes);
        }
        return nodes;
    }

    public JLENodeWindow getNodeWindow(Node node) {
        int count = this.getContentItem().getItemCount();
        boolean nodeCount = false;
        for (int i = 0; i < count; ++i) {
            JLENodeWindow nw;
            LayoutItem item = this.getContentItem().getItem(i);
            if (!(item instanceof JLENodeWindow) || (nw = (JLENodeWindow)item).getNode() != node) continue;
            return nw;
        }
        return null;
    }

    public void addEdge(Edge edge) {
        if (edge == null) {
            return;
        }
        if (this._getEdgeLinkItem(edge) != null) {
            return;
        }
        Port sPort = edge.getSourcePort(0);
        Port dPort = edge.getTargetPort(0);
        JLENodeWindow sWindow = this._findWindow(sPort);
        JLENodeWindow dWindow = this._findWindow(dPort);
        if (sWindow == null || dWindow == null) {
            throw new IllegalArgumentException("All Ports in Edge must be added to Graph before calling addEdge");
        }
        EdgeFactory fact = this.getEdgeFactory();
        if (!(sWindow != dWindow && sPort.isSourceable() && dPort.isTargetable() && fact.isEdgeValid(sPort, dPort))) {
            return;
        }
        EdgeLinkItem dummy = this.__addEdge(edge, sPort, sWindow, dPort, dWindow);
    }

    public void removeEdge(Edge edge) {
        EdgeLinkItem edgeItem = this._getEdgeLinkItem(edge);
        if (edgeItem != null) {
            this.getContentItem().removeItem((LayoutItem)edgeItem);
            this._items.removeElement(edgeItem);
            this._links.remove(edge);
            LinkPort[] ports = edgeItem.getPorts();
            for (int j = 0; j < ports.length; ++j) {
                ports[j].die();
            }
            this.getContentItem().repaintItem();
            this.firePropertyChange("edgeCount", edge, null);
        }
    }

    @Override
    public int getEdgeCount() {
        return this._links.size();
    }

    @Override
    public Edge getEdge(int index) {
        int count = this.getContentItem().getItemCount();
        int edgeCount = 0;
        for (int i = 0; i < count; ++i) {
            LayoutItem item = this.getContentItem().getItem(i);
            if (!(item instanceof EdgeLinkItem)) continue;
            EdgeLinkItem edge = (EdgeLinkItem)item;
            if (edgeCount == index) {
                return edge.getEdge();
            }
            ++edgeCount;
        }
        return null;
    }

    public Edge[] getEdges() {
        int count = this.getContentItem().getItemCount();
        Vector<Edge> v = new Vector<Edge>();
        for (int i = 0; i < count; ++i) {
            LayoutItem item = this.getContentItem().getItem(i);
            if (!(item instanceof EdgeLinkItem)) continue;
            EdgeLinkItem edge = (EdgeLinkItem)item;
            v.addElement(edge.getEdge());
        }
        int size = v.size();
        Object[] edges = null;
        if (size != 0) {
            edges = new Edge[size];
            v.copyInto(edges);
        }
        return edges;
    }

    public boolean doesEdgeExist(Port source, Port target) {
        Edge[] edges = this.getEdges();
        int count = edges == null ? 0 : edges.length;
        for (int i = 0; i < count; ++i) {
            Edge e = edges[i];
            if (e.getSourcePortCount() != 1 || e.getSourcePort(0) != source || e.getTargetPort(0) != target) continue;
            return true;
        }
        return false;
    }

    public void setMultipleSelectionAllowed(boolean allowed) {
        LayoutTool tool = this.getTool();
        if (tool instanceof NodeTool) {
            NodeTool nt = (NodeTool)tool;
            nt.getBoundsTool().setMultipleSelectAllowed(allowed);
        }
    }

    public boolean isMultipleSelectionAllowed() {
        LayoutTool tool = this.getTool();
        if (tool instanceof NodeTool) {
            NodeTool nt = (NodeTool)tool;
            return nt.getBoundsTool().isMultipleSelectAllowed();
        }
        return false;
    }

    public int getSelectedNodeCount() {
        int count = this.getContentItem().getItemCount();
        int nodeCount = 0;
        for (int i = 0; i < count; ++i) {
            LayoutItem item = this.getContentItem().getItem(i);
            if (!(item instanceof JLENodeWindow) || !NodeBoundsTool.isSelected((LayoutItem)item)) continue;
            ++nodeCount;
        }
        return nodeCount;
    }

    public Node getSelectedNode(int index) {
        int count = this.getContentItem().getItemCount();
        int nodeCount = 0;
        for (int i = 0; i < count; ++i) {
            JLENodeWindow nw;
            LayoutItem item = this.getContentItem().getItem(i);
            if (!(item instanceof JLENodeWindow) || (nw = (JLENodeWindow)item).getNode() == null || !NodeBoundsTool.isSelected((LayoutItem)item)) continue;
            if (nodeCount == index) {
                return nw.getNode();
            }
            ++nodeCount;
        }
        return null;
    }

    public Node[] getSelectedNodes() {
        int count = this.getContentItem().getItemCount();
        Vector<Node> v = new Vector<Node>();
        for (int i = 0; i < count; ++i) {
            JLENodeWindow nw;
            LayoutItem item = this.getContentItem().getItem(i);
            if (!(item instanceof JLENodeWindow) || (nw = (JLENodeWindow)item).getNode() == null || !NodeBoundsTool.isSelected((LayoutItem)item)) continue;
            v.addElement(nw.getNode());
        }
        int size = v.size();
        Object[] nodes = null;
        if (size != 0) {
            nodes = new Node[size];
            v.copyInto(nodes);
        }
        return nodes;
    }

    public boolean isNodeSelected(Node node) {
        JLENodeWindow window = this.getNodeWindow(node);
        return window == null ? false : NodeBoundsTool.isSelected((LayoutItem)window);
    }

    public void setNodeSelected(Node node, boolean selected) {
        JLENodeWindow window = this.getNodeWindow(node);
        if (window == null) {
            return;
        }
        LayoutTool tool = this.getTool();
        if (tool instanceof NodeTool) {
            NodeTool nt = (NodeTool)tool;
            if (selected) {
                nt.getBoundsTool().processSelect((LayoutItem)window);
            } else {
                nt.getBoundsTool().processDeselect((LayoutItem)window);
            }
        }
    }

    public final void deselectAllNodes() {
        Node[] nodes = this.getSelectedNodes();
        int count = nodes == null ? 0 : nodes.length;
        for (int i = 0; i < count; ++i) {
            this.setNodeSelected(nodes[i], false);
        }
    }

    public int getSelectedEdgeCount() {
        int count = this.getContentItem().getItemCount();
        int edgeCount = 0;
        for (int i = 0; i < count; ++i) {
            LayoutItem item = this.getContentItem().getItem(i);
            if (!(item instanceof EdgeLinkItem) || !NodeBoundsTool.isSelected((LayoutItem)item)) continue;
            ++edgeCount;
        }
        return edgeCount;
    }

    public Edge getSelectedEdge(int index) {
        int count = this.getContentItem().getItemCount();
        int edgeCount = 0;
        for (int i = 0; i < count; ++i) {
            LayoutItem item = this.getContentItem().getItem(i);
            if (!(item instanceof EdgeLinkItem) || !NodeBoundsTool.isSelected((LayoutItem)item)) continue;
            EdgeLinkItem edge = (EdgeLinkItem)item;
            if (edgeCount == index) {
                return edge.getEdge();
            }
            ++edgeCount;
        }
        return null;
    }

    public Edge[] getSelectedEdges() {
        int count = this.getContentItem().getItemCount();
        Vector<Edge> v = new Vector<Edge>();
        for (int i = 0; i < count; ++i) {
            LayoutItem item = this.getContentItem().getItem(i);
            if (!(item instanceof EdgeLinkItem) || !NodeBoundsTool.isSelected((LayoutItem)item)) continue;
            EdgeLinkItem edge = (EdgeLinkItem)item;
            v.addElement(edge.getEdge());
        }
        int size = v.size();
        Object[] edges = null;
        if (size != 0) {
            edges = new Edge[size];
            v.copyInto(edges);
        }
        return edges;
    }

    public boolean isEdgeSelected(Edge edge) {
        EdgeLinkItem item = this._getEdgeLinkItem(edge);
        return item == null ? false : NodeBoundsTool.isSelected((LayoutItem)item);
    }

    public void setEdgeSelected(Edge edge, boolean selected) {
        EdgeLinkItem item = this._getEdgeLinkItem(edge);
        if (item == null) {
            return;
        }
        LayoutTool tool = this.getTool();
        if (tool instanceof NodeTool) {
            NodeTool nt = (NodeTool)tool;
            if (selected) {
                nt.getBoundsTool().processSelect((LayoutItem)item);
            } else {
                nt.getBoundsTool().processDeselect((LayoutItem)item);
            }
        }
    }

    public final void deselectAllEdges() {
        Edge[] edges = this.getSelectedEdges();
        int count = edges == null ? 0 : edges.length;
        for (int i = 0; i < count; ++i) {
            this.setEdgeSelected(edges[i], false);
        }
    }

    public int getSelectedPortCount() {
        int count = this.getContentItem().getItemCount();
        int nodeCount = 0;
        for (int i = 0; i < count; ++i) {
            LayoutItem item = this.getContentItem().getItem(i);
            if (!(item instanceof JLENodeWindow)) continue;
            JLENodeWindow window = (JLENodeWindow)item;
            NodeComponent nc = window.getNodeComponent();
            nodeCount += nc.getSelectedPortCount();
        }
        return nodeCount;
    }

    public Port getSelectedPort(int index) {
        int count = this.getContentItem().getItemCount();
        int nodeCount = 0;
        for (int i = 0; i < count; ++i) {
            LayoutItem item = this.getContentItem().getItem(i);
            if (!(item instanceof JLENodeWindow)) continue;
            JLENodeWindow nw = (JLENodeWindow)item;
            NodeComponent nc = nw.getNodeComponent();
            int portCount = nc.getSelectedPortCount();
            if (nodeCount < portCount) {
                return nc.getSelectedPort(nodeCount);
            }
            nodeCount += portCount;
        }
        return null;
    }

    public Port[] getSelectedPorts() {
        int count = this.getContentItem().getItemCount();
        Vector<Port> v = new Vector<Port>();
        for (int i = 0; i < count; ++i) {
            JLENodeWindow nw;
            NodeComponent nc;
            Port[] temp;
            LayoutItem item = this.getContentItem().getItem(i);
            if (!(item instanceof JLENodeWindow) || (temp = (nc = (nw = (JLENodeWindow)item).getNodeComponent()).getSelectedPorts()) == null) continue;
            for (int j = 0; j < temp.length; ++j) {
                v.addElement(temp[j]);
            }
        }
        int size = v.size();
        Object[] ports = null;
        if (size != 0) {
            ports = new Port[size];
            v.copyInto(ports);
        }
        return ports;
    }

    public boolean isPortSelected(Port port) {
        Node parent = port.getParent();
        while (parent.getParent() != null) {
            parent = parent.getParent();
        }
        JLENodeWindow nw = this.getNodeWindow(parent);
        if (nw == null) {
            return false;
        }
        return nw.getNodeComponent().isPortSelected(port);
    }

    public void setPortSelected(Port port, boolean selected) {
        Node parent = port.getParent();
        while (parent.getParent() != null) {
            parent = parent.getParent();
        }
        JLENodeWindow nw = this.getNodeWindow(parent);
        if (nw != null) {
            nw.getNodeComponent().setPortSelected(port, selected);
        }
    }

    public final void deselectAllPorts() {
        Port[] ports = this.getSelectedPorts();
        int count = ports == null ? 0 : ports.length;
        for (int i = 0; i < count; ++i) {
            this.setPortSelected(ports[i], false);
        }
    }

    public void addActionListener(ActionListener listener) {
        if (this._actionListeners == null) {
            this._actionListeners = new ListenerManager();
        }
        this._actionListeners.addListener((EventListener)listener);
    }

    public void removeActionListener(ActionListener listener) {
        if (this._actionListeners != null) {
            this._actionListeners.removeListener((EventListener)listener);
        }
    }

    @Override
    public boolean isSource(Port port) {
        return this._sources.get(port) != null;
    }

    @Override
    public boolean isTarget(Port port) {
        return this._targets.get(port) != null;
    }

    @Override
    public EdgeFactory getEdgeFactory() {
        return this._edgeFactory == null ? DefaultEdgeFactory.getEdgeFactory() : this._edgeFactory;
    }

    public void setEdgeFactory(EdgeFactory edgeFactory) {
        this._edgeFactory = edgeFactory;
    }

    @Override
    public void showMenuForPort(Port port, NodeComponent nodeComponent, int x, int y) {
        Point p;
        JPopupMenu menu = this.getDefaultMenuForPort(port);
        if (menu == null) {
            return;
        }
        this._menuPort = port;
        for (Object c = nodeComponent; c != null && c != this; c = ((Component)c).getParent()) {
            p = ((Component)c).getLocation();
            x += p.x;
            y += p.y;
        }
        p = this.contentToDevice(x, y);
        MenuUtils.showPopupMenu((JPopupMenu)menu, (Component)((Object)this), (int)p.x, (int)p.y);
    }

    public void setDefaultLinkPainter(LinkPainter painter) {
        this._defaultPainter = painter;
    }

    public LinkPainter getDefaultLinkPainter() {
        return this._defaultPainter == null ? DefaultLinkPainter.getLinkPainter() : this._defaultPainter;
    }

    public void reshape(int x, int y, int width, int height) {
        super.reshape(x, y, width, height);
        Dimension2D contentSize = this.getContentItem().getItemSize();
        double contentWidth = contentSize.getWidth();
        double contentHeight = contentSize.getHeight();
        if (this.getScrollableTracksViewportWidth()) {
            contentWidth = (double)width * this.getEngineUnitsPerPixelX();
        }
        if (this.getScrollableTracksViewportHeight()) {
            contentHeight = (double)height * this.getEngineUnitsPerPixelY();
        }
        this.getContentItem().setItemSize(contentWidth, contentHeight);
    }

    public LayoutItem getFocusNext(LayoutItem base, boolean allowAll) {
        LayoutItem next;
        LayoutItem target = base;
        if (target != null && target.getItemParent() != null) {
            LayoutItem p;
            do {
                Object[] items;
                boolean found = false;
                p = target.getItemParent();
                if (p == this.getContentItem()) {
                    items = new LayoutItem[this._items.size()];
                    this._items.copyInto(items);
                } else {
                    items = p.getItems();
                }
                int count = items == null ? 0 : items.length;
                boolean wrapped = false;
                for (int i = 0; i < count; ++i) {
                    Object c = items[i];
                    if (found) {
                        if (c.isFocusTraversable() || allowAll) {
                            return c;
                        }
                    } else if (c == target) {
                        found = true;
                    }
                    if (i != count - 1 || wrapped) continue;
                    i = -1;
                    wrapped = true;
                }
            } while ((target = p) != this.getContentItem() && target.getItemParent() != null);
        }
        if ((next = this.focusForwardAndInto((LayoutItem)this.getContentItem(), allowAll)) == target && target != null) {
            return this.focusForwardAndInto(next, allowAll);
        }
        return next;
    }

    public void setZoom(double factorX, double factorY) {
        super.setZoom(factorX, factorY);
        this._updateTooltips();
    }

    protected GlassPane createGlassPane() {
        return new NodeGlassPane(this);
    }

    protected JLENodeWindow createNodeWindow() {
        return new JLENodeWindow();
    }

    protected void processEventImpl(AWTEvent e) {
        if (e instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)e);
        } else {
            super.processEventImpl(e);
        }
    }

    protected void processActionEvent(ActionEvent e) {
        int id = e.getID();
        if (this._actionListeners == null) {
            return;
        }
        Enumeration enumer = this._actionListeners.getListeners();
        if (enumer == null) {
            return;
        }
        switch (id) {
            case 1001: {
                while (enumer.hasMoreElements()) {
                    ((ActionListener)enumer.nextElement()).actionPerformed(e);
                }
                break;
            }
        }
    }

    boolean __fireVetoableChange(String propertyName, Object oldValue, Object newValue) {
        try {
            super.fireVetoableChange(propertyName, oldValue, newValue);
        }
        catch (PropertyVetoException pve) {
            return true;
        }
        return false;
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (propertyName == "edgeCount") {
            if (oldValue == null) {
                this._edgeAdded((Edge)newValue);
            } else {
                this._edgeRemoved((Edge)oldValue);
            }
        }
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected JPopupMenu getDefaultMenuForNode(Node node) {
        return null;
    }

    protected JPopupMenu getDefaultMenuForMinimizedNode(Node node) {
        return this.getDefaultMenuForNode(node);
    }

    protected JPopupMenu getDefaultMenuForEdge(Edge edge) {
        return null;
    }

    protected JPopupMenu getDefaultMenuForGraph() {
        return null;
    }

    protected JPopupMenu getDefaultMenuForPort(Port port) {
        if (!port.isSourceable()) {
            return null;
        }
        Node[] nodes = this.getNodes();
        if (nodes == null) {
            return null;
        }
        Node parentNode = port.getParent();
        while (parentNode.getParent() != null) {
            parentNode = parentNode.getParent();
        }
        JPopupMenu menu = new JPopupMenu();
        Locale locale = this.getLocale();
        ResourceBundle b = ResourceBundle.getBundle("oracle.bali.dbUI.resource.GraphBundle", locale);
        String text = b.getString(_KEY_LINKTO);
        MessageFormat form = new MessageFormat(text);
        Object[] args = new Object[]{port.getDisplayName(locale)};
        String menuName = form.format(args);
        JMenu linkTo = new JMenu(menuName);
        menu.add(linkTo);
        for (Node n : nodes) {
            JMenu nodeMenu;
            if (n == parentNode || (nodeMenu = this._getMenuForNode(n, port, locale)) == null) continue;
            linkTo.add(nodeMenu);
        }
        text = b.getString(_KEY_DELETELINK);
        form = new MessageFormat(text);
        Object[] args2 = new Object[]{port.getDisplayName(locale)};
        menuName = form.format(args2);
        JMenu deleteSubMenu = new JMenu(menuName);
        Edge[] edges = this.getEdges();
        int edgeCount = edges == null ? 0 : edges.length;
        for (int i = 0; i < edgeCount; ++i) {
            Port match = null;
            Edge e = edges[i];
            for (int j = 0; j < e.getSourcePortCount(); ++j) {
                Port child = e.getSourcePort(j);
                Port parent = e.getTargetPort(j);
                if (port == child) {
                    match = parent;
                }
                if (port == parent) {
                    match = child;
                }
                if (match == null) continue;
                String name = GraphCanvas._getActionCommand(match, locale, false);
                JMenuItem item = new JMenuItem(name);
                item.setActionCommand(COMMAND_DELETE_LINK + name);
                item.addActionListener(this._listener);
                deleteSubMenu.add(item);
            }
        }
        menu.add(deleteSubMenu);
        deleteSubMenu.setEnabled(deleteSubMenu.getMenuComponentCount() > 0);
        return menu;
    }

    EdgeLinkItem __addEdge(Edge edge, Port sPort, JLENodeWindow sWindow, Port dPort, JLENodeWindow dWindow) {
        PortLinkPort sLinkPort = new PortLinkPort(sPort, sWindow, false);
        PortLinkPort dLinkPort = new PortLinkPort(dPort, dWindow, true);
        EdgeLinkItem link = new EdgeLinkItem(sLinkPort, dLinkPort, edge);
        link.setLinkPainter(this.getDefaultLinkPainter());
        this.getContentItem().addItem((LayoutItem)link);
        this._items.addElement(link);
        this._links.put(edge, link);
        this.firePropertyChange("edgeCount", null, edge);
        return link;
    }

    void __removeItem(Object o) {
        this._items.removeElement(o);
    }

    void __fireActionEvent(Object node, String command, int modifiers) {
        this.processEvent(new ActionEvent(node, 1001, command, modifiers));
    }

    void __showMenuForNode(Node node, Component component, int x, int y, boolean minimized) {
        Point p;
        JPopupMenu menu;
        JPopupMenu jPopupMenu = menu = minimized ? this.getDefaultMenuForMinimizedNode(node) : this.getDefaultMenuForNode(node);
        if (menu == null) {
            return;
        }
        for (Component c = component; c != null && c != this; c = c.getParent()) {
            p = c.getLocation();
            x += p.x;
            y += p.y;
        }
        p = this.contentToDevice(x, y);
        MenuUtils.showPopupMenu((JPopupMenu)menu, (Component)((Object)this), (int)p.x, (int)p.y);
    }

    void __showMenuForEdge(Edge edge, LayoutItem item, double x, double y) {
        JPopupMenu menu = this.getDefaultMenuForEdge(edge);
        if (menu == null) {
            return;
        }
        Point2D point = item.getItemLocation();
        Point p = this.contentToDevice(x + point.getX(), y + point.getY());
        MenuUtils.showPopupMenu((JPopupMenu)menu, (Component)((Object)this), (int)p.x, (int)p.y);
    }

    void __showMenuForGraph(double x, double y) {
        JPopupMenu menu = this.getDefaultMenuForGraph();
        if (menu == null) {
            return;
        }
        Point p = this.contentToDevice(x, y);
        MenuUtils.showPopupMenu((JPopupMenu)menu, (Component)((Object)this), (int)p.x, (int)p.y);
    }

    void __createLink(String targetName) {
        int index = targetName.indexOf(_CREATE_SEPARATOR);
        String parentName = index == -1 ? targetName : targetName.substring(0, index);
        String childName = index == -1 ? null : targetName.substring(index + 1);
        Locale l = LocaleUtils.getDefaultableLocale((Component)((Object)this));
        Node parent = this._findNode(parentName, l);
        if (parent == null) {
            return;
        }
        Port target = GraphCanvas._findPort(parent, childName, l, true);
        if (target == null) {
            return;
        }
        Port source = this._menuPort;
        Edge e = this.getEdgeFactory().createEdge(source, target);
        if (e == null) {
            return;
        }
        this.addEdge(e);
    }

    void __deleteLink(String targetName) {
        int index = targetName.indexOf(_DELETE_SEPARATOR);
        String parentName = index == -1 ? targetName : targetName.substring(0, index);
        String childName = index == -1 ? null : targetName.substring(index + _DELETE_SEPARATOR.length());
        Locale l = LocaleUtils.getDefaultableLocale((Component)((Object)this));
        Node parent = this._findNode(parentName, l);
        if (parent == null) {
            return;
        }
        Port target = GraphCanvas._findPort(parent, childName, l, false);
        if (target == null) {
            return;
        }
        Port source = this._menuPort;
        Edge[] edges = this.getEdges();
        int count = edges == null ? 0 : edges.length;
        Edge edge = null;
        for (int i = 0; i < count; ++i) {
            Edge temp = edges[i];
            if ((temp.getSourcePort(0) != source || temp.getTargetPort(0) != target) && (temp.getSourcePort(0) != target || temp.getTargetPort(0) != source)) continue;
            edge = temp;
            break;
        }
        if (edge != null) {
            this.removeEdge(edge);
        }
    }

    void __redispatchMouseEvent(JLEEvent e, LayoutItem originalItem) {
        GraphCanvas canvas = this;
        Point2D point = ItemUtils.itemToDevice((LayoutItem)originalItem, (double)e.getX(), (double)e.getY());
        Point2D hitPoint = canvas.deviceToContent(point.getX(), point.getY());
        LayoutItem item = canvas.getHitItem(point.getX(), point.getY());
        if (item != null) {
            point = ItemUtils.deviceToItem((LayoutItem)item, (double)point.getX(), (double)point.getY());
            e = new JLEEvent(e.getSource(), e.getID(), e.getWhen(), e.getModifiers(), point.getX(), point.getY(), e.getClickCount());
            item.processEvent(e);
        }
    }

    static boolean __isPopupTrigger(JLEEvent e) {
        return (e.getModifiers() & 0x10) == 0;
    }

    static boolean __isPopupTrigger(MouseEvent e) {
        if (e.isPopupTrigger()) {
            return true;
        }
        return (e.getModifiers() & 0x10) == 0;
    }

    private EdgeLinkItem _getEdgeLinkItem(Edge edge) {
        return (EdgeLinkItem)this._links.get(edge);
    }

    private boolean _equals(Edge e1, Edge e2) {
        if (e1 == e2) {
            return true;
        }
        if (e1 == null || e2 == null) {
            return false;
        }
        int c1 = e1.getSourcePortCount();
        if (c1 != e2.getSourcePortCount()) {
            return false;
        }
        for (int i = 0; i < c1; ++i) {
            if (e1.getSourcePort(i) == e2.getSourcePort(i) && e1.getTargetPort(i) == e2.getTargetPort(i)) continue;
            return false;
        }
        return true;
    }

    private JLENodeWindow _findWindow(Port p) {
        Node parent;
        Node node = parent = p instanceof Node ? (Node)p : p.getParent();
        while (parent != null && parent.getParent() != null) {
            parent = parent.getParent();
        }
        return this.getNodeWindow(parent);
    }

    private void _edgeAdded(Edge edge) {
        int count = edge.getSourcePortCount();
        for (int i = 0; i < count; ++i) {
            Port source = edge.getSourcePort(i);
            this._addToTable(source, this._sources);
            Port target = edge.getTargetPort(i);
            this._addToTable(target, this._targets);
        }
    }

    private void _edgeRemoved(Edge edge) {
        int count = edge.getSourcePortCount();
        for (int i = 0; i < count; ++i) {
            Port source = edge.getSourcePort(i);
            this._removeFromTable(source, this._sources);
            Port target = edge.getTargetPort(i);
            this._removeFromTable(target, this._targets);
        }
    }

    private void _addToTable(Object name, Hashtable table) {
        Object o = table.get(name);
        if (o == null) {
            table.put(name, IntegerUtils.getInteger((int)1));
        } else {
            Integer integer = (Integer)o;
            table.put(name, IntegerUtils.getInteger((int)(integer + 1)));
        }
    }

    private void _removeFromTable(Object name, Hashtable table) {
        Object o = table.get(name);
        if (o != null) {
            Integer integer = (Integer)o;
            int i = integer;
            if (i == 1) {
                table.remove(name);
            } else {
                table.put(name, IntegerUtils.getInteger((int)(i - 1)));
            }
        }
    }

    private JMenu _getMenuForNode(Node node, Port source, Locale locale) {
        Port[] targets = this.getEdgeFactory().getTargetablePorts(source, node);
        if (targets == null || targets.length == 0) {
            return null;
        }
        JMenu nodeSubMenu = new JMenu(node.getDisplayName(locale));
        for (int j = 0; j < targets.length; ++j) {
            Port tempPort = targets[j];
            JMenuItem item = new JMenuItem(tempPort.getDisplayName(locale));
            String name = GraphCanvas._getActionCommand(tempPort, locale, true);
            item.setActionCommand(COMMAND_LINK + name);
            item.addActionListener(this._listener);
            nodeSubMenu.add(item);
            if (!(tempPort instanceof Node) || (item = this._getMenuForNode((Node)tempPort, source, locale)) == null) continue;
            nodeSubMenu.add(item);
        }
        return nodeSubMenu;
    }

    private static String _getActionCommand(Port p, Locale locale, boolean create) {
        String name = p.getDisplayName(locale);
        String separator = create ? _CREATE_SEPARATOR : _DELETE_SEPARATOR;
        for (Node parent = p.getParent(); parent != null; parent = parent.getParent()) {
            name = parent.getDisplayName(locale) + separator + name;
        }
        return name;
    }

    private Node _findNode(String name, Locale locale) {
        Node[] nodes = this.getNodes();
        if (nodes == null || name == null) {
            return null;
        }
        for (int i = 0; i < nodes.length; ++i) {
            if (!name.equals(nodes[i].getDisplayName(locale))) continue;
            return nodes[i];
        }
        return null;
    }

    private static Port _findPort(Node parent, String name, Locale locale, boolean create) {
        String separator = create ? _CREATE_SEPARATOR : _DELETE_SEPARATOR;
        int length = separator.length();
        int index = name.indexOf(separator);
        String parentName = index == -1 ? name : name.substring(0, index);
        String childName = index == -1 ? null : name.substring(index + length);
        int count = parent.getPortCount();
        for (int i = 0; i < count; ++i) {
            Port childPort;
            Port temp = parent.getPort(i);
            if (!parentName.equals(temp.getDisplayName(locale))) continue;
            if (childName != null && temp instanceof Node && (childPort = GraphCanvas._findPort((Node)temp, childName, locale, create)) != null) {
                return childPort;
            }
            return temp;
        }
        return null;
    }

    private boolean _isChild(Port p, Node n) {
        Node parent = p.getParent();
        return parent == n ? true : (parent == null ? false : this._isChild(parent, n));
    }

    private void _updateTooltips() {
        boolean b = this.getAutoDisplayToolTips();
        boolean zoomed = this.getZoomX() < 1.0 || this.getZoomY() < 1.0;
        boolean display = b & zoomed;
        int count = this.getContentItem().getItemCount();
        boolean nodeCount = false;
        for (int i = 0; i < count; ++i) {
            LayoutItem item = this.getContentItem().getItem(i);
            if (!(item instanceof JLENodeWindow)) continue;
            JLENodeWindow window = (JLENodeWindow)item;
            window.setAutoDisplayToolTips(display);
        }
    }

    private class Listener
    extends JLEEventAdapter
    implements LinkToolListener,
    ActionListener,
    PropertyChangeListener {
        private Listener() {
        }

        public void linkCreating(LinkToolEvent e) {
        }

        public void linkPositioning(LinkToolEvent e) {
        }

        public void linkCreated(LinkToolEvent e) {
            if (e.getLinkItem() != null) {
                e.getLinkItem().setLinkPainter(GraphCanvas.this.getDefaultLinkPainter());
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if ("portLocation".equals(name)) {
                GraphCanvas.this.repaint();
            } else if (LayoutItem.DEVICE_TRANSFORM_KEY.equals(name) || LayoutItem.BOUNDS_KEY.equals(name)) {
                double bottom;
                LayoutItem i = (LayoutItem)e.getSource();
                Rectangle2D bounds = i.getItemBounds();
                Dimension2D viewportSize = GraphCanvas.this.getJLECanvasSize();
                boolean setViewport = false;
                double right = bounds.getX() + bounds.getWidth();
                if (right > viewportSize.getWidth()) {
                    viewportSize.setSize(right + 5.0, viewportSize.getHeight());
                    setViewport = true;
                }
                if ((bottom = bounds.getY() + bounds.getHeight()) > viewportSize.getHeight()) {
                    viewportSize.setSize(viewportSize.getWidth(), bottom + 5.0);
                    setViewport = true;
                }
                if (setViewport) {
                    GraphCanvas.this.setJLECanvasSize(viewportSize.getWidth(), viewportSize.getHeight());
                }
            }
        }

        public void mousePressed(JLEEvent e) {
            if (GraphCanvas.__isPopupTrigger(e) && GraphCanvas.this.getHitItem(e.getX(), e.getY()) == null) {
                e.consume();
            }
        }

        public void mouseReleased(JLEEvent e) {
            if (GraphCanvas.__isPopupTrigger(e) && GraphCanvas.this.getHitItem(e.getX(), e.getY()) == null) {
                e.consume();
                GraphCanvas.this.__showMenuForGraph(e.getX(), e.getY());
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if (cmd != null) {
                if (cmd.startsWith(GraphCanvas.COMMAND_LINK)) {
                    cmd = cmd.substring(GraphCanvas.COMMAND_LINK.length());
                    GraphCanvas.this.__createLink(cmd);
                } else if (cmd.startsWith(GraphCanvas.COMMAND_DELETE_LINK)) {
                    cmd = cmd.substring(GraphCanvas.COMMAND_DELETE_LINK.length());
                    GraphCanvas.this.__deleteLink(cmd);
                } else if ("NodeComponent.portDoubleClick".equals(cmd)) {
                    GraphCanvas.this.__fireActionEvent(e.getSource(), GraphCanvas.COMMAND_PORT_DOUBLE_CLICK, e.getModifiers());
                } else if ("NodeComponent.portSingleClick".equals(cmd)) {
                    GraphCanvas.this.__fireActionEvent(e.getSource(), GraphCanvas.COMMAND_PORT_SINGLE_CLICK, e.getModifiers());
                }
            }
        }
    }
}

