/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.graph.jle;

import java.awt.IllegalComponentStateException;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.JComponent;
import oracle.bali.dbUI.graph.jle.AccessibleComponentImpl;
import oracle.bali.dbUI.graph.jle.JLEWindow;
import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.item.AccessibleLayoutItem;

class AccessibleJLEWindow
extends AccessibleLayoutItem
implements AccessibleAction {
    private static final String _KEY_MINIMIZE = "TOGGLE_MINIMIZE";
    private static final String _KEY_SELECT = "TOGGLE_SELECT";
    private JLEWindow _window;

    public AccessibleJLEWindow(JLEWindow window) {
        super((LayoutItem)window);
        this._window = window;
    }

    public JLEWindow getWindow() {
        return this._window;
    }

    public String getAccessibleName() {
        String name = super.getAccessibleName();
        if (name == null || "".equals(name)) {
            name = this.getWindow().getTitle();
        }
        return name;
    }

    public AccessibleRole getAccessibleRole() {
        return this.getWindow().isMinimized() ? AccessibleRole.DESKTOP_ICON : AccessibleRole.INTERNAL_FRAME;
    }

    public AccessibleStateSet getAccessibleStateSet() {
        AccessibleStateSet states = new AccessibleStateSet();
        if (this.getWindow().isEnabled()) {
            states.add(AccessibleState.ENABLED);
        }
        if (this.getWindow().isVisible()) {
            states.add(AccessibleState.VISIBLE);
            if (this.getWindow().getComponent().isShowing()) {
                states.add(AccessibleState.SHOWING);
            }
        }
        if (this.getWindow().isResizable()) {
            states.add(AccessibleState.RESIZABLE);
        }
        states.add(AccessibleState.SELECTABLE);
        if (this.getWindow().isSelected()) {
            states.add(AccessibleState.SELECTED);
            states.add(AccessibleState.ACTIVE);
        }
        states.add(AccessibleState.FOCUSABLE);
        if (((JComponent)this.getWindow().getComponent()).hasFocus()) {
            states.add(AccessibleState.FOCUSED);
        }
        if (this.getWindow().isMinimized()) {
            states.add(AccessibleState.ICONIFIED);
        }
        return states;
    }

    public int getAccessibleChildrenCount() {
        return this.getWindow().getContent() instanceof Accessible ? 1 : 0;
    }

    public AccessibleComponent getAccessibleComponent() {
        return new AccessibleComponentImpl(this.getWindow().getComponent());
    }

    public Accessible getAccessibleChild(int i) {
        if (i < 0 || i >= this.getAccessibleChildrenCount()) {
            return null;
        }
        return this.getWindow().getContent() instanceof Accessible ? (Accessible)((Object)this.getWindow().getContent()) : null;
    }

    public Locale getLocale() throws IllegalComponentStateException {
        return this.getWindow().getComponent().getLocale();
    }

    public AccessibleAction getAccessibleAction() {
        return this;
    }

    @Override
    public int getAccessibleActionCount() {
        return 2;
    }

    @Override
    public String getAccessibleActionDescription(int i) {
        if (i < 0 || i >= this.getAccessibleActionCount()) {
            return null;
        }
        String desc = null;
        ResourceBundle b = ResourceBundle.getBundle("oracle.bali.dbUI.resource.AccessibleBundle", this.getLocale());
        switch (i) {
            case 0: {
                desc = b.getString(_KEY_MINIMIZE);
                break;
            }
            case 1: {
                desc = b.getString(_KEY_SELECT);
            }
        }
        return desc;
    }

    @Override
    public boolean doAccessibleAction(int i) {
        if (i < 0 || i >= this.getAccessibleActionCount()) {
            return false;
        }
        switch (i) {
            case 0: {
                this.getWindow().setMinimized(!this.getWindow().isMinimized());
                break;
            }
            case 1: {
                this.getWindow().setSelected(!this.getWindow().isSelected());
            }
        }
        return true;
    }
}

