/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.constraintComponent;

import java.awt.Component;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JTextField;
import oracle.bali.dbUI.constraint.DCCollectionExpression;
import oracle.bali.dbUI.constraint.DCConstant;
import oracle.bali.dbUI.constraint.DataConstraint;
import oracle.bali.dbUI.constraintComponent.BaseConstraintComponent;
import oracle.bali.dbUI.db.DataDescriptor;

public class StringConstraintComp
extends BaseConstraintComponent {
    public static final int CONDITION_CONTAINS = 100;
    public static final int CONDITION_DOES_NOT_CONTAIN = 101;
    public static final int CONDITION_STARTS_WITH = 102;
    public static final int CONDITION_DOES_NOT_START_WITH = 103;
    public static final int CONDITION_ENDS_WITH = 104;
    public static final int CONDITION_DOES_NOT_END_WITH = 105;
    private static final String _CONTAINS_KEY = "TEXT_CONTAINS";
    private static final String _DOES_NOT_CONTAIN_KEY = "TEXT_DOES_NOT_CONTAIN";
    private static final String _STARTS_WITH_KEY = "TEXT_STARTS_WITH";
    private static final String _DOES_NOT_START_WITH_KEY = "TEXT_DOES_NOT_START_WITH";
    private static final String _ENDS_WITH_KEY = "TEXT_ENDS_WITH";
    private static final String _DOES_NOT_END_WITH_KEY = "TEXT_DOES_NOT_END_WITH";
    private static final int _STRING_COUNT = 6;
    private static final int _CONTAINS_INDEX = 2;
    private static final int _DOES_NOT_CONTAIN_INDEX = 3;
    private static final int _STARTS_WITH_INDEX = 4;
    private static final int _DOES_NOT_START_WITH_INDEX = 5;
    private static final int _ENDS_WITH_INDEX = 6;
    private static final int _DOES_NOT_END_WITH_INDEX = 7;

    public StringConstraintComp() {
        this.setBetweenAllowed(true);
    }

    public void setTestString(String string) {
        this._getTextField().setText(string);
    }

    public String getTestString() {
        return this._getTextField().getText();
    }

    @Override
    protected boolean isConditionValid(int condition) {
        if (condition == 100 || condition == 101 || condition == 102 || condition == 103 || condition == 104 || condition == 105) {
            return true;
        }
        return super.isConditionValid(condition);
    }

    @Override
    protected int convertConditionToSelection(int condition) {
        int index = -1;
        switch (condition) {
            case 100: {
                index = 2;
                break;
            }
            case 101: {
                index = 3;
                break;
            }
            case 102: {
                index = 4;
                break;
            }
            case 103: {
                index = 5;
                break;
            }
            case 104: {
                index = 6;
                break;
            }
            case 105: {
                index = 7;
                break;
            }
            default: {
                index = super.convertConditionToSelection(condition);
            }
        }
        return index;
    }

    @Override
    protected int convertSelectionToCondition(int selection) {
        int condition = -1;
        switch (selection) {
            case 2: {
                condition = 100;
                break;
            }
            case 3: {
                condition = 101;
                break;
            }
            case 4: {
                condition = 102;
                break;
            }
            case 5: {
                condition = 103;
                break;
            }
            case 6: {
                condition = 104;
                break;
            }
            case 7: {
                condition = 105;
                break;
            }
            default: {
                condition = super.convertSelectionToCondition(selection);
            }
        }
        return condition;
    }

    @Override
    protected int getBaseBetweenIndex() {
        return super.getBaseBetweenIndex() + 6;
    }

    @Override
    protected int getBaseNullIndex() {
        return super.getBaseNullIndex() + 6;
    }

    @Override
    protected int getItemCount() {
        return super.getItemCount() + 6;
    }

    @Override
    protected String[] getChoiceValues(Locale locale) {
        ResourceBundle b = ResourceBundle.getBundle("oracle.bali.dbUI.resource.DBUIBundle", locale);
        String[] strings = super.getChoiceValues(locale);
        strings[2] = b.getString(_CONTAINS_KEY);
        strings[3] = b.getString(_DOES_NOT_CONTAIN_KEY);
        strings[4] = b.getString(_STARTS_WITH_KEY);
        strings[5] = b.getString(_DOES_NOT_START_WITH_KEY);
        strings[6] = b.getString(_ENDS_WITH_KEY);
        strings[7] = b.getString(_DOES_NOT_END_WITH_KEY);
        return strings;
    }

    @Override
    protected DataConstraint getDataConstraint(DataDescriptor descriptor, int condition) {
        DataConstraint d = null;
        DataConstraint value = this.getValueDataConstraint(this.getValueComponent(), descriptor, condition);
        DataConstraint item = this.getItemDataConstraint(descriptor, condition);
        switch (condition) {
            case 100: {
                int operand = 5;
                d = new DCCollectionExpression(value, item, operand);
                break;
            }
            case 101: {
                int operand = 6;
                d = new DCCollectionExpression(value, item, operand);
                break;
            }
            case 102: {
                int operand = 1;
                d = new DCCollectionExpression(value, item, operand);
                break;
            }
            case 103: {
                int operand = 2;
                d = new DCCollectionExpression(value, item, operand);
                break;
            }
            case 104: {
                int operand = 3;
                d = new DCCollectionExpression(value, item, operand);
                break;
            }
            case 105: {
                int operand = 4;
                d = new DCCollectionExpression(value, item, operand);
                break;
            }
            default: {
                d = super.getDataConstraint(descriptor, condition);
            }
        }
        return d;
    }

    @Override
    protected void parseConstraint(DataConstraint constraint) {
        if (constraint == null || !(constraint instanceof DCCollectionExpression)) {
            super.parseConstraint(constraint);
        } else {
            DCCollectionExpression b = (DCCollectionExpression)constraint;
            int condition = -1;
            switch (b.getOperand()) {
                case 5: {
                    condition = 100;
                    break;
                }
                case 6: {
                    condition = 101;
                    break;
                }
                case 1: {
                    condition = 102;
                    break;
                }
                case 2: {
                    condition = 103;
                    break;
                }
                case 3: {
                    condition = 104;
                    break;
                }
                case 4: {
                    condition = 105;
                }
            }
            this.setTestString(this._getString(b));
            this.setTestCondition(condition);
        }
    }

    @Override
    protected int getNotCondition(int condition) {
        switch (condition) {
            case 100: {
                condition = 101;
                break;
            }
            case 101: {
                condition = 100;
                break;
            }
            case 102: {
                condition = 103;
                break;
            }
            case 104: {
                condition = 105;
                break;
            }
            case 103: {
                condition = 102;
                break;
            }
            case 105: {
                condition = 104;
                break;
            }
            default: {
                condition = super.getNotCondition(condition);
            }
        }
        return condition;
    }

    private String _getString(DCCollectionExpression c) {
        DataConstraint c1 = c.getConstraint(0);
        DataConstraint c2 = c.getConstraint(1);
        String s = null;
        if (c1 instanceof DCConstant) {
            s = (String)((DCConstant)c1).getValue();
        } else if (c2 instanceof DCConstant) {
            s = (String)((DCConstant)c2).getValue();
        }
        return s;
    }

    private JTextField _getTextField() {
        Component c = this.getValueComponent();
        return (JTextField)c;
    }
}

