/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.constraintComponent;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import oracle.bali.dbUI.constraint.DataConstraint;
import oracle.bali.dbUI.constraint.FreeFormDataConstraint;
import oracle.bali.dbUI.constraintComponent.BaseConstraintComponent;
import oracle.bali.dbUI.constraintComponent.CollectionConstraintComp;
import oracle.bali.dbUI.constraintComponent.ConstraintComponent;
import oracle.bali.dbUI.constraintComponent.DateConstraintComp;
import oracle.bali.dbUI.constraintComponent.FreeFormComponent;
import oracle.bali.dbUI.constraintComponent.MultiDescriptorComponent;
import oracle.bali.dbUI.constraintComponent.NumberConstraintComp;
import oracle.bali.dbUI.constraintComponent.StringConstraintComp;
import oracle.bali.dbUI.db.DataDescriptor;
import oracle.bali.dbUI.db.DataDescriptorProvider;
import oracle.bali.dbUI.util.Collection;
import oracle.bali.ewt.LWComponent;

public class ConstraintCompFactory {
    private static ConstraintCompFactory _sFactory;

    public static ConstraintCompFactory getConstraintCompFactory() {
        if (_sFactory == null) {
            _sFactory = new ConstraintCompFactory();
        }
        return _sFactory;
    }

    public ConstraintComponent createConstraintComponent(DataDescriptorProvider provider, DataDescriptor descriptor, DataConstraint constraint) {
        return this.createConstraintComponent(provider, descriptor, constraint, false);
    }

    public ConstraintComponent createConstraintComponent(DataDescriptorProvider provider, DataDescriptor descriptor, DataConstraint constraint, boolean jdkDnD) {
        LWComponent c = null;
        if (constraint instanceof FreeFormDataConstraint) {
            c = new FreeFormComponent();
        } else if (provider != null) {
            c = new MultiDescriptorComponent(provider);
            if (jdkDnD) {
                ((MultiDescriptorComponent)c).enableJDKDnD();
            }
        } else {
            Class type;
            Class clazz = type = descriptor == null ? null : descriptor.getDataType();
            if (type == Byte.class || type == Byte.TYPE || type == Double.class || type == Double.TYPE || type == BigDecimal.class || type == BigInteger.class || type == Float.class || type == Float.TYPE || type == Integer.class || type == Integer.TYPE || type == Long.class || type == Long.TYPE || type == Number.class || type == Short.class || type == Short.TYPE) {
                NumberConstraintComp n = new NumberConstraintComp();
                n.setDataType(type);
                c = n;
            } else if (type == String.class || type == Character.class || type == Character.TYPE) {
                c = new StringConstraintComp();
            } else if (type == Collection.class) {
                c = new CollectionConstraintComp();
            } else if (type == java.util.Date.class) {
                DateConstraintComp d = new DateConstraintComp();
                d.setTestDate(new java.util.Date());
                c = d;
            } else if (type == Date.class) {
                DateConstraintComp d = new DateConstraintComp();
                d.setTestDate(new java.util.Date());
                d.setDataType(Date.class);
                DateFormat f = DateFormat.getDateInstance(3);
                d.setDateFormat(f);
                c = d;
            } else if (type == Time.class) {
                DateConstraintComp d = new DateConstraintComp();
                d.setTestDate(new java.util.Date());
                d.setDataType(Time.class);
                DateFormat f = DateFormat.getTimeInstance(3);
                d.setDateFormat(f);
                c = d;
            } else if (type == Timestamp.class) {
                DateConstraintComp d = new DateConstraintComp();
                d.setTestDate(new java.util.Date());
                d.setDataType(Timestamp.class);
                DateFormat f = DateFormat.getDateTimeInstance(3, 3);
                d.setDateFormat(f);
                c = d;
            } else {
                c = new BaseConstraintComponent();
            }
        }
        if (c != null) {
            c.initState(descriptor, constraint);
        }
        return c;
    }

    protected ConstraintCompFactory() {
    }
}

