/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.constraintBuilder;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import oracle.bali.dbUI.constraint.DataConstraint;
import oracle.bali.dbUI.constraintBuilder.AndOrComponent;
import oracle.bali.dbUI.constraintBuilder.ConstraintBuilder;
import oracle.bali.dbUI.constraintBuilder.ConstraintBuilderComp;
import oracle.bali.dbUI.constraintBuilder.ParentComponent;
import oracle.bali.dbUI.constraintBuilder.Sprout;
import oracle.bali.dbUI.laf.DBUILookAndFeel;
import oracle.bali.ewt.dnd.DropTargetDragEvent;
import oracle.bali.ewt.dnd.DropTargetDropEvent;
import oracle.bali.ewt.painter.BorderPainter;

public class RootComponent
extends ParentComponent {
    private static final String _KEY_ROOT = "ROOT";
    private boolean _leafLocationValid;

    public RootComponent() {
        this.setBackground(Color.white);
    }

    @Override
    public DataConstraint getDataConstraint() {
        return this.getChildCount() == 0 ? null : this.getChild(0).getDataConstraint();
    }

    @Override
    public void setDataConstraint(DataConstraint constraint) {
        this.removeAll();
        if (constraint != null) {
            this.addChild(this.getConstraintBuilder().parseConstraint(constraint));
        }
    }

    @Override
    public int getGroupDepth() {
        if (this.getChildCount() == 0) {
            return 0;
        }
        ConstraintBuilderComp comp = this.getChild(0);
        if (comp instanceof ParentComponent) {
            return ((ParentComponent)comp).getGroupDepth();
        }
        return 0;
    }

    public int getGroupWidth(int group) {
        if (this.getChildCount() == 0) {
            return 0;
        }
        ConstraintBuilderComp comp = this.getChild(0);
        if (comp instanceof ParentComponent) {
            int width = this.getGroupWidth();
            if (group == 0) {
                width += 2;
            }
            return width;
        }
        return 0;
    }

    public boolean isLeafLocationValid() {
        return this._leafLocationValid;
    }

    @Override
    public void addChild(ConstraintBuilderComp toAdd, int index) {
        if (this.getChildCount() == 0) {
            super.addChild(toAdd, index);
        } else {
            ConstraintBuilderComp comp = this.getChild(0);
            if (comp instanceof AndOrComponent) {
                ((AndOrComponent)comp).addChild(toAdd);
            } else {
                this.removeChild(comp);
                ConstraintBuilder cb = this.getConstraintBuilder();
                AndOrComponent andOr = cb.createAndOrComponent(true);
                andOr.setConstraintBuilder(cb);
                andOr.addChild(comp);
                andOr.addChild(toAdd);
                super.addChild(andOr);
                this.getConstraintBuilder().tryInvalidateLeafLocation();
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d;
        if (this.getChildCount() == 0) {
            d = new Dimension(300, 50);
        } else {
            ConstraintBuilderComp comp = this.getChild(0);
            d = comp.getPreferredSize();
            d.width += 4;
            d.height += 8;
        }
        return d;
    }

    @Override
    public void requestDBUIFocus(boolean select) {
        super.requestDBUIFocus(false);
    }

    public void doLayout() {
        if (this.getConstraintBuilder() != null) {
            this.getConstraintBuilder().layoutChildren();
        }
    }

    public void setLeafLocationValid(boolean valid) {
        this._leafLocationValid = valid;
    }

    public void layoutChildren() {
        if (this.getChildCount() == 0) {
            return;
        }
        Dimension size = this.getSize();
        ConstraintBuilderComp comp = this.getChild(0);
        if (comp instanceof ParentComponent) {
            ParentComponent parent = (ParentComponent)comp;
            if (!this._leafLocationValid) {
                int location = parent.computeLeafLocation();
                parent.setLeafLocation(location);
                this.setLeafLocationValid(true);
            }
            comp.setBounds(2, 0, size.width - 4, size.height);
        } else {
            Dimension prefSize = comp.getPreferredSize();
            int y = (size.height - prefSize.height) / 2;
            comp.setBounds(2, y, prefSize.width, prefSize.height);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.paintDragFeedback(g);
        this.getConstraintBuilder().paintGroupLines(g);
        if (this.hasFocus()) {
            int count = this.getChildCount();
            BorderPainter p = DBUILookAndFeel.getLookAndFeel().getFocusPainter(null);
            Dimension d = this.getSize();
            p.paint(this.getPaintContext(), g, 10, 10, d.width - 20, d.height - 20);
        }
    }

    @Override
    public boolean isFocusTraversable() {
        return this.getChildCount() == 0;
    }

    @Override
    public Component getFocusComponent() {
        if (this.getChildCount() > 0) {
            return this.getChild(0);
        }
        return this;
    }

    @Override
    protected boolean acceptDrag(DropTargetDragEvent dtde) {
        if (this._isChildAParent()) {
            return false;
        }
        return super.acceptDrag(dtde);
    }

    @Override
    protected boolean acceptDrop(DropTargetDropEvent dtde) {
        if (this._isChildAParent()) {
            return false;
        }
        return super.acceptDrop(dtde);
    }

    @Override
    protected void calculateFeedback(int x, int y) {
        if (x < 0 || this._isChildAParent()) {
            this.setFeedbackSprout(null);
            return;
        }
        Sprout feedback = this.getFeedbackSprout();
        if (this.getChildCount() == 0) {
            if (feedback == null) {
                Dimension size = this.getSize();
                int x1 = 0;
                int height = size.height / 2;
                feedback = new Sprout(x1, height, x1 + 6, height);
                this.setFeedbackSprout(feedback);
            }
        } else {
            ConstraintBuilderComp comp = this.getChild(0);
            Rectangle bounds = comp.getBounds();
            int y1 = y < bounds.y ? bounds.y - 4 : bounds.y + bounds.height + 4;
            int x1 = 0;
            int x2 = x1 + 6;
            int y2 = y1;
            if (feedback == null) {
                feedback = new Sprout(x1, y1, x2, y2);
            } else {
                feedback.x1 = x1;
                feedback.y1 = y1;
                feedback.x2 = x2;
                feedback.y2 = y2;
            }
            this.setFeedbackSprout(feedback);
        }
    }

    private boolean _isChildAParent() {
        return this.getChildCount() == 1 && this.getChild(0) instanceof ParentComponent;
    }

    @Override
    protected String getAccessName() {
        return this.getTranslatedAccessibleString(_KEY_ROOT);
    }

    @Override
    protected int getAccessActionCount() {
        return 2;
    }

    @Override
    protected String getAccessActionDescription(int i) {
        switch (i) {
            case 0: {
                return this.getTranslatedAccessibleString("SIMPLIFY");
            }
            case 1: {
                return this.getTranslatedAccessibleString("ADD_CONSTRAINT");
            }
        }
        return null;
    }

    @Override
    protected boolean doAccessAction(int i) {
        boolean ok = false;
        switch (i) {
            case 0: {
                if (this.getChildCount() == 0) break;
                this.getConstraintBuilder().simplifyLayout();
                ok = true;
                break;
            }
            case 1: {
                this.getConstraintBuilder().clearSelection();
                this.getConstraintBuilder().performAdd();
                return true;
            }
        }
        return ok;
    }
}

