/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.columnPropertyEditor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.beans.PropertyDescriptor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import oracle.bali.dbUI.columnPropertyEditor.ColumnWrapper;
import oracle.bali.dbUI.columnPropertyEditor.ColumnWrapperFactory;
import oracle.bali.dbUI.db.Column;
import oracle.bali.dbUI.propertyTable.PropertyTable;
import oracle.bali.dbUI.propertyTable.PropertyTableAdapter;
import oracle.bali.dbUI.propertyTable.PropertyTableCustomizer;
import oracle.bali.dbUI.propertyTable.PropertyTableEvent;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.graphics.Appearance;
import oracle.bali.ewt.grid.AppearanceManager;
import oracle.bali.ewt.grid.CellInputHandler;
import oracle.bali.ewt.grid.ComboBoxInputHandler;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.ProxyInputHandler;
import oracle.bali.ewt.grid.ProxyPainter;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.painter.BorderPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.painter.TruncatingTextPainter;
import oracle.bali.ewt.table.TableEvent;
import oracle.bali.ewt.table.TableMoveAdapter;
import oracle.bali.ewt.table.TableMoveListener;
import oracle.bali.ewt.util.ImmInsets;
import oracle.bali.share.sort.Comparator;

public class ColumnPropertyEditor
extends LWComponent
implements Accessible {
    public static final String PROPERTY_VISUAL_ORDER_CHANGED = "_VISUAL_ORDER_CHANGED";
    static final String[] _DATA_TYPE_NAMES = new String[]{"Boolean", "Byte", "Character", "Double", "Float", "Integer", "Long", "Object", "Short", "String", "Date", "SQL Date", "SQL Time", "SQL Timestamp", "Big Decimal", "Big Integer"};
    static final Class[] _DATA_TYPE_CLASSES = new Class[]{Boolean.class, Byte.class, Character.class, Double.class, Float.class, Integer.class, Long.class, Object.class, Short.class, String.class, java.util.Date.class, Date.class, Time.class, Timestamp.class, BigDecimal.class, BigInteger.class};
    static final String _TABLE_NAME = "tableName";
    static final String _NAME = "name";
    static final String _DISPLAY_NAME = "displayName";
    static final String _WIDTH = "width";
    static final String _VISIBLE = "visible";
    static final String _DATA_TYPE = "dataType";
    static final String _ALLOWS_NULL = "nullAllowed";
    static final String _DEFAULT_VALUE = "defaultValue";
    static final String _KEY_TABLE_NAME = "TABLENAME";
    static final String _KEY_NAME = "NAME";
    static final String _KEY_DISPLAY_NAME = "DISPLAYNAME";
    static final String _KEY_WIDTH = "WIDTH";
    static final String _KEY_VISIBLE = "VISIBLE";
    static final String _KEY_DATA_TYPE = "DATATYPE";
    static final String _KEY_ALLOWS_NULL = "NULLALLOWED";
    static final String _KEY_DEFAULT_VALUE = "DEFAULTVALUE";
    private boolean _dirty;
    private ColumnWrapper[] _wrapperColumns;
    private ColumnWrapperFactory _columnFactory;
    private PropertyTable _pTable;
    private JScrollPane _scrollBox;

    public ColumnPropertyEditor() {
        this(null);
    }

    public ColumnPropertyEditor(Column[] columns) {
        this.setLayout(new BorderLayout());
        this._pTable = new PropertyTable();
        this._pTable.getGrid().setGridSelectionManager(GeneralGridSelectionManager.createSingleCellSelectionManager());
        this._pTable.setCustomizer(new Wrap(this._pTable.getCustomizer()));
        this._pTable.addMoveListener((TableMoveListener)new Move());
        this._pTable.addPropertyTableListener(new Sort());
        this._pTable.getRowHeader().setCanResizeItems(false);
        this._scrollBox = new JScrollPane((Component)((Object)this._pTable));
        this.add("Center", this._scrollBox);
        this.setColumns(columns);
    }

    public void setColumns(Column[] columns) {
        this.freezeRepaints();
        if (columns == null) {
            this._wrapperColumns = null;
        } else {
            this._createColumnWrappers(columns);
        }
        this._dirty = true;
        this._pTable.setObjects(this._wrapperColumns);
        this._updateUI();
        this.unfreezeRepaints();
    }

    public Column[] getColumns() {
        Object[] objects = this._pTable.getObjects();
        if (objects == null) {
            return null;
        }
        Column[] columns = new Column[objects.length];
        Grid grid = this._pTable.getGrid();
        for (int i = 0; i < columns.length; ++i) {
            int visualIndex = grid.getRowVisibleIndex(i);
            ColumnWrapper wrapper = (ColumnWrapper)objects[i];
            columns[visualIndex] = wrapper.getColumn();
        }
        return columns;
    }

    public void setColumnFactory(ColumnWrapperFactory factory) {
        this._columnFactory = factory;
        if (this._wrapperColumns != null) {
            this._createColumnWrappers(this.getColumns());
            this._dirty = true;
            this._pTable.setObjects(this._wrapperColumns);
            this._updateUI();
        }
    }

    public ColumnWrapperFactory getColumnFactory() {
        if (this._columnFactory == null) {
            this._columnFactory = ColumnWrapperFactory.getColumnWrapperFactory();
        }
        return this._columnFactory;
    }

    public ColumnWrapper[] getColumnWrappers() {
        Object[] objects = this._pTable.getObjects();
        if (objects == null) {
            return null;
        }
        ColumnWrapper[] columns = new ColumnWrapper[objects.length];
        Grid grid = this._pTable.getGrid();
        for (int i = 0; i < columns.length; ++i) {
            int visualIndex = grid.getRowVisibleIndex(i);
            columns[visualIndex] = (ColumnWrapper)objects[i];
        }
        return columns;
    }

    public PropertyTableCustomizer getCustomizer() {
        return this._pTable.getCustomizer();
    }

    public void setCustomizer(PropertyTableCustomizer customizer) {
        if (customizer == null) {
            customizer = PropertyTableCustomizer.getPropertyTableCustomizer();
        }
        this._pTable.setCustomizer(new Wrap(customizer));
    }

    public PropertyTable getPropertyTable() {
        return this._pTable;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new JComponent.AccessibleJComponent(){};
        }
        return this.accessibleContext;
    }

    public void addNotify() {
        super.addNotify();
        this._updateUI();
    }

    public Dimension getMaximumSize() {
        Dimension d = this.getPreferredSize();
        d.height += 5;
        return d;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this._pTable.setEnabled(enabled);
        this._scrollBox.setEnabled(enabled);
    }

    public void requestFocus() {
        this._pTable.requestFocus();
    }

    void firePropertyChange() {
        this.firePropertyChange(PROPERTY_VISUAL_ORDER_CHANGED, null, this.getColumns());
    }

    private void _createColumnWrappers(Column[] columns) {
        int count = columns == null ? 0 : columns.length;
        this._wrapperColumns = count == 0 ? null : new ColumnWrapper[count];
        ColumnWrapperFactory factory = this.getColumnFactory();
        for (int i = 0; i < count; ++i) {
            this._wrapperColumns[i] = factory.createColumnWrapper(columns[i]);
        }
    }

    private void _updateUI() {
        if (!this._dirty) {
            return;
        }
        this._dirty = false;
        this.freezeRepaints();
        Grid grid = this._pTable.getGrid();
        int count = grid.getColumnCount();
        for (int i = 0; i < count; ++i) {
            PropertyDescriptor desc = this._pTable.getPropertyAt(i);
            String name = desc.getName();
            if (_TABLE_NAME.equals(name)) {
                this._pTable.setColumnVisibleIndex(i, 0);
                continue;
            }
            if (_NAME.equals(name)) {
                this._pTable.setColumnVisibleIndex(i, 1);
                continue;
            }
            if (_DISPLAY_NAME.equals(name)) {
                this._pTable.setColumnVisibleIndex(i, 2);
                continue;
            }
            if (_WIDTH.equals(name)) {
                this._pTable.setColumnVisibleIndex(i, 3);
                continue;
            }
            if (!_VISIBLE.equals(name)) continue;
            this._pTable.setColumnVisibleIndex(i, 4);
        }
        int column = grid.getNextVisibleColumn(-1);
        int row = grid.getNextVisibleRow(-1);
        if (column != -1 && row != -1) {
            grid.requestFocus(column, row, null);
        }
        this.unfreezeRepaints();
    }

    int getColumnWidth(PropertyDescriptor desc, FontMetrics metrics, Locale locale, int testWidth) {
        int columnIndex = this._pTable.getPropertyIndex(desc);
        int width = 0;
        Grid grid = this._pTable.getGrid();
        Painter painter = grid.getColumnPainter(columnIndex);
        AppearanceManager am = grid.getAppearanceManager();
        int rowCount = grid.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            ImmInsets insets;
            int extra = 0;
            PaintContext context = grid.getCellPaintContext(columnIndex, i);
            Dimension prefSize = painter.getPreferredSize(context);
            Appearance a = am.getCellPaintingAppearance(columnIndex, i);
            BorderPainter border = a.getBorderPainter();
            if (border != null) {
                insets = border.getInsets(context);
                extra += insets.left + insets.right;
            }
            insets = a.getInsets();
            prefSize.width += (extra += insets.left + insets.right);
            if (prefSize.width <= width) continue;
            width = prefSize.width;
        }
        Header columnHeader = this._pTable.getColumnHeader();
        PaintContext hContext = columnHeader.getItemPaintContext(columnIndex);
        ImmInsets headerInsets = columnHeader.getItemAppearance(columnIndex).getInsets();
        int headerSize = headerInsets.left + headerInsets.right;
        BorderPainter headerBorder = columnHeader.getHeaderItemBorderPainter();
        headerInsets = headerBorder.getInsets(hContext);
        headerSize += headerInsets.left + headerInsets.right;
        Painter hPainter = columnHeader.getPainter(columnIndex);
        if ((headerSize += hPainter.getPreferredSize((PaintContext)hContext).width) > width) {
            width = headerSize;
        }
        return width + 4;
    }

    private class Wrap
    extends PropertyTableCustomizer {
        private PropertyTableCustomizer _toWrap;
        private Painter _dataTypePainter;
        private Painter _defaultValuePainter;
        private CellInputHandler _defaultValueInputHandler;
        private CellInputHandler _dataTypeInputHandler;

        Wrap(PropertyTableCustomizer toWrap) {
            this._toWrap = toWrap;
        }

        @Override
        public String getDisplayName(PropertyDescriptor desc, Locale locale) {
            String name = desc.getName();
            String displayName = ColumnPropertyEditor._TABLE_NAME.equals(name) ? this._getString(ColumnPropertyEditor._KEY_TABLE_NAME, locale) : (ColumnPropertyEditor._NAME.equals(name) ? this._getString(ColumnPropertyEditor._KEY_NAME, locale) : (ColumnPropertyEditor._DISPLAY_NAME.equals(name) ? this._getString(ColumnPropertyEditor._KEY_DISPLAY_NAME, locale) : (ColumnPropertyEditor._WIDTH.equals(name) ? this._getString(ColumnPropertyEditor._KEY_WIDTH, locale) : (ColumnPropertyEditor._VISIBLE.equals(name) ? this._getString(ColumnPropertyEditor._KEY_VISIBLE, locale) : (ColumnPropertyEditor._DATA_TYPE.equals(name) ? this._getString(ColumnPropertyEditor._KEY_DATA_TYPE, locale) : (ColumnPropertyEditor._ALLOWS_NULL.equals(name) ? this._getString(ColumnPropertyEditor._KEY_ALLOWS_NULL, locale) : (ColumnPropertyEditor._DEFAULT_VALUE.equals(name) ? this._getString(ColumnPropertyEditor._KEY_DEFAULT_VALUE, locale) : this._toWrap.getDisplayName(desc, locale))))))));
            return displayName;
        }

        @Override
        public boolean displayProperty(PropertyDescriptor desc) {
            String name = desc.getName();
            if ("column".equals(name)) {
                return false;
            }
            if (ColumnPropertyEditor._DATA_TYPE.equals(name)) {
                return true;
            }
            return this._toWrap.displayProperty(desc);
        }

        @Override
        public int getColumnWidth(PropertyDescriptor desc, FontMetrics metrics, Locale locale) {
            int size = this._toWrap.getColumnWidth(desc, metrics, locale);
            return ColumnPropertyEditor.this.getColumnWidth(desc, metrics, locale, size);
        }

        @Override
        public Painter getPainter(PropertyDescriptor desc) {
            if (ColumnPropertyEditor._DATA_TYPE.equals(desc.getName())) {
                return this._getDataTypePainter();
            }
            if (ColumnPropertyEditor._DEFAULT_VALUE.equals(desc.getName())) {
                return this._getDefaultValuePainter();
            }
            return this._toWrap.getPainter(desc);
        }

        @Override
        public CellInputHandler getCellInputHandler(PropertyDescriptor desc) {
            String name = desc.getName();
            if (desc.getWriteMethod() != null) {
                if (ColumnPropertyEditor._DATA_TYPE.equals(name)) {
                    return this._getDataTypeInputHandler();
                }
                if (ColumnPropertyEditor._DEFAULT_VALUE.equals(name)) {
                    return this._getDefaultValueInputHandler();
                }
            }
            return this._toWrap.getCellInputHandler(desc);
        }

        @Override
        public Comparator getComparator(PropertyDescriptor desc) {
            return this._toWrap.getComparator(desc);
        }

        private String _getString(String key, Locale locale) {
            ResourceBundle b = ResourceBundle.getBundle("oracle.bali.dbUI.resource.DBUIBundle", locale);
            return b.getString(key);
        }

        private Painter _getDataTypePainter() {
            if (this._dataTypePainter == null) {
                this._dataTypePainter = new DTP();
            }
            return this._dataTypePainter;
        }

        private Painter _getDefaultValuePainter() {
            if (this._defaultValuePainter == null) {
                this._defaultValuePainter = new DVP();
            }
            return this._defaultValuePainter;
        }

        private CellInputHandler _getDataTypeInputHandler() {
            if (this._dataTypeInputHandler == null) {
                this._dataTypeInputHandler = new DTH();
            }
            return this._dataTypeInputHandler;
        }

        private CellInputHandler _getDefaultValueInputHandler() {
            this._defaultValueInputHandler = new DVH();
            return this._defaultValueInputHandler;
        }

        private class DTH
        extends ComboBoxInputHandler {
            public DTH() {
                this.setItems(_DATA_TYPE_NAMES);
            }

            public void startEdit(Grid grid, int column, int row, Object data) {
                if (data != null) {
                    boolean index = false;
                    for (int i = 0; i < _DATA_TYPE_CLASSES.length; ++i) {
                        if (_DATA_TYPE_CLASSES[i] != data) continue;
                        data = _DATA_TYPE_NAMES[i];
                        break;
                    }
                }
                super.startEdit(grid, column, row, data);
            }

            public Object commitEdit(Grid grid, int column, int row) {
                Object data = super.commitEdit(grid, column, row);
                boolean index = false;
                for (int i = 0; i < _DATA_TYPE_NAMES.length; ++i) {
                    if (!_DATA_TYPE_NAMES[i].equals(data)) continue;
                    data = _DATA_TYPE_CLASSES[i];
                    break;
                }
                return data;
            }
        }

        private class DVH
        extends ProxyInputHandler {
            private Vector _handlers = new Vector(1);
            private Vector _types = new Vector(1);
            private CellInputHandler _currentHandler;

            private DVH() {
            }

            public CellInputHandler getCellInputHandler(Grid grid, int column, int row) {
                int count = grid.getRowCount();
                if (this._handlers.size() != count) {
                    this._handlers.setSize(count);
                    this._types.setSize(count);
                }
                Object[] objects = ColumnPropertyEditor.this.getPropertyTable().getObjects();
                ColumnWrapper wrapper = (ColumnWrapper)objects[row];
                Class type = wrapper.getColumn().getDataType();
                if (this._handlers.elementAt(row) == null || !type.equals(this._types.elementAt(row))) {
                    this._handlers.setElementAt(Wrap.this._toWrap.getCellInputHandler(type), row);
                    this._types.setElementAt(type, row);
                }
                return (CellInputHandler)this._handlers.elementAt(row);
            }
        }

        private class DVP
        extends ProxyPainter {
            private DVP() {
            }

            public Painter getPainter(Grid grid, int column, int row) {
                Object[] objects = ColumnPropertyEditor.this.getPropertyTable().getObjects();
                ColumnWrapper wrapper = (ColumnWrapper)objects[row];
                Class type = wrapper.getColumn().getDataType();
                return Wrap.this._toWrap.getPainter(type);
            }
        }

        private class DTP
        extends TruncatingTextPainter {
            private DTP() {
            }

            protected String getStringData(PaintContext context) {
                String data = super.getStringData(context);
                return data == null ? data : data.substring(data.lastIndexOf(".") + 1);
            }
        }
    }

    private class Sort
    extends PropertyTableAdapter {
        private Sort() {
        }

        @Override
        public void columnSorted(PropertyTableEvent e) {
            ColumnPropertyEditor.this.firePropertyChange();
        }
    }

    private class Move
    extends TableMoveAdapter {
        private Move() {
        }

        public void rowMoved(TableEvent e) {
            ColumnPropertyEditor.this.firePropertyChange();
        }
    }
}

