/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.template;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import oracle.ide.model.Element;
import oracle.ide.model.TechId;
import oracle.ide.model.TechnologyRegistry;
import oracle.ide.model.TechnologyScope;
import oracle.ide.util.Assert;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.template.AbstractTemplate;
import oracle.jdeveloper.template.TemplateData;

public class ProjectTemplate
extends AbstractTemplate {
    static final String PROJECT_TEMPLATE = "projectTemplate";
    static final String PROJECT_NAME = "projectName";

    public ProjectTemplate() {
        this(HashStructure.newInstance());
        this.setTemplateClass(ProjectTemplate.class.getName());
    }

    public ProjectTemplate(HashStructure hash) {
        super(hash);
        this.setValid(this.validate());
    }

    @Override
    public void initializeFromExtensionHook(HashStructure hash, TemplateData lookup) {
        List techScopeKeys;
        super.initializeFromExtensionHook(hash, lookup);
        if (hash.containsKey("technologyScope") && (techScopeKeys = hash.getAsList("technologyScope/technologyKey")) != null) {
            ArrayList<String> keys = new ArrayList<String>();
            for (Object techScopeKey : techScopeKeys) {
                HashStructure h = (HashStructure)techScopeKey;
                String s = h.getString("#text");
                keys.add(s);
            }
            TechnologyScope scope = new TechnologyScope();
            scope.setTechnologyKeys(keys.toArray(new String[keys.size()]));
            this.setTechnologyScope(scope);
        }
        if (hash.containsKey("creationListener")) {
            this.setCreationListenerClassName(this.getTextFromHook(hash, "creationListener"));
        }
        if (hash.containsKey("excludeFromGallery")) {
            this.setExcludeFromGallery(Boolean.valueOf(this.getTextFromHook(hash, "excludeFromGallery")));
        }
        this.setValid(this.validate());
    }

    @Override
    public String getContainerNameKey() {
        return PROJECT_NAME;
    }

    @Override
    protected Icon getDefaultIcon() {
        return OracleIcons.getIcon((String)"project.png");
    }

    @Override
    public Iterator<Element> getChildren() {
        return Arrays.asList(new Element[0]).iterator();
    }

    public TechnologyScope getTechnologyScope() {
        TechnologyScope techScope = new TechnologyScope();
        List keys = this.getTechnologyKeys();
        TechnologyRegistry techRegistry = TechnologyRegistry.getInstance();
        for (Object key : keys) {
            TechId techId = techRegistry.getTechId((String)key);
            Assert.check((techId != null ? 1 : 0) != 0);
            techScope.add(techId);
        }
        return techScope;
    }

    protected List getTechnologyKeys() {
        HashStructure techScopeHash = this._hash.getHashStructure("technologyScope");
        if (techScopeHash == null) {
            return Collections.emptyList();
        }
        return techScopeHash.getAsList("technologyKey");
    }

    public void setTechnologyScope(TechnologyScope scope) {
        HashStructure techScopeHash = this._hash.getOrCreateHashStructure("technologyScope");
        ListStructure techKeyList = techScopeHash.getOrCreateListStructure("technologyKey");
        techKeyList.clear();
        for (String key : scope.getTechnologyKeys()) {
            techKeyList.add((Object)key);
        }
    }

    public void setCreationListenerClassName(String className) {
        this._hash.putString("creationListener", className);
    }

    public String getCreationListenerClassName() {
        return this._hash.getString("creationListener");
    }

    public void setExcludeFromGallery(boolean exclude) {
        this._hash.putBoolean("excludeFromGallery", exclude);
    }

    public boolean isExcludeFromGallery() {
        return this._hash.getBoolean("excludeFromGallery", false);
    }

    @Override
    protected boolean validate() {
        List keys = this.getTechnologyKeys();
        TechnologyRegistry reg = TechnologyRegistry.getInstance();
        for (Object key : keys) {
            if (reg.getTechId((String)key) != null) continue;
            return false;
        }
        if (this.getCreationListenerClassName() != null && this.getOwningExtensionId() == null) {
            return false;
        }
        return super.validate();
    }
}

