/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.template;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import oracle.ide.model.Element;
import oracle.ide.util.Assert;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.template.AbstractTemplate;
import oracle.jdeveloper.template.AddonPageTemplate;
import oracle.jdeveloper.template.ProjectTemplate;
import oracle.jdeveloper.template.TemplateData;
import oracle.jdeveloper.template.TemplateFactory;
import oracle.jdeveloper.template.TemplateUtils;

public final class ApplicationTemplate
extends AbstractTemplate {
    static final String APPLICATION_TEMPLATE = "applicationTemplate";
    static final String APPLICATION_NAME = "applicationName";
    static final String PROJECT_TEMPLATES = "projectTemplates";
    static final String APPLICATION_ADDON_PAGE = "applicationAddonPage";
    static final String APPLICATION_ADDON_PAGE_GROUPS = "addonPageGroups";
    static final String APPLICATION_ADDON_PAGE_GROUP = "addonPageGroup";
    private List<ProjectTemplate> projectTemplates_ = null;
    private List<AddonPageTemplate> addonPageTemplates_ = null;
    private List<String> addonPageGroups_ = null;

    public ApplicationTemplate() {
        super(HashStructure.newInstance());
        this.setTemplateClass(ApplicationTemplate.class.getName());
    }

    public ApplicationTemplate(HashStructure hash) {
        super(hash);
        this.setValid(this.validate());
    }

    @Override
    public void initializeFromExtensionHook(HashStructure hash, TemplateData lookup) {
        super.initializeFromExtensionHook(hash, lookup);
        List list = hash.getAsList("projectTemplates/projectTemplate");
        if (list != null) {
            this.removeAllProjectTemplates();
            TemplateFactory tf = TemplateFactory.getInstance();
            for (HashStructure h : list) {
                try {
                    AbstractTemplate t = tf.createTemplateFromExtensionHook(h, ProjectTemplate.class, lookup);
                    if (t instanceof ProjectTemplate) {
                        this.addProjectTemplate((ProjectTemplate)t);
                        continue;
                    }
                    throw new IllegalArgumentException("Only ProjectTemplate instances allowed");
                }
                catch (ClassNotFoundException e) {
                    TemplateUtils.logTemplateCreationException(h, e);
                }
                catch (NoSuchMethodException e) {
                    TemplateUtils.logTemplateCreationException(h, e);
                }
                catch (InstantiationException e) {
                    TemplateUtils.logTemplateCreationException(h, e);
                }
                catch (IllegalAccessException e) {
                    TemplateUtils.logTemplateCreationException(h, e);
                }
                catch (InvocationTargetException e) {
                    TemplateUtils.logTemplateCreationException(h, e);
                }
            }
        }
        this.setValid(this.validate());
        this.addonPageGroups_ = this.readAddonPageGroups(hash);
    }

    public List<String> getAddonPageGroups() {
        return this.addonPageGroups_;
    }

    private List<String> readAddonPageGroups(HashStructure hash) {
        List list;
        LinkedList<String> result = null;
        if (hash.containsKey(APPLICATION_ADDON_PAGE_GROUPS) && (list = hash.getAsList(APPLICATION_ADDON_PAGE_GROUPS)) != null) {
            if (list.size() > 0) {
                result = new LinkedList<String>();
            }
            for (HashStructure item : list) {
                if (!item.containsKey(APPLICATION_ADDON_PAGE_GROUP)) continue;
                String group = this.getTextFromHook(item, APPLICATION_ADDON_PAGE_GROUP);
                result.add(group);
            }
        }
        return result;
    }

    @Override
    public String getContainerNameKey() {
        return APPLICATION_NAME;
    }

    public List<ProjectTemplate> getProjectTemplates() {
        return Collections.unmodifiableList(this.loadProjectTemplates());
    }

    public void setProjectTemplates(List<ProjectTemplate> templates) {
        this.removeAllProjectTemplates();
        for (ProjectTemplate t : templates) {
            this.addProjectTemplate(t);
        }
    }

    public void addProjectTemplate(ProjectTemplate template) {
        this.addProjectTemplate(this.loadProjectTemplates().size(), template);
    }

    public void addProjectTemplate(int index, ProjectTemplate template) {
        this.loadProjectTemplates().add(index, template);
        this.addToHash(index, template);
    }

    private void addToHash(int index, ProjectTemplate template) {
        ListStructure projectTemplates = this._hash.getOrCreateListStructure(PROJECT_TEMPLATES);
        HashStructure copy = HashStructure.newInstance();
        template.getData().copyTo(copy);
        projectTemplates.add(index, (Object)copy);
    }

    public void removeProjectTemplate(int index) {
        this.loadProjectTemplates().remove(index);
        ListStructure projectTemplates = this._hash.getOrCreateListStructure(PROJECT_TEMPLATES);
        projectTemplates.remove(index);
    }

    public void removeProjectTemplate(ProjectTemplate template) {
        int i = 0;
        while (i < this.loadProjectTemplates().size()) {
            ProjectTemplate t = this.loadProjectTemplates().get(i);
            if (t.equals(template)) {
                this.removeProjectTemplate(i);
                continue;
            }
            ++i;
        }
    }

    private synchronized List<ProjectTemplate> loadProjectTemplates() {
        if (this.projectTemplates_ == null) {
            this.projectTemplates_ = new ArrayList<ProjectTemplate>();
            List projectsHash = this._hash.getAsList(PROJECT_TEMPLATES);
            if (projectsHash == null) {
                return this.projectTemplates_;
            }
            for (HashStructure hash : projectsHash) {
                String id = AbstractTemplate.getTemplateId(hash);
                HashStructure projectHash = HashStructure.newInstance();
                Assert.check((id != null ? 1 : 0) != 0);
                AbstractTemplate template = null;
                if (this.parent_ != null) {
                    template = this.parent_.findTemplateById(id);
                }
                if (template != null) {
                    template.getData().copyTo(projectHash);
                }
                String[] keys = hash.keySet().toArray(new String[hash.keySet().size()]);
                hash.copyTo(projectHash, keys);
                try {
                    ProjectTemplate projectTemplate = (ProjectTemplate)TemplateFactory.getInstance().createTemplate(projectHash);
                    if (projectTemplate != null && projectTemplate instanceof ProjectTemplate) {
                        this.projectTemplates_.add(projectTemplate);
                        continue;
                    }
                    String msg = "Project Template with Id " + id + " not found";
                    throw new InstantiationException(msg);
                }
                catch (ClassNotFoundException e) {
                    TemplateUtils.logTemplateCreationException(projectHash, e);
                }
                catch (NoSuchMethodException e) {
                    TemplateUtils.logTemplateCreationException(projectHash, e);
                }
                catch (InstantiationException e) {
                    TemplateUtils.logTemplateCreationException(projectHash, e);
                }
                catch (IllegalAccessException e) {
                    TemplateUtils.logTemplateCreationException(projectHash, e);
                }
                catch (InvocationTargetException e) {
                    TemplateUtils.logTemplateCreationException(projectHash, e);
                }
            }
        }
        return this.projectTemplates_;
    }

    public void removeAllProjectTemplates() {
        ListStructure list;
        if (this.projectTemplates_ != null) {
            this.projectTemplates_.clear();
        }
        if ((list = this._hash.getListStructure(PROJECT_TEMPLATES)) != null) {
            list.clear();
        }
    }

    @Override
    protected String getChildTemplatesKey() {
        return PROJECT_TEMPLATES;
    }

    @Override
    protected Icon getDefaultIcon() {
        return OracleIcons.getIcon((String)"application.png");
    }

    @Override
    public Iterator<Element> getChildren() {
        return new AbstractTemplate.ElementIterator(Collections.unmodifiableList(this.loadProjectTemplates()).iterator());
    }

    public void addAddonPage(AddonPageTemplate addonPage) {
        if (this.addonPageTemplates_ == null) {
            this.addonPageTemplates_ = new ArrayList<AddonPageTemplate>();
        }
        this.addonPageTemplates_.add(addonPage);
    }

    public List<AddonPageTemplate> getAddonPages() {
        return this.addonPageTemplates_;
    }
}

