/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfdtinternal.model.dvt.util.gui.layout;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.beans.PropertyVetoException;
import oracle.adfdtinternal.model.dvt.util.gui.layout.AbstractCrosstabHeader;
import oracle.adfdtinternal.model.dvt.util.gui.layout.Crosstab;
import oracle.bali.ewt.pivot.AbstractPivotHeaderCell;
import oracle.bali.ewt.selection.Cell;
import oracle.bali.ewt.selection.OneDSelection;
import oracle.bali.ewt.selection.TwoDSelection;

public class RowHeader
extends AbstractCrosstabHeader {
    public RowHeader(Crosstab crosstab, int edge) {
        super(crosstab, 1, edge);
        this.setDefaultColumnWidth(30);
        this.getColumnHeader().setCanResizeItems(false);
        this.setColumnHeaderHeight(10);
        this.setOutline(true);
    }

    @Override
    public void setItems(String[] items) {
        super.setItems(items);
        this._setSizes();
    }

    @Override
    public int getSelectedIndex() {
        TwoDSelection s = this.getGrid().getSelection();
        OneDSelection columns = s.getColumnSelection();
        int index = -1;
        if (!columns.isEmpty()) {
            index = columns.getSingleItem();
        } else {
            Cell cell = s.getSingleCell();
            if (cell != null) {
                index = cell.row;
            }
        }
        return index;
    }

    @Override
    protected AbstractCrosstabHeader.CrosstabModel createModel() {
        return new RowModel();
    }

    @Override
    protected void selectionChanged() {
        this.getCrosstab().rowSelectionChanged();
    }

    @Override
    protected TwoDSelection getNewFocusSelection() {
        return new TwoDSelection(0, 0);
    }

    @Override
    protected void focusLost() {
        try {
            this.getColumnHeader().deselectAll();
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    protected void paintDropFeedback(Graphics g, int dropIndex, boolean isSwap) {
        if (isSwap) {
            super.paintDropFeedback(g, dropIndex, isSwap);
        } else {
            Color oldColor = g.getColor();
            g.setColor(Color.black);
            int count = this.getGrid().getRowCount();
            int y = dropIndex != count ? this.getGrid().getRowPosition(dropIndex) : (count == 0 ? 0 : this.getRowGeometryManager().getTotalSize());
            g.fillRect(0, y, this.getWidth(), 4);
            if (oldColor != null) {
                g.setColor(oldColor);
            }
        }
    }

    protected int getDropIndex(Point p, boolean inHeader, boolean isSwap) {
        if (inHeader) {
            return super.getDropIndex(p, inHeader, isSwap);
        }
        p = this.getGrid().convertOuterToCanvas(p.x, p.y);
        int index = this.getGrid().getRowAt(p.y);
        if (index == -1) {
            if (p.y > this.getRowGeometryManager().getTotalSize()) {
                index = this.getGrid().getRowCount();
            }
        } else {
            int size;
            int pos = this.getGrid().getRowPosition(index);
            if (p.y > pos + (size = this.getGrid().getRowHeight(index)) / 2) {
                ++index;
            }
        }
        return index;
    }

    private void _setSizes() {
        int count = this.getModel().getColumnCount();
        if (count == 0) {
            return;
        }
        int item = count - 1;
        int size = this._getColumnSize(item);
        for (int i = 0; i < item; ++i) {
            int extra = (item - i) * this.getDefaultColumnWidth();
            int temp = this._getColumnSize(i) - extra;
            if (temp <= size) continue;
            size = temp;
        }
        this.setColumnWidth(item, size + 1);
        this.invalidate();
    }

    private int _getColumnSize(int index) {
        return this.getElementWidth(this.getItem(index));
    }

    private class RowModel
    extends AbstractCrosstabHeader.CrosstabModel {
        private RowModel() {
        }

        @Override
        public int getColumnCount() {
            return this.getRowCount();
        }

        @Override
        protected AbstractPivotHeaderCell createCell(int index, int count) {
            AbstractCrosstabHeader.ExtendedCell cell = new AbstractCrosstabHeader.ExtendedCell(0, count, index, 1, this.getElement(index));
            cell.setIndent(index);
            return cell;
        }

        @Override
        protected void fireEvents(int oldCount, int newCount) {
            int diff = newCount - oldCount;
            if (diff > 0) {
                this.fireModelEvent(2001, 0, diff);
                this.fireModelEvent(2004, 0, diff);
            } else if (diff < 0) {
                this.fireModelEvent(2002, 0, -diff);
                this.fireModelEvent(2005, 0, -diff);
            }
        }
    }
}

