/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.usages;

import java.awt.Component;
import java.awt.Window;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.usages.res.Messages;
import oracle.dbtools.raptor.usages.ui.UsagesPrefsPanel;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.docking.WindowManagerStartingController;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.javatools.dialogs.ExceptionDialog;

public class OptInHandler {
    private int maxCountWait = 7;
    private static final int timeInterval = 1000;
    private AtomicInteger count = new AtomicInteger(0);

    public void showPrompt() {
        new Timer().schedule((TimerTask)new DialogWaitingTask(), 0L);
    }

    private Runnable showDialog() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Namespace namespace = new Namespace();
                namespace.put("generic-PropertyStorage", (Object)Preferences.getPreferences());
                TraversableContext traversableContext = new TraversableContext(namespace, 1);
                UsagesPrefsPanel usagesPrefsPanel = new UsagesPrefsPanel(false);
                usagesPrefsPanel.onEntry(traversableContext);
                JEWTDialog jEWTDialog = JEWTDialog.createDialog((Component)Ide.getMainWindow(), (String)Messages.getString("USAGES_OPT_IN_OUT_DIALOG_TITLE"), (int)1);
                jEWTDialog.setResizable(true);
                jEWTDialog.setContent((Component)((Object)usagesPrefsPanel));
                jEWTDialog.setInitialFocus(usagesPrefsPanel.getDefaultFocusComponent());
                jEWTDialog.setMaximumInitialSize(400, 300);
                jEWTDialog.pack();
                jEWTDialog.runDialog();
                try {
                    usagesPrefsPanel.onExit(traversableContext);
                }
                catch (TraversalException traversalException) {
                    ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)((Object)traversalException));
                }
            }
        };
        return runnable;
    }

    private class DialogWaitingTask
    extends TimerTask {
        private DialogWaitingTask() {
        }

        @Override
        public void run() {
            WindowManagerStartingController windowManagerStartingController = WindowManagerStartingController.getInstance();
            if (windowManagerStartingController == null || !windowManagerStartingController.isSplashScreenShowing() && !windowManagerStartingController.isStarting() || OptInHandler.this.count.get() > OptInHandler.this.maxCountWait) {
                SwingUtilities.invokeLater(OptInHandler.this.showDialog());
                if (Boolean.getBoolean("ide.debugbuild")) {
                    Logger.getAnonymousLogger().info("Usage Tracker window shown after " + OptInHandler.this.count + " sec. SplashScreen showing :" + windowManagerStartingController.isSplashScreenShowing());
                }
                OptInHandler.this.count = new AtomicInteger(11);
                return;
            }
            OptInHandler.this.count.incrementAndGet();
            new Timer().schedule((TimerTask)new DialogWaitingTask(), 1000L);
        }
    }
}

