/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.standalone.actions;

import java.awt.Component;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.controls.sqldialog.ActionSql;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.navigator.db.DatabaseConnection;
import oracle.dbtools.raptor.standalone.ExtrasArb;
import oracle.dbtools.raptor.standalone.actions.ResetPasswordPanel;
import oracle.dbtools.raptor.standalone.connection.ConnectionUtils;
import oracle.dbtools.raptor.standalone.connection.RaptorConnectionCreator;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Element;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.DatabaseConnectionStores;

public class ResetPasswordAction
extends AbstractMenuAction {
    private static final String RESET_MODE = "ResetMode";
    private static final String PWD_DDL = "alter user #USERNAME# identified by \"#NEWPWD#\" replace \"#OLDPWD#\"";
    private static final String USERNAME = "USERNAME";
    private static final String NEW_PWD = "NEWPWD";
    private static final String OLD_PWD = "OLDPWD";
    private static final Logger LOGGER = Logger.getLogger(ResetPasswordAction.class.getName());
    private static Boolean s_ociAvailable;

    private static boolean isOCIAvailable() {
        if (s_ociAvailable == null) {
            s_ociAvailable = Connections.isOCIDriverAvailable();
        }
        return s_ociAvailable;
    }

    public boolean isEnabled(Context context) {
        boolean bl = false;
        Element[] elementArray = context.getSelection();
        if (elementArray != null && elementArray.length == 1 && elementArray[0] instanceof DatabaseConnection) {
            ResetMode resetMode = null;
            if (((DatabaseConnection)elementArray[0]).isConnectionOpen()) {
                resetMode = ResetMode.ALTER;
            } else if (ConnectionUtils.isThinResetAvailable()) {
                resetMode = ResetMode.THIN;
            } else if (ResetPasswordAction.isOCIAvailable()) {
                resetMode = ResetMode.OCI;
            }
            if (resetMode != null) {
                bl = true;
                context.setProperty(RESET_MODE, (Object)resetMode);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launch() {
        boolean bl = false;
        DBObject dBObject = this.getDBObject();
        String string = dBObject.getConnectionName();
        Element element = dBObject.getElement();
        ResetMode resetMode = (ResetMode)((Object)this.getContext().getProperty(RESET_MODE));
        if (resetMode == null) {
            return;
        }
        Properties properties = Connections.getInstance().getConnectionInfo(string);
        String string2 = properties.getProperty("user");
        if (ResetPasswordPanel.promptForNewPassword(properties)) {
            String string3;
            Object object;
            Object object2;
            Properties properties2 = new Properties();
            properties2.putAll((Map<?, ?>)properties);
            if (resetMode == ResetMode.ALTER) {
                object2 = dBObject.getConnection();
                bl = this.setPassword((Connection)object2, properties2);
            } else {
                object2 = null;
                object = new RaptorConnectionCreator();
                string3 = properties2.getProperty("OCINewPassword");
                try {
                    if (resetMode == ResetMode.OCI) {
                        properties2.setProperty("customUrl", ConnectionUtils.getOCIUrl(properties2));
                    } else if (resetMode == ResetMode.THIN) {
                        properties2.remove("OCINewPassword");
                        properties2.setProperty("oracle.jdbc.newPassword", string3);
                    }
                    object2 = ((RaptorConnectionCreator)((Object)object)).getConnection(properties2);
                    bl = true;
                }
                catch (SQLException sQLException) {
                    ExceptionHandler.handleException((Exception)sQLException, (String)string);
                }
                finally {
                    if (object2 != null) {
                        try {
                            object2.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                if (bl) {
                    Properties properties3 = new Properties();
                    properties3.putAll((Map<?, ?>)properties2);
                    properties3.setProperty("password", string3);
                    properties3.remove("OCINewPassword");
                    properties3.remove("oracle.jdbc.newPassword");
                    try {
                        Connection connection = ((RaptorConnectionCreator)((Object)object)).getConnection(properties3);
                        if (connection != null) {
                            connection.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)ExtrasArb.getString("RESET_ERROR"), (String)ExtrasArb.getString("RESET_ERROR_TITLE"), null);
                        bl = false;
                    }
                }
            }
            if (bl && ModelUtil.areEqual((Object)string2, (Object)properties.getProperty("user")) && Boolean.valueOf(properties.getProperty("SavePassword", Boolean.TRUE.toString())).booleanValue()) {
                properties.setProperty("password", properties.getProperty("OCINewPassword"));
                properties.remove("OCINewPassword");
                object2 = Connections.getStoreName((String)string);
                object = Connections.getConnectionName((String)string);
                string3 = DatabaseConnectionStores.getInstance().getStore((String)object2);
                try {
                    string3.updateConnection((String)object, (String)object, properties, true);
                }
                catch (ConnectionException connectionException) {
                    LOGGER.log(Level.SEVERE, connectionException.getLocalizedMessage());
                }
            }
        }
    }

    public void setArgs(String string) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setPassword(Connection connection, Properties properties) {
        boolean bl = true;
        PreparedStatement preparedStatement = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(USERNAME, properties.getProperty("user"));
        hashMap.put(OLD_PWD, properties.getProperty("password"));
        hashMap.put(NEW_PWD, properties.getProperty("OCINewPassword"));
        String string = ActionSql.manualSubstitute((String)PWD_DDL, hashMap);
        try {
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.executeUpdate();
        }
        catch (Exception exception) {
            ExceptionHandler.handleException((Throwable)exception);
            bl = false;
        }
        finally {
            try {
                preparedStatement.close();
            }
            catch (Exception exception) {}
        }
        return bl;
    }

    private static enum ResetMode {
        OCI,
        THIN,
        ALTER;

    }
}

