/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.logging;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.logging.LoggerNameCompletion;
import oracle.dbtools.raptor.ExtrasMessages;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuFilter;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.controls.ToggleAction;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.IdeUtil;
import oracle.javatools.controls.completionfield.CompletionTextField;
import oracle.javatools.controls.completionfield.FieldInsightProvider;

public class LoggingController
implements ContextMenuListener,
Controller {
    private int _currRow;
    private int _cmdIdOff = Ide.findOrCreateCmdID((String)"CHANGE_LOGGING_LEVEL.OFF");
    private int _cmdIdSevere = Ide.findOrCreateCmdID((String)"CHANGE_LOGGING_LEVEL.SEVERE");
    private int _cmdIdWarn = Ide.findOrCreateCmdID((String)"CHANGE_LOGGING_LEVEL.WARN");
    private int _cmdIdInfo = Ide.findOrCreateCmdID((String)"CHANGE_LOGGING_LEVEL.INFO");
    private int _cmdIdConfig = Ide.findOrCreateCmdID((String)"CHANGE_LOGGING_LEVEL.CONFIG");
    private int _cmdIdFine = Ide.findOrCreateCmdID((String)"CHANGE_LOGGING_LEVEL.FINE");
    private int _cmdIdFiner = Ide.findOrCreateCmdID((String)"CHANGE_LOGGING_LEVEL.FINER");
    private int _cmdIdFinest = Ide.findOrCreateCmdID((String)"CHANGE_LOGGING_LEVEL.FINEST");
    private int _cmdIdAll = Ide.findOrCreateCmdID((String)"CHANGE_LOGGING_LEVEL.ALL");
    private int _cmdIdChange = Ide.findOrCreateCmdID((String)"JAVA_UTIL_LOGGING_CHANGE");
    private int _cmdIdView = Ide.findOrCreateCmdID((String)"JAVA_UTIL_LOGGING_VIEW");
    private JMenu _menu;
    private JTable _table;
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private ButtonGroup mLevelGroup = new ButtonGroup();
    private Map<Level, JCheckBoxMenuItem> mLogMenus = new HashMap<Level, JCheckBoxMenuItem>();

    public LoggingController(JTable jTable) {
        this._table = jTable;
    }

    private JCheckBoxMenuItem createLogLevelMenuItem(int n, Level level) {
        String string = level.getLocalizedName();
        IdeAction ideAction = IdeAction.findOrCreate((int)n, null, (String)string);
        ideAction.setEnabled(true);
        ideAction.addController((Controller)this);
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem((Action)ideAction);
        jCheckBoxMenuItem.setSelected(false);
        this.mLevelGroup.add(jCheckBoxMenuItem);
        this.mLogMenus.put(level, jCheckBoxMenuItem);
        return jCheckBoxMenuItem;
    }

    private JCheckBoxMenuItem getLogLevelMenuItem(Level level) {
        JCheckBoxMenuItem jCheckBoxMenuItem = null;
        if (level != null) {
            jCheckBoxMenuItem = this.mLogMenus.get(level);
        }
        return jCheckBoxMenuItem != null ? jCheckBoxMenuItem : this.mLogMenus.get(Level.OFF);
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public void menuWillShow(ContextMenu contextMenu) {
        Object object = contextMenu.getContext().getEvent().getSource();
        if (this._table == object) {
            this._currRow = this._table.rowAtPoint(((MouseEvent)contextMenu.getContext().getEvent()).getPoint());
            Level level = this.getLoggerLevel(this._currRow);
            IdeAction ideAction = IdeAction.get((int)this._cmdIdView);
            ideAction.addController((Controller)this);
            JMenuItem jMenuItem = contextMenu.createMenuItem((ToggleAction)ideAction);
            contextMenu.add((Component)jMenuItem);
            contextMenu.add((Component)this.getMenu(level));
            ideAction = IdeAction.get((int)this._cmdIdChange);
            ideAction.addController((Controller)this);
            jMenuItem = contextMenu.createMenuItem((ToggleAction)ideAction, MenuConstants.SECTION_LOG_WINDOW_CTXT_MENU);
            contextMenu.add((Component)jMenuItem);
            IdeAction ideAction2 = IdeAction.get((int)12);
            jMenuItem = contextMenu.createMenuItem((ToggleAction)ideAction2, MenuConstants.WEIGHT_LOG_WINDOW_SAVE_AS);
            contextMenu.add((Component)jMenuItem);
            ideAction2.setEnabled(true);
            contextMenu.addMenuFilter(new MenuFilter(){

                public boolean accept(Component component) {
                    return !(component instanceof JMenuItem) || ((JMenuItem)component).getAction() == null || !(((JMenuItem)component).getAction() instanceof IdeAction) || ((IdeAction)((JMenuItem)component).getAction()).getCommandId() != 12;
                }
            });
        }
    }

    private JMenu getMenu(Level level) {
        if (this._menu == null) {
            this._menu = new JMenu(ExtrasMessages.getString((String)"LoggingController.22"));
            this._menu.add(this.createLogLevelMenuItem(this._cmdIdOff, Level.OFF));
            this._menu.add(this.createLogLevelMenuItem(this._cmdIdSevere, Level.SEVERE));
            this._menu.add(this.createLogLevelMenuItem(this._cmdIdWarn, Level.WARNING));
            this._menu.add(this.createLogLevelMenuItem(this._cmdIdInfo, Level.INFO));
            this._menu.add(this.createLogLevelMenuItem(this._cmdIdConfig, Level.CONFIG));
            this._menu.add(this.createLogLevelMenuItem(this._cmdIdFine, Level.FINE));
            this._menu.add(this.createLogLevelMenuItem(this._cmdIdFiner, Level.FINER));
            this._menu.add(this.createLogLevelMenuItem(this._cmdIdFinest, Level.FINEST));
            this._menu.add(this.createLogLevelMenuItem(this._cmdIdAll, Level.ALL));
        }
        JCheckBoxMenuItem jCheckBoxMenuItem = this.getLogLevelMenuItem(level);
        jCheckBoxMenuItem.setSelected(true);
        return this._menu;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == this._cmdIdOff) {
            this.setLoggerLevel(Level.OFF);
            return true;
        }
        if (n == this._cmdIdSevere) {
            this.setLoggerLevel(Level.SEVERE);
            return true;
        }
        if (n == this._cmdIdWarn) {
            this.setLoggerLevel(Level.WARNING);
            return true;
        }
        if (n == this._cmdIdInfo) {
            this.setLoggerLevel(Level.INFO);
            return true;
        }
        if (n == this._cmdIdConfig) {
            this.setLoggerLevel(Level.CONFIG);
            return true;
        }
        if (n == this._cmdIdFine) {
            this.setLoggerLevel(Level.FINE);
            return true;
        }
        if (n == this._cmdIdFiner) {
            this.setLoggerLevel(Level.FINER);
            return true;
        }
        if (n == this._cmdIdFinest) {
            this.setLoggerLevel(Level.FINEST);
            return true;
        }
        if (n == this._cmdIdAll) {
            this.setLoggerLevel(Level.ALL);
            return true;
        }
        if (n == this._cmdIdChange) {
            this.promptAndChange();
            return true;
        }
        if (n == this._cmdIdView) {
            this.viewAll();
            return true;
        }
        return false;
    }

    private void setLoggerLevel(Level level) {
        this.getLogger(this._currRow).setLevel(level);
    }

    public void clearAll() {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this._table.getModel();
        for (int i = defaultTableModel.getRowCount() - 1; i >= 0; --i) {
            defaultTableModel.removeRow(i);
        }
    }

    private Logger getLogger(int n) {
        String string = (String)this._table.getValueAt(n, 3);
        return Logger.getLogger(string != null ? string : "");
    }

    private Level getLoggerLevel(int n) {
        Level level = null;
        for (Logger logger = this.getLogger(n); logger != null && (level = logger.getLevel()) == null; logger = logger.getParent()) {
        }
        return level != null ? level : Level.OFF;
    }

    public boolean update(IdeAction ideAction, Context context) {
        if (ideAction.getCommandId() == 11) {
            ideAction.setEnabled(true);
            return true;
        }
        return false;
    }

    private void viewAll() {
        Object object;
        final DefaultTableModel defaultTableModel = new DefaultTableModel();
        defaultTableModel.addColumn(ExtrasMessages.getString((String)"LoggingController.24"));
        defaultTableModel.addColumn(ExtrasMessages.getString((String)"LoggingController.25"));
        Enumeration<String> enumeration = LogManager.getLogManager().getLoggerNames();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        Collections.sort(arrayList);
        for (String object22 : arrayList) {
            object = Logger.getLogger(object22);
            Level level = object != null && ((Logger)object).getLevel() != null ? ((Logger)object).getLevel() : null;
            Object[] objectArray = new Object[]{object22, level};
            if (object22 == null) continue;
            defaultTableModel.addRow(objectArray);
        }
        JTable jTable = new JTable(defaultTableModel);
        JComboBox<Level> jComboBox = this.createLevelComboBox();
        jTable.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(jComboBox));
        object = new JScrollPane(jTable);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)object, "Center");
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ((JEWTDialog)actionEvent.getSource()).closeDialog(true);
                for (int i = 0; i < defaultTableModel.getRowCount(); ++i) {
                    Logger logger;
                    Level level;
                    Level level2;
                    String string = (String)defaultTableModel.getValueAt(i, 0);
                    Level level3 = (Level)defaultTableModel.getValueAt(i, 1);
                    if (level3 == null || (level2 = level3) == (level = (logger = Logger.getLogger(string)).getLevel())) continue;
                    logger.setLevel(level2);
                    LoggingController.this.logger.info(ExtrasMessages.getString((String)"LoggingController.26") + string + ExtrasMessages.getString((String)"LoggingController.27") + level2.getName());
                }
            }
        };
        LoggingController.showPanelAsDialog(jPanel, ExtrasMessages.getString((String)"LoggingController.28"), actionListener, 10, true);
    }

    private void promptAndChange() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        final CompletionTextField completionTextField = new CompletionTextField();
        completionTextField.getPopupHandler().registerInsightProvider((FieldInsightProvider)new LoggerNameCompletion());
        final JComboBox<Level> jComboBox = this.createLevelComboBox();
        jPanel.add((Component)completionTextField, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
        jPanel.add(jComboBox, new GridBagConstraints(0, 1, 1, 1, 0.5, 0.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ((JEWTDialog)actionEvent.getSource()).closeDialog(true);
                Logger logger = Logger.getLogger(completionTextField.getText());
                Level level = (Level)jComboBox.getSelectedItem();
                if (level != null) {
                    logger.setLevel(level);
                }
                LoggingController.this.logger.info(ExtrasMessages.getString((String)"LoggingController.29") + completionTextField.getText() + ExtrasMessages.getString((String)"LoggingController.30") + level);
            }
        };
        LoggingController.showPanelAsDialog(jPanel, ExtrasMessages.getString((String)"LoggingController.31"), actionListener, 10, true);
    }

    private static void showPanelAsDialog(JPanel jPanel, String string, ActionListener actionListener, int n, boolean bl) {
        HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel, "f1_changelogginglevel_html");
        Dimension dimension = jPanel.getPreferredSize();
        dimension.setSize(dimension.getWidth() + 150.0, dimension.getHeight() + 100.0);
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)jPanel, null, (String)string, (int)n);
        if (actionListener != null) {
            jEWTDialog.addActionListener(actionListener);
        }
        jEWTDialog.setModal(bl);
        jEWTDialog.pack();
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)jEWTDialog);
        jEWTDialog.setVisible(true);
    }

    private JComboBox<Level> createLevelComboBox() {
        JComboBox<Level> jComboBox = new JComboBox<Level>((ComboBoxModel<Level>)new NonNullableComboBoxModel());
        jComboBox.addItem(Level.OFF);
        jComboBox.addItem(Level.SEVERE);
        jComboBox.addItem(Level.WARNING);
        jComboBox.addItem(Level.INFO);
        jComboBox.addItem(Level.CONFIG);
        jComboBox.addItem(Level.FINE);
        jComboBox.addItem(Level.FINER);
        jComboBox.addItem(Level.FINEST);
        jComboBox.addItem(Level.ALL);
        jComboBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
                return super.getListCellRendererComponent(jList, object instanceof Level ? ((Level)object).getLocalizedName() : object, n, bl, bl2);
            }
        });
        return jComboBox;
    }
}

