/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.spatial.actions.validate;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.spatial.SpatialArb;
import oracle.dbtools.spatial.dialogs.validate.controller.ValidateGeometryController;
import oracle.dbtools.spatial.dialogs.validate.model.ValidateGeometryModel;
import oracle.dbtools.spatial.dialogs.validate.view.ValidateGeometryView;
import oracle.ide.help.HelpSystem;

public class ValidateGeometry
extends AbstractMenuAction {
    private JEWTDialog dlg;
    private static ValidateGeometryModel model = null;
    private static ValidateGeometryView view = null;
    private static ValidateGeometryController controller = null;
    private boolean dimValidation = false;
    private boolean columnSelected = false;
    JPanel panel = null;
    private DBObject dbObject;

    public void launch() {
        this.dbObject = this.getDBObject();
        String string = this.dbObject.getObjectType();
        String string2 = this.dbObject.getChildName();
        if (model == null) {
            model = new ValidateGeometryModel();
            view = new ValidateGeometryView(model);
            controller = new ValidateGeometryController(model, view);
        }
        model.setDimValidation(this.dimValidation);
        model.setDBObject(this.dbObject);
        if (this.columnSelected) {
            model.setCurrrentColumn(string2);
            model.setIsColumnSelected(true);
        } else {
            model.setIsColumnSelected(false);
        }
        controller.removeListeners();
        this.panel = view.createMainPanel();
        HelpSystem.getHelpSystem().registerTopic((JComponent)this.panel, "f1_validategeometry_html");
        this.dlg = UIUtils.createPanelDialog((JPanel)this.panel, (String)SpatialArb.getString("ValidateGeometry"), null, (boolean)true);
        controller.populateSpatialModel(this.dlg);
        this.dlg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = model.getFirstColumn();
                if (string == null) {
                    ValidateGeometry.this.dlg.dispose();
                    return;
                }
                if (model.getIsColumnSelected() && !model.isSingleColumnSpatial()) {
                    ValidateGeometry.this.dlg.dispose();
                    return;
                }
                boolean bl = view.checkInput();
                if (bl) {
                    model.setSelectedIdColumns(view.getIdColumnValues());
                    controller.applyModelData();
                    ValidateGeometry.this.panel.validate();
                    ValidateGeometry.this.panel.repaint();
                }
            }
        });
        this.dlg.runDialog();
        view.closeResultsPanel();
    }

    public void setArgs(String string) {
        if (string != null) {
            if (string.indexOf("DIMENSIONVALIDATION") >= 0) {
                this.dimValidation = true;
            }
            if (string.indexOf("COLUMN") >= 0) {
                this.columnSelected = true;
            }
        }
    }
}

