/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.options;

import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.editor.BasicCaret;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.util.Copyable;

public final class EditorOptions
extends HashStructureAdapter
implements Copyable {
    public static final String KEY_SETTINGS = "EditorOptions";
    private static final String TAB_SIZE = "tabSize";
    private static final String USE_SPACES = "useSpaces";
    private static final String SHOW_LINE_TOTAL = "showLineTotal";
    private static final String AUTO_INDENT = "autoIndent";
    private static final String USE_JUMP_SCROLL = "useJumpScroll";
    private static final String USE_SMART_HOME = "useSmartHome";
    private static final String USE_SMART_END = "useSmartEnd";
    private static final String USE_BLOCK_ON_SELECTION = "useBlockOnSelection";
    private static final String USE_CASE_DELIMITED_WORD = "useCaseDelimitedWord";
    private static final String USE_LINE_START_FOR_WORD = "useLineStartForWord";
    private static final String USE_LINE_END_FOR_WORD = "useLineEndForWord";
    private static final String IMPORTS_COPY_PASTE = "importsCopyPaste";
    private static final String INDENT_COPY_PASTE = "indentCopyPaste";
    private static final String REFORMAT_COPY_PASTE = "reformatCopyPaste";
    private static final String ESCAPE_STRING_PASTE = "escapeStringPaste";
    private static final String CUT_COPY_LINE = "cutCopyLine";
    private static final String SHOW_TOOLBAR = "showToolbar";
    private static final String REUSE_UNDO_EVENT = "reuseUndoEvent";
    private static final String REUSE_DOC_EVENT = "reuseDocEvent";
    private static final String USE_EXPENSIVE_PASTE_CHECKING = "useExpensivePasteChecking";
    private static final String MIDDLE_BUTTON_BEHAVIOR = "middleButtonBehavior";
    private static final String LONG_LINE_OPEN_WARNING = "longLineOpenLimit";
    private static final String LONG_LINE_OPEN = "longLineOpen";
    private static final String AUTO_SURROUND_SELECTION = "autoSurroundSelection";

    public EditorOptions() {
        this(HashStructure.newInstance());
    }

    private EditorOptions(HashStructure hash) {
        super(hash);
    }

    public static EditorOptions getInstance(PropertyStorage prefs) {
        return new EditorOptions(EditorOptions.findOrCreate((PropertyStorage)prefs, (String)KEY_SETTINGS));
    }

    public int getTabSize() {
        return this._hash.getInt(TAB_SIZE, 2);
    }

    public void setTabSize(int tabSize) {
        this._hash.putInt(TAB_SIZE, tabSize);
    }

    public boolean getUseSpaces() {
        return this._hash.getBoolean(USE_SPACES, true);
    }

    public void setUseSpaces(boolean useSpaces) {
        this._hash.putBoolean(USE_SPACES, useSpaces);
    }

    @Deprecated
    public boolean getShowTotalLines() {
        return this._hash.getBoolean(SHOW_LINE_TOTAL, false);
    }

    @Deprecated
    public void setShowTotalLines(boolean showTotalLines) {
        this._hash.putBoolean(SHOW_LINE_TOTAL, showTotalLines);
    }

    public boolean getAutoIndent() {
        return this._hash.getBoolean(AUTO_INDENT, true);
    }

    public void setAutoIndent(boolean autoIndent) {
        this._hash.putBoolean(AUTO_INDENT, autoIndent);
    }

    public boolean getUseJumpScroll() {
        return this._hash.getBoolean(USE_JUMP_SCROLL, false);
    }

    public void setUseJumpScroll(boolean useJumpScroll) {
        this._hash.putBoolean(USE_JUMP_SCROLL, useJumpScroll);
    }

    public boolean getUseSmartHome() {
        return this._hash.getBoolean(USE_SMART_HOME, true);
    }

    public void setUseSmartHome(boolean useSmartHome) {
        this._hash.putBoolean(USE_SMART_HOME, useSmartHome);
    }

    public boolean getUseSmartEnd() {
        return this._hash.getBoolean(USE_SMART_END, false);
    }

    public void setUseSmartEnd(boolean useSmartEnd) {
        this._hash.putBoolean(USE_SMART_END, useSmartEnd);
    }

    public boolean getUseBlockOnSelection() {
        return this._hash.getBoolean(USE_BLOCK_ON_SELECTION, true);
    }

    public void setUseBlockOnSelection(boolean useBlockOnSelection) {
        this._hash.putBoolean(USE_BLOCK_ON_SELECTION, useBlockOnSelection);
    }

    public boolean getUseCaseDelimitedWord() {
        return this._hash.getBoolean(USE_CASE_DELIMITED_WORD, true);
    }

    public void setUseCaseDelimitedWord(boolean useCaseDelimitedWord) {
        this._hash.putBoolean(USE_CASE_DELIMITED_WORD, useCaseDelimitedWord);
    }

    public boolean getUseLineStartForWord() {
        return this._hash.getBoolean(USE_LINE_START_FOR_WORD, false);
    }

    public void setUseLineStartForWord(boolean useLineStartForWord) {
        this._hash.putBoolean(USE_LINE_START_FOR_WORD, useLineStartForWord);
    }

    public boolean getUseLineEndForWord() {
        return this._hash.getBoolean(USE_LINE_END_FOR_WORD, true);
    }

    public void setUseLineEndForWord(boolean useLineEndForWord) {
        this._hash.putBoolean(USE_LINE_END_FOR_WORD, useLineEndForWord);
    }

    public boolean getImportsCopyPaste() {
        return this._hash.getBoolean(IMPORTS_COPY_PASTE, true);
    }

    public void setImportsCopyPaste(boolean smartCopyPaste) {
        this._hash.putBoolean(IMPORTS_COPY_PASTE, smartCopyPaste);
    }

    public boolean getIndentCopyPaste() {
        return this._hash.getBoolean(INDENT_COPY_PASTE, true);
    }

    public void setIndentCopyPaste(boolean smartCopyPaste) {
        this._hash.putBoolean(INDENT_COPY_PASTE, smartCopyPaste);
    }

    public boolean getReformatCopyPaste() {
        return this._hash.getBoolean(REFORMAT_COPY_PASTE, false);
    }

    public void setReformatCopyPaste(boolean smartCopyPaste) {
        this._hash.putBoolean(REFORMAT_COPY_PASTE, smartCopyPaste);
    }

    public boolean getEscapeStringPaste() {
        return this._hash.getBoolean(ESCAPE_STRING_PASTE, true);
    }

    public void setEscapeStringPaste(boolean val) {
        this._hash.putBoolean(ESCAPE_STRING_PASTE, val);
    }

    public boolean getCutCopyLine() {
        return this._hash.getBoolean(CUT_COPY_LINE, true);
    }

    public void setCutCopyLine(boolean cutCopyLine) {
        this._hash.putBoolean(CUT_COPY_LINE, cutCopyLine);
    }

    public boolean getShowToolbar() {
        return this._hash.getBoolean(SHOW_TOOLBAR, true);
    }

    public void setShowToolbar(boolean showToolbar) {
        this._hash.putBoolean(SHOW_TOOLBAR, showToolbar);
    }

    public boolean getReuseUndoEvent() {
        return this._hash.getBoolean(REUSE_UNDO_EVENT, true);
    }

    public void setReuseUndoEvent(boolean reuseUndoEvent) {
        this._hash.putBoolean(REUSE_UNDO_EVENT, reuseUndoEvent);
    }

    public boolean getReuseDocEvent() {
        return this._hash.getBoolean(REUSE_DOC_EVENT, true);
    }

    public void setReuseDocEvent(boolean reuseDocEvent) {
        this._hash.putBoolean(REUSE_DOC_EVENT, reuseDocEvent);
    }

    public boolean getUseExpensivePasteChecking() {
        return this._hash.getBoolean(USE_EXPENSIVE_PASTE_CHECKING, false);
    }

    public void setUseExpensivePasteChecking(boolean useExpensivePasteChecking) {
        this._hash.putBoolean(USE_EXPENSIVE_PASTE_CHECKING, useExpensivePasteChecking);
    }

    public BasicCaret.MiddleButtonBehavior getMiddleButtonBehavior() {
        BasicCaret.MiddleButtonBehavior defaultBehavior = (BasicCaret.MiddleButtonBehavior)EditorProperties.getProperties().getProperty("middle-button-behavior");
        String s = this._hash.getString(MIDDLE_BUTTON_BEHAVIOR, defaultBehavior.name());
        BasicCaret.MiddleButtonBehavior behavior = BasicCaret.MiddleButtonBehavior.valueOf((String)s);
        return behavior;
    }

    public void setMiddleButtonBehavior(BasicCaret.MiddleButtonBehavior behavior) {
        this._hash.putString(MIDDLE_BUTTON_BEHAVIOR, behavior.name());
        EditorProperties.getProperties().putProperty("middle-button-behavior", (Object)behavior);
    }

    public int getLongLineWarningLimit() {
        return this._hash.getInt(LONG_LINE_OPEN_WARNING, 10000);
    }

    public void setLongLineWarningLimit(int lineLengthLimit) {
        this._hash.putInt(LONG_LINE_OPEN_WARNING, lineLengthLimit);
    }

    public boolean isLongLineWarning() {
        return this._hash.getBoolean(LONG_LINE_OPEN, true);
    }

    public void setLongLineWarning(boolean lineLengthLimitSet) {
        this._hash.putBoolean(LONG_LINE_OPEN, lineLengthLimitSet);
    }

    public void addStructureChangeListener(StructureChangeListener listener) {
        this._hash.addStructureChangeListener(listener);
    }

    public void removeStructureChangeListener(StructureChangeListener listener) {
        this._hash.removeStructureChangeListener(listener);
    }

    public boolean getAutoSurroundSelection() {
        return this._hash.getBoolean(AUTO_SURROUND_SELECTION, true);
    }

    public void setAutoSurroundSelection(boolean autoSurroundSelection) {
        this._hash.putBoolean(AUTO_SURROUND_SELECTION, autoSurroundSelection);
    }
}

