/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor;

import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import oracle.ide.ceditor.CodeEditorConstants;
import oracle.ide.controller.Command;

public final class UndoWrapperCommand
extends Command {
    private Object updater;
    private UndoableEdit edit;

    public UndoWrapperCommand(UndoableEdit edit, Object updater) {
        super(CodeEditorConstants.UNDO_WRAPPER_CMD_ID, 0);
        this.edit = edit;
        this.updater = updater;
    }

    public int doit() {
        int status = 0;
        if (this.edit.canRedo()) {
            try {
                this.edit.redo();
                status = 0;
            }
            catch (CannotRedoException cannotRedoException) {
                // empty catch block
            }
        }
        return status;
    }

    public int undo() {
        int status = 1;
        if (this.edit.canUndo()) {
            try {
                this.edit.undo();
                status = 0;
            }
            catch (CannotUndoException cannotUndoException) {
                // empty catch block
            }
        }
        return status;
    }

    public String getName() {
        return this.edit.getPresentationName();
    }
}

